/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.mechanism;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import uk.ac.ebi.reactionblast.mechanism.RMatrix;

public class GlobalEntropyCalculator
implements Serializable {
    private static final long serialVersionUID = 7879978965972591251L;
    private final HashMap<Integer, RMatrix> matrixMap = new HashMap();
    private final HashMap<String, HashMap<Integer, Integer>> typeMap = new HashMap();
    private final HashMap<String, Integer> freqMap = new HashMap();

    public void addMatrix(int index, RMatrix m) throws CDKException {
        this.matrixMap.put(index, m);
        Object key = "";
        HashMap<Integer, Integer> val = null;
        for (int i = 0; i < m.getRowDimension(); ++i) {
            for (int j = i + 1; j < m.getColumnDimension(); ++j) {
                Integer frequency;
                IAtom ai = m.getReactantAtom(i);
                IAtom aj = m.getReactantAtom(j);
                key = ai.getSymbol().compareTo(aj.getSymbol()) <= 0 ? ai.getSymbol() + "." + aj.getSymbol() : aj.getSymbol() + "." + ai.getSymbol();
                val = this.typeMap.get(key);
                if (val == null) {
                    val = new HashMap();
                    this.typeMap.put((String)key, val);
                    this.freqMap.put((String)key, 0);
                }
                if ((frequency = val.get(Double.valueOf(m.getValue(i, j)).intValue())) == null) {
                    frequency = 0;
                }
                val.put(Double.valueOf(m.getValue(i, j)).intValue(), frequency + 1);
                this.freqMap.put((String)key, this.freqMap.get(key) + 1);
            }
        }
    }

    public synchronized double getGlobalEntropy(int idx) throws CDKException {
        RMatrix m = this.matrixMap.get(idx);
        double lH = 0.0;
        Object key = "";
        HashMap<Integer, Integer> val = null;
        for (int i = 0; i < m.getRowDimension(); ++i) {
            for (int j = i + 1; j < m.getColumnDimension(); ++j) {
                IAtom ai = m.getReactantAtom(i);
                IAtom aj = m.getReactantAtom(j);
                key = ai.getSymbol().compareTo(aj.getSymbol()) <= 0 ? ai.getSymbol() + "." + aj.getSymbol() : aj.getSymbol() + "." + ai.getSymbol();
                int matValue = (int)m.getValue(i, j);
                val = this.typeMap.get(key);
                int freq = val.get(matValue);
                double px = freq / this.freqMap.get(key);
                if (px == 0.0) continue;
                lH += px * Math.log10(px) / Math.log10(2.0);
            }
        }
        return -lH / (double)((m.getRowDimension() * m.getColumnDimension() - m.getRowDimension()) / 2);
    }

    public synchronized Iterable<Integer> getKeySet() {
        return this.matrixMap.keySet();
    }

    public synchronized int getMatrixIndex(RMatrix m) throws CDKException {
        int index = -1;
        if (!this.matrixMap.containsValue(m)) {
            throw new CDKException("GlobalEntropyCalculator.getMatrixIndex: The matrix has not been found.");
        }
        for (Map.Entry<Integer, RMatrix> e : this.matrixMap.entrySet()) {
            if (e.getValue() != m) continue;
            index = e.getKey();
        }
        return index;
    }

    public synchronized int getMatrixCount() {
        return this.matrixMap.size();
    }

    public synchronized RMatrix getMatrix(int index) throws CDKException {
        if (!this.matrixMap.containsKey(index)) {
            throw new CDKException("The index of the required RMatrix is out of bouns");
        }
        return this.matrixMap.get(index);
    }
}

