/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.mechanism;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import java.util.logging.Level;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import uk.ac.ebi.reactionblast.mechanism.BEMatrix;
import uk.ac.ebi.reactionblast.mechanism.helper.AtomAtomMappingContainer;
import uk.ac.ebi.reactionblast.tools.EBIMatrix;

public final class RMatrix
extends EBIMatrix
implements Serializable {
    private static final String NEW_LINE = System.getProperty("line.separator");
    private static final long serialVersionUID = 7057060562283378684L;
    private static final ILoggingTool LOGGER = LoggingToolFactory.createLoggingTool(RMatrix.class);
    private BEMatrix reactantBEMatrix = null;
    private BEMatrix productBEMatrix = null;
    private AtomAtomMappingContainer myMapping = null;
    private boolean DEBUG = false;

    public RMatrix(BEMatrix reactantBE, BEMatrix productBE, AtomAtomMappingContainer mapping) throws Exception {
        super(reactantBE.getRowDimension(), reactantBE.getRowDimension());
        int expectedOverlap = this.countAtomOverlap(reactantBE.getAtoms(), productBE.getAtoms());
        if (this.DEBUG) {
            System.out.println("expectedOverlap " + expectedOverlap + ", " + mapping.getSize());
        }
        int umapped_atoms_remaining = productBE.getRowDimension() - (mapping.getSize() + 1);
        if (expectedOverlap != mapping.getSize() & umapped_atoms_remaining != 0) {
            LOGGER.debug("Core Reactant Atoms: " + (reactantBE.getRowDimension() - 1));
            LOGGER.debug("Core Product Atoms: " + (productBE.getRowDimension() - 1));
            LOGGER.debug("Mapping Atoms: " + mapping.getSize());
            throw new Exception("Unable to construct a reaction matrix; " + umapped_atoms_remaining + " atom(s) remain unmapped!.");
        }
        this.initMatrix(0.0);
        this.reactantBEMatrix = reactantBE;
        this.productBEMatrix = productBE;
        this.myMapping = mapping;
        try {
            this.reactantBEMatrix.setAromaticBond();
            this.productBEMatrix.setAromaticBond();
        }
        catch (CDKException ex) {
            LOGGER.error(Level.SEVERE, null, ex);
        }
        ArrayList<IAtom> orderedBEMatrixAtomArray = new ArrayList<IAtom>();
        for (int i = 0; i < this.reactantBEMatrix.getRowDimension() - 1; ++i) {
            IAtom atomR = this.reactantBEMatrix.getAtom(i);
            IAtom mappedProductAtom = this.myMapping.getMappedProductAtom(atomR);
            if (mappedProductAtom == null) continue;
            orderedBEMatrixAtomArray.add(mappedProductAtom);
        }
        int[] canonicalOrderedAtomArray = this.productBEMatrix.orderAtomArray(orderedBEMatrixAtomArray);
        for (int i = 0; i < this.getMappedAtomCount(); ++i) {
            String p_id_I = this.productBEMatrix.getAtom(i).getID();
            String r_id_I = this.reactantBEMatrix.getAtom(i).getID();
            for (int j = 0; j < this.getMappedAtomCount(); ++j) {
                String p_id_J = this.productBEMatrix.getAtom(j).getID();
                String r_id_J = this.reactantBEMatrix.getAtom(j).getID();
                if (!r_id_I.equals(p_id_I) || !r_id_J.equals(p_id_J)) continue;
                double value = this.productBEMatrix.getValue(i, j) - this.reactantBEMatrix.getValue(i, j);
                boolean aromaticFlag = this.isAromaticChange(i, j);
                if (aromaticFlag && value != 0.0) {
                    super.setValue(i, j, 0.0);
                    continue;
                }
                super.setValue(i, j, value);
            }
        }
        if (this.DEBUG) {
            System.out.println("BE-React " + reactantBE.toString());
            System.out.println("BE-Prod " + productBE.toString());
            System.out.println("R " + this.toString());
        }
    }

    private synchronized boolean isAromaticChange(int IndexI, int IndexJ) throws CDKException {
        IAtom ra1 = this.getReactantBEMatrix().getAtom(IndexI);
        IAtom pa1 = this.getProductBEMatrix().getAtom(IndexI);
        IAtom ra2 = this.getReactantBEMatrix().getAtom(IndexJ);
        IAtom pa2 = this.getProductBEMatrix().getAtom(IndexJ);
        IBond rb = this.getReactantBEMatrix().getAtomContainer(ra1).getBond(ra1, ra2);
        IBond pb = this.getProductBEMatrix().getAtomContainer(pa1).getBond(pa1, pa2);
        return rb != null && pb != null && rb.getFlag(2) && pb.getFlag(2) && rb.getFlag(32) && pb.getFlag(32);
    }

    public synchronized IAtom getProductAtom(int idx) throws CDKException {
        IAtom ret = null;
        if (idx < this.getProductBEMatrix().getRowDimension() && idx > -1) {
            ret = this.getProductBEMatrix().getAtom(idx);
        }
        return ret;
    }

    public synchronized IAtom getReactantAtom(int idx) throws CDKException {
        IAtom ret = null;
        if (idx < this.getReactantBEMatrix().getRowDimension() && idx > -1) {
            ret = this.getReactantBEMatrix().getAtom(idx);
        }
        return ret;
    }

    public synchronized List<IAtom> getReactantsAtomArray() {
        return this.getReactantBEMatrix().getAtoms();
    }

    public synchronized List<IAtom> getProductsAtomArray() {
        return this.getProductBEMatrix().getAtoms();
    }

    public synchronized int getValueByReactantAtoms(String atomID1, String atomID2) throws CDKException {
        int res = 0;
        for (int i = 0; i < this.getRowDimension() - 1; ++i) {
            for (int j = 0; j < this.getColumnDimension() - 1; ++j) {
                if (!this.getReactantBEMatrix().getAtom(i).getID().equals(atomID1) || !this.getReactantBEMatrix().getAtom(j).getID().equals(atomID2)) continue;
                res = (int)this.getValue(i, j);
            }
        }
        return res;
    }

    public synchronized int getValueByProductAtoms(String atomID1, String atomID2) throws CDKException {
        int res = 0;
        for (int i = 0; i < this.getRowDimension() - 1; ++i) {
            for (int j = 0; j < this.getColumnDimension() - 1; ++j) {
                if (!this.getProductBEMatrix().getAtom(i).getID().equals(atomID1) || !this.getProductBEMatrix().getAtom(j).getID().equals(atomID2)) continue;
                res = (int)this.getValue(i, j);
            }
        }
        return res;
    }

    public synchronized int getAbsChanges() {
        int acc = 0;
        for (int i = 0; i < this.getRowDimension(); ++i) {
            for (int j = 0; j < this.getColumnDimension(); ++j) {
                acc += Math.abs((int)this.getValue(i, j));
            }
        }
        return acc;
    }

    protected synchronized int getMappedAtomCount() {
        return this.getMyMapping().getSize();
    }

    protected synchronized int getAtomCountWithoutHydrogens() {
        return this.getMyMapping().getSizeNoHydrogens();
    }

    public synchronized BEMatrix getReactantBEMatrix() {
        return this.reactantBEMatrix;
    }

    public synchronized void setReactantBEMatrix(BEMatrix reactantBEMatrix) {
        this.reactantBEMatrix = reactantBEMatrix;
    }

    public synchronized BEMatrix getProductBEMatrix() {
        return this.productBEMatrix;
    }

    public synchronized void setProductBEMatrix(BEMatrix productBEMatrix) {
        this.productBEMatrix = productBEMatrix;
    }

    public synchronized AtomAtomMappingContainer getMyMapping() {
        return this.myMapping;
    }

    public synchronized void setMyMapping(AtomAtomMappingContainer myMapping) {
        this.myMapping = myMapping;
    }

    @Override
    public synchronized String toString() {
        int i;
        StringBuilder result = new StringBuilder();
        result.append("\t");
        for (i = 0; i < this.getRowDimension() - 1; ++i) {
            result.append("\t").append(i);
        }
        result.append(NEW_LINE);
        result.append("\t");
        for (i = 0; i < this.getRowDimension() - 1; ++i) {
            try {
                result.append("\t").append(this.getReactantBEMatrix().getAtom(i).getSymbol()).append(this.getReactantBEMatrix().getAtom(i).getID());
                continue;
            }
            catch (CDKException ex) {
                LOGGER.error(Level.SEVERE, null, ex);
            }
        }
        result.append(NEW_LINE);
        result.append("\t");
        for (i = 0; i < this.getRowDimension() - 1; ++i) {
            try {
                result.append("\t").append(this.getProductBEMatrix().getAtom(i).getSymbol()).append(this.getProductBEMatrix().getAtom(i).getID());
                continue;
            }
            catch (CDKException ex) {
                LOGGER.error(Level.SEVERE, null, ex);
            }
        }
        result.append(NEW_LINE);
        for (i = 0; i < this.getRowDimension() - 1; ++i) {
            if (i == this.getRowDimension() - 1) {
                result.append("\t");
            } else {
                try {
                    result.append(this.getReactantBEMatrix().getAtom(i).getSymbol());
                    result.append(this.getReactantBEMatrix().getAtom(i).getID());
                    result.append("\t");
                    result.append(this.getProductBEMatrix().getAtom(i).getSymbol());
                    result.append(this.getProductBEMatrix().getAtom(i).getID());
                    result.append("\t");
                }
                catch (CDKException ex) {
                    LOGGER.error(Level.SEVERE, null, ex);
                }
            }
            for (int j = 0; j < this.getColumnDimension() - 1; ++j) {
                result.append(this.getValue(i, j)).append("\t");
            }
            result.append(NEW_LINE);
        }
        return result.toString();
    }

    private int countAtomOverlap(List<IAtom> atomsE, List<IAtom> atomsP) {
        TreeMap atomUniqueCounter1 = new TreeMap();
        TreeMap atomUniqueCounter2 = new TreeMap();
        TreeMap atomOverlap = new TreeMap();
        int leftHandAtomCount = 0;
        leftHandAtomCount = atomsE.stream().filter(a -> !a.getSymbol().equals("H")).map(a -> {
            if (!atomUniqueCounter1.containsKey(a.getSymbol())) {
                atomUniqueCounter1.put(a.getSymbol(), 1);
            } else {
                int counter = (Integer)atomUniqueCounter1.get(a.getSymbol()) + 1;
                atomUniqueCounter1.put(a.getSymbol(), counter);
            }
            return a;
        }).map(_item -> 1).reduce(leftHandAtomCount, Integer::sum);
        int rightHandAtomCount = 0;
        rightHandAtomCount = atomsP.stream().filter(b -> !b.getSymbol().equals("H")).map(b -> {
            if (!atomUniqueCounter2.containsKey(b.getSymbol())) {
                atomUniqueCounter2.put(b.getSymbol(), 1);
            } else {
                int counter = (Integer)atomUniqueCounter2.get(b.getSymbol()) + 1;
                atomUniqueCounter2.put(b.getSymbol(), counter);
            }
            return b;
        }).map(_item -> 1).reduce(rightHandAtomCount, Integer::sum);
        atomUniqueCounter1.keySet().stream().filter(s -> atomUniqueCounter2.containsKey(s)).forEach(s -> {
            Integer overlap = (Integer)atomUniqueCounter1.get(s) <= (Integer)atomUniqueCounter2.get(s) ? (Integer)atomUniqueCounter1.get(s) : (Integer)atomUniqueCounter2.get(s);
            atomOverlap.put(s, overlap);
        });
        int total = 0;
        total = atomOverlap.values().stream().map(i -> i).reduce(total, Integer::sum);
        if (this.DEBUG) {
            System.out.println("LEFT " + atomUniqueCounter1);
            System.out.println("atomUniqueCounter1 " + leftHandAtomCount);
            System.out.println("RIGHT " + atomUniqueCounter2);
            System.out.println("atomUniqueCounter2 " + rightHandAtomCount);
            System.out.println("overlap " + total);
        }
        return total;
    }

    @Override
    public synchronized Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

