/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.mechanism;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IMapping;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;
import org.openscience.cdk.tools.manipulator.AtomContainerSetManipulator;
import org.openscience.smsd.tools.BondEnergies;
import org.openscience.smsd.tools.ExtAtomContainerManipulator;
import uk.ac.ebi.reactionblast.fingerprints.interfaces.IFeature;
import uk.ac.ebi.reactionblast.fingerprints.interfaces.IPatternFingerprinter;
import uk.ac.ebi.reactionblast.interfaces.IStandardizer;
import uk.ac.ebi.reactionblast.mapping.CallableAtomMappingTool;
import uk.ac.ebi.reactionblast.mapping.Reactor;
import uk.ac.ebi.reactionblast.mapping.interfaces.IMappingAlgorithm;
import uk.ac.ebi.reactionblast.mechanism.BondChangeCalculator;
import uk.ac.ebi.reactionblast.mechanism.MappingSolution;
import uk.ac.ebi.reactionblast.tools.StandardizeReaction;

public class ReactionMechanismTool
implements Serializable {
    static final String NEW_LINE = System.getProperty("line.separator");
    private static final boolean DEBUG = false;
    private static final ILoggingTool LOGGER = LoggingToolFactory.createLoggingTool(ReactionMechanismTool.class);
    private static final long serialVersionUID = 998977861L;
    private MappingSolution selectedMapping = null;
    private Collection<MappingSolution> allSolutions = Collections.synchronizedList(new ArrayList());

    public ReactionMechanismTool(IReaction reaction, boolean forcedMapping, boolean generate2D, boolean generate3D, boolean checkComplex) throws Exception {
        this(reaction, forcedMapping, generate2D, generate3D, checkComplex, new StandardizeReaction());
    }

    public ReactionMechanismTool(IReaction reaction, boolean forcedMapping, boolean generate2D, boolean generate3D, boolean checkComplex, IStandardizer standardizer) throws CDKException, AssertionError, Exception {
        for (IAtomContainer a : reaction.getReactants().atomContainers()) {
            ExtAtomContainerManipulator.setNullHCountToZero(a);
        }
        for (IAtomContainer a : reaction.getProducts().atomContainers()) {
            ExtAtomContainerManipulator.setNullHCountToZero(a);
        }
        if (!this.isBalanced(reaction)) {
            LOGGER.info("Atoms not balanced in the input reaction: {0}; unbalanced reaction may result in erroneous bond change assumptions!", reaction.getID());
            if (!forcedMapping) {
                return;
            }
        }
        if (!forcedMapping && reaction.getFlag(128) && AtomContainerSetManipulator.getAtomCount(reaction.getReactants()) == reaction.getMappingCount()) {
            try {
                LOGGER.info("Using user defined mappings!");
                for (IAtomContainer ac : reaction.getReactants().atomContainers()) {
                    for (IAtom a : ac.atoms()) {
                        a.setID("" + a.getProperty("cdk:AtomAtomMapping"));
                    }
                }
                for (IAtomContainer ac : reaction.getProducts().atomContainers()) {
                    for (IAtom a : ac.atoms()) {
                        a.setID("" + a.getProperty("cdk:AtomAtomMapping"));
                    }
                }
                for (IMapping map : reaction.mappings()) {
                    if (map.getChemObject(0) == null || map.getChemObject(1) == null) continue;
                    map.getChemObject(0).setFlag(128, true);
                    map.getChemObject(1).setFlag(128, true);
                }
                boolean selected = this.isMappingSolutionAcceptable(null, IMappingAlgorithm.USER_DEFINED, reaction, generate2D, generate3D);
                LOGGER.info("is solution: " + IMappingAlgorithm.USER_DEFINED + " selected: " + selected);
            }
            catch (Exception e) {
                throw new CDKException(NEW_LINE + "ERROR: Unable to calculate bond changes: " + e.getMessage());
            }
        }
        try {
            boolean onlyCoreMappingByMCS = true;
            CallableAtomMappingTool amt = new CallableAtomMappingTool(reaction, standardizer, onlyCoreMappingByMCS, checkComplex);
            Map<IMappingAlgorithm, Reactor> solutions = amt.getSolutions();
            for (IMappingAlgorithm algorithm : solutions.keySet()) {
                int atomCountP;
                Reactor reactor = solutions.get((Object)algorithm);
                if (reactor == null) {
                    System.out.println("Reactor is NULL");
                    return;
                }
                int atomCountR = this.getNonHydrogenMappingAtomCount(reactor.getReactionWithAtomAtomMapping().getReactants());
                if (atomCountR != (atomCountP = this.getNonHydrogenMappingAtomCount(reactor.getReactionWithAtomAtomMapping().getProducts()))) {
                    LOGGER.warn("Unmapped atoms present in this reaction(" + algorithm + ") algorithm.");
                }
                boolean selected = this.isMappingSolutionAcceptable(solutions.get((Object)algorithm), algorithm, reactor.getReactionWithAtomAtomMapping(), generate2D, generate3D);
            }
            System.gc();
        }
        catch (Exception e) {
            throw new Exception(NEW_LINE + "ERROR: Unable to calculate bond changes: " + e);
        }
    }

    private boolean isBalanced(IReaction r) {
        TreeMap<String, Integer> atomUniqueCounter1 = new TreeMap<String, Integer>();
        TreeMap<String, Integer> atomUniqueCounter2 = new TreeMap<String, Integer>();
        int leftHandAtomCount = 0;
        for (IAtomContainer q : r.getReactants().atomContainers()) {
            for (IAtom a : q.atoms()) {
                if (a.getSymbol().equals("H")) continue;
                if (!atomUniqueCounter1.containsKey(a.getSymbol())) {
                    atomUniqueCounter1.put(a.getSymbol(), 1);
                } else {
                    int counter = (Integer)atomUniqueCounter1.get(a.getSymbol()) + 1;
                    atomUniqueCounter1.put(a.getSymbol(), counter);
                }
                ++leftHandAtomCount;
            }
        }
        int rightHandAtomCount = 0;
        for (IAtomContainer t : r.getProducts().atomContainers()) {
            for (IAtom b : t.atoms()) {
                if (b.getSymbol().equals("H")) continue;
                if (!atomUniqueCounter2.containsKey(b.getSymbol())) {
                    atomUniqueCounter2.put(b.getSymbol(), 1);
                } else {
                    int counter = (Integer)atomUniqueCounter2.get(b.getSymbol()) + 1;
                    atomUniqueCounter2.put(b.getSymbol(), counter);
                }
                ++rightHandAtomCount;
            }
        }
        if (leftHandAtomCount != rightHandAtomCount) {
            LOGGER.warn("Number of atom(s) on the Left side " + leftHandAtomCount + " =/= Number of atom(s) on the Right side " + rightHandAtomCount);
            LOGGER.warn(atomUniqueCounter1 + " =/= " + atomUniqueCounter2);
            return false;
        }
        if (!atomUniqueCounter1.keySet().equals(atomUniqueCounter2.keySet())) {
            LOGGER.warn("Number of atom(s) on the Left side " + leftHandAtomCount + " =/= Number of atom(s) on the Right side " + rightHandAtomCount);
            LOGGER.warn(atomUniqueCounter1 + " =/= " + atomUniqueCounter2);
            return false;
        }
        return atomUniqueCounter1.keySet().equals(atomUniqueCounter2.keySet());
    }

    private synchronized boolean isMappingSolutionAcceptable(Reactor reactor, IMappingAlgorithm ma, IReaction reaction, boolean generate2D, boolean generate3D) throws Exception {
        if (reactor.getMappingCount() > 500 & reactor.getMappingCount() < 1000) {
            System.err.println("wolla...are after something big?...so many atoms to compute bond changes!");
            System.err.println("...Let me try..hold on your horses!");
        }
        if (reactor.getMappingCount() > 1000) {
            System.err.println("...wolla...are after something big?...!");
            System.err.println("...This might drive me bit crazy ... have to compute so many atoms for bond changes...!");
            System.err.println("...Let me try..hold on your horses!");
        }
        boolean chosen = false;
        try {
            if (reactor == null && ma.equals((Object)IMappingAlgorithm.USER_DEFINED)) {
                BondChangeCalculator bcc = new BondChangeCalculator(reaction);
                bcc.computeBondChanges(generate2D, generate3D);
                int fragmentDeltaChanges = bcc.getTotalFragmentCount();
                int bondChange = (int)this.getTotalBondChange(bcc.getFormedCleavedWFingerprint());
                bondChange = (int)((double)bondChange + this.getTotalBondChange(bcc.getOrderChangesWFingerprint()));
                int stereoChanges = (int)this.getTotalBondChange(bcc.getStereoChangesWFingerprint());
                boolean skipHydrogenRealtedBondChanges = true;
                int bondBreakingEnergy = this.getTotalBondChangeEnergy(bcc.getFormedCleavedWFingerprint(), skipHydrogenRealtedBondChanges);
                int totalSmallestFragmentCount = bcc.getTotalSmallestFragmentSize();
                int totalCarbonBondChanges = this.getTotalCarbonBondChange(bcc.getFormedCleavedWFingerprint());
                int localScore = bondChange + fragmentDeltaChanges;
                MappingSolution mappingSolution = new MappingSolution(bcc, ma, bcc.getReaction(), reactor, bondBreakingEnergy, totalCarbonBondChanges, bondChange, fragmentDeltaChanges, stereoChanges, totalSmallestFragmentCount, localScore, bcc.getEnergyDelta());
                chosen = true;
                mappingSolution.setChosen(chosen);
                this.selectedMapping = mappingSolution;
                this.allSolutions.add(mappingSolution);
            } else {
                int bondCleavedFormed;
                if (reactor == null) {
                    throw new CDKException("Reactor is NULL");
                }
                BondChangeCalculator bcc = new BondChangeCalculator(reactor.getReactionWithAtomAtomMapping());
                bcc.computeBondChanges(generate2D, generate3D);
                int fragmentDeltaChanges = bcc.getTotalFragmentCount() + reactor.getDelta();
                int bondChange = bondCleavedFormed = (int)this.getTotalBondChange(bcc.getFormedCleavedWFingerprint());
                bondChange = (int)((double)bondChange + this.getTotalBondChange(bcc.getOrderChangesWFingerprint()));
                int stereoChanges = (int)this.getTotalBondChange(bcc.getStereoChangesWFingerprint());
                boolean skipHydrogenRealtedBondChanges = true;
                int bondBreakingEnergy = this.getTotalBondChangeEnergy(bcc.getFormedCleavedWFingerprint(), skipHydrogenRealtedBondChanges);
                int totalSmallestFragmentCount = bcc.getTotalSmallestFragmentSize();
                int totalCarbonBondChanges = this.getTotalCarbonBondChange(bcc.getFormedCleavedWFingerprint());
                int localScore = bondChange + fragmentDeltaChanges;
                LOGGER.info("Score: " + fragmentDeltaChanges + " : " + bondChange);
                LOGGER.info(", Energy Barrier: " + bondBreakingEnergy);
                LOGGER.info(", Energy Delta: " + bcc.getEnergyDelta());
                bcc.getReaction().setFlag(128, true);
                MappingSolution mappingSolution = new MappingSolution(bcc, ma, bcc.getReaction(), reactor, bondBreakingEnergy, totalCarbonBondChanges, bondChange, fragmentDeltaChanges, stereoChanges, totalSmallestFragmentCount, localScore, bcc.getEnergyDelta());
                if (ma == null) {
                    throw new CDKException("Model is pointing to NULL");
                }
                LOGGER.info("MA: " + ma.description());
                if (this.isChangeFeasible(mappingSolution)) {
                    chosen = true;
                    mappingSolution.setChosen(chosen);
                    this.selectedMapping = mappingSolution;
                }
                this.allSolutions.add(mappingSolution);
            }
        }
        catch (Exception e) {
            throw new Exception(NEW_LINE + "ERROR: Unable to calculate bond changes: " + e.getMessage());
        }
        return chosen;
    }

    private synchronized boolean isChangeFeasible(MappingSolution ms) {
        if (this.selectedMapping != null && ms.getTotalBondChanges() == 0 && ms.getTotalStereoChanges() == 0) {
            return false;
        }
        if (this.selectedMapping == null) {
            LOGGER.info("Condition Default " + ms.getAlgorithmID().description());
            return true;
        }
        if (ms.getBondEnergySum() == 0.0 && ms.getTotalFragmentChanges() == 0 && ms.getTotalBondChanges() == 0 && this.selectedMapping.getTotalStereoChanges() >= ms.getTotalStereoChanges()) {
            LOGGER.info("Condition 1 " + ms.getAlgorithmID().description());
            return true;
        }
        if (this.selectedMapping.getTotalBondChanges() > ms.getTotalBondChanges() && this.selectedMapping.getTotalCarbonBondChanges() > 0 && this.selectedMapping.getTotalCarbonBondChanges() > ms.getTotalCarbonBondChanges() && (this.selectedMapping.getTotalFragmentChanges() > ms.getTotalFragmentChanges() || this.selectedMapping.getBondEnergySum() > ms.getBondEnergySum())) {
            LOGGER.info("Condition 2 " + ms.getAlgorithmID().description());
            return true;
        }
        if (this.selectedMapping.getTotalBondChanges() > ms.getTotalBondChanges() && this.selectedMapping.getTotalFragmentChanges() > 0 && ms.getTotalFragmentChanges() > 0) {
            LOGGER.info("Condition 3 " + ms.getAlgorithmID().description());
            return true;
        }
        if (this.selectedMapping.getTotalFragmentChanges() >= ms.getTotalFragmentChanges() && this.selectedMapping.getSmallestFragmentCount() >= ms.getSmallestFragmentCount() && this.selectedMapping.getBondEnergySum() > ms.getBondEnergySum() && this.selectedMapping.getTotalCarbonBondChanges() >= ms.getTotalCarbonBondChanges()) {
            LOGGER.info("Condition 4 " + ms.getAlgorithmID().description());
            return true;
        }
        if (this.selectedMapping.getTotalFragmentChanges() > ms.getTotalFragmentChanges() && this.selectedMapping.getSmallestFragmentCount() > ms.getSmallestFragmentCount()) {
            LOGGER.info("Condition 5 " + ms.getAlgorithmID().description());
            return true;
        }
        if (this.selectedMapping.getTotalFragmentChanges() == ms.getTotalFragmentChanges() && this.selectedMapping.getSmallestFragmentCount() == ms.getSmallestFragmentCount() && this.selectedMapping.getBondEnergySum() > ms.getBondEnergySum() && this.selectedMapping.getTotalCarbonBondChanges() >= ms.getTotalCarbonBondChanges()) {
            LOGGER.info("Condition 6 " + ms.getAlgorithmID().description());
            return true;
        }
        if (this.selectedMapping.getTotalFragmentChanges() > ms.getTotalFragmentChanges() && this.selectedMapping.getBondEnergySum() > ms.getBondEnergySum()) {
            LOGGER.info("Condition 7 " + ms.getAlgorithmID().description());
            return true;
        }
        if (this.selectedMapping.getTotalBondChanges() == ms.getTotalBondChanges() && this.selectedMapping.getTotalFragmentChanges() > ms.getTotalFragmentChanges()) {
            LOGGER.info("Condition 8 " + ms.getAlgorithmID().description());
            return true;
        }
        if (this.selectedMapping.getTotalFragmentChanges() == ms.getTotalFragmentChanges() && this.selectedMapping.getBondEnergySum() == ms.getBondEnergySum() && this.selectedMapping.getTotalBondChanges() > ms.getTotalBondChanges()) {
            LOGGER.info("Condition 9 " + ms.getAlgorithmID().description());
            return true;
        }
        if (this.selectedMapping.getBondEnergySum() == ms.getBondEnergySum() && this.selectedMapping.getTotalBondChanges() == ms.getTotalBondChanges() && this.selectedMapping.getTotalStereoChanges() > ms.getTotalStereoChanges()) {
            LOGGER.info("Condition 10 " + ms.getAlgorithmID().description());
            return true;
        }
        if (this.selectedMapping.getBondEnergySum() > ms.getBondEnergySum() && this.selectedMapping.getTotalCarbonBondChanges() > ms.getTotalCarbonBondChanges()) {
            LOGGER.info("Condition 11 " + ms.getAlgorithmID().description());
            return true;
        }
        if (this.selectedMapping.getTotalBondChanges() < ms.getTotalBondChanges() && this.selectedMapping.getBondEnergySum() < ms.getBondEnergySum() && this.selectedMapping.getTotalCarbonBondChanges() > 0 && this.selectedMapping.getTotalCarbonBondChanges() > ms.getTotalCarbonBondChanges() && this.selectedMapping.getSmallestFragmentCount() > ms.getSmallestFragmentCount()) {
            LOGGER.info("Condition 12 " + ms.getAlgorithmID().description());
            return true;
        }
        if (this.selectedMapping.getTotalBondChanges() > ms.getTotalBondChanges() && this.selectedMapping.getTotalCarbonBondChanges() > ms.getTotalCarbonBondChanges() && this.selectedMapping.getSmallestFragmentCount() > ms.getSmallestFragmentCount()) {
            LOGGER.info("Condition 13 " + ms.getAlgorithmID().description());
            return true;
        }
        if (this.selectedMapping.getTotalBondChanges() == ms.getTotalBondChanges() && this.selectedMapping.getTotalCarbonBondChanges() == ms.getTotalCarbonBondChanges() && this.selectedMapping.getSmallestFragmentCount() < ms.getSmallestFragmentCount()) {
            LOGGER.info("Condition 14 " + ms.getAlgorithmID().description());
            return true;
        }
        if (this.selectedMapping.getTotalBondChanges() == ms.getTotalBondChanges() && this.selectedMapping.getTotalCarbonBondChanges() == ms.getTotalCarbonBondChanges() && this.selectedMapping.getBondEnergySum() > ms.getBondEnergySum()) {
            LOGGER.info("Condition 15 " + ms.getAlgorithmID().description());
            return true;
        }
        return false;
    }

    private synchronized double getTotalBondChange(IPatternFingerprinter fingerprint) throws CDKException {
        double total = 0.0;
        total = fingerprint.getFeatures().stream().map(key -> key.getWeight()).filter(val -> val > 0.0).map(val -> val).reduce(total, (accumulator, _item) -> accumulator + _item);
        return total;
    }

    private synchronized int getTotalCarbonBondChange(IPatternFingerprinter fingerprint) throws CDKException {
        double total = 0.0;
        total = fingerprint.getFeatures().stream().filter(key -> key.getPattern().contains("C-C") || key.getPattern().contains("C=C") || key.getPattern().contains("C#C") || key.getPattern().contains("C%C") || key.getPattern().contains("C@C")).map(key -> key.getWeight()).filter(val -> val > 0.0).map(val -> val).reduce(total, (accumulator, _item) -> accumulator + _item);
        return (int)total;
    }

    private synchronized int getTotalBondChangeEnergy(IPatternFingerprinter fingerprint, boolean skipHydrogen) {
        int total = 0;
        try {
            BondEnergies be = BondEnergies.getInstance();
            for (IFeature feature : fingerprint.getFeatures()) {
                int energy;
                String[] temp;
                double val = feature.getWeight();
                String key = feature.getPattern();
                if (!(val > 0.0)) continue;
                if (key.contains("-") || key.contains("%") || key.contains("@")) {
                    temp = null;
                    if (key.contains("-")) {
                        temp = key.split("-");
                    } else if (key.contains("%")) {
                        temp = key.split("%");
                    } else if (key.contains("@")) {
                        temp = key.split("@");
                    }
                    if (skipHydrogen && (temp[0].equals("H") || temp[1].equals("H")) || (energy = be.getEnergies(temp[0], temp[1], IBond.Order.SINGLE)) <= 0) continue;
                    if (key.contains("%")) {
                        total = (int)((double)total + val * ((double)energy - 5.0));
                        continue;
                    }
                    total = (int)((double)total + val * (double)energy);
                    continue;
                }
                if (key.contains("=")) {
                    temp = key.split("=");
                    if (skipHydrogen && (temp[0].equals("H") || temp[1].equals("H")) || (energy = be.getEnergies(temp[0], temp[1], IBond.Order.DOUBLE)) <= 0) continue;
                    total = (int)((double)total + val * (double)energy);
                    continue;
                }
                if (key.contains("#")) {
                    temp = key.split("#");
                    energy = be.getEnergies(temp[0], temp[1], IBond.Order.TRIPLE);
                    if (skipHydrogen && (temp[0].equals("H") || temp[1].equals("H")) || energy <= 0) continue;
                    total = (int)((double)total + val * (double)energy);
                    continue;
                }
                if (!key.contains("$")) continue;
                temp = key.split("$");
                if (skipHydrogen && (temp[0].equals("H") || temp[1].equals("H")) || (energy = be.getEnergies(temp[0], temp[1], IBond.Order.QUADRUPLE)) <= 0) continue;
                total = (int)((double)total + val * (double)energy);
            }
        }
        catch (CDKException ex) {
            LOGGER.error(Level.SEVERE, null, ex);
        }
        return Math.abs(total);
    }

    public String getMappingDescription() {
        return this.selectedMapping.toString();
    }

    public MappingSolution getSelectedSolution() {
        return this.selectedMapping;
    }

    public Collection<MappingSolution> getAllSolutions() {
        return Collections.unmodifiableCollection(this.allSolutions);
    }

    private int getNonHydrogenMappingAtomCount(IAtomContainerSet mol) {
        int count = Integer.MIN_VALUE;
        List<IAtomContainer> allAtomContainers = AtomContainerSetManipulator.getAllAtomContainers(mol);
        for (IAtomContainer ac : allAtomContainers) {
            IAtom[] atomArray;
            for (IAtom atom : atomArray = AtomContainerManipulator.getAtomArray(ac)) {
                if (atom.getSymbol().equalsIgnoreCase("H") || atom.getID() == null || Integer.parseInt(atom.getID()) <= count) continue;
                count = Integer.parseInt(atom.getID());
            }
        }
        return count;
    }
}

