/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.mechanism;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IReaction;
import uk.ac.ebi.reactionblast.mechanism.StereoChange;
import uk.ac.ebi.reactionblast.stereo.IStereoAndConformation;

public class StereogenicCenterCalculator
implements Serializable {
    private static final long serialVersionUID = -1420740601548197863L;

    public synchronized List<StereoChange> compare(IReaction reaction, Map<IAtom, IStereoAndConformation> chirality2DCDK, Map<IAtom, IStereoAndConformation> chirality2DChemaxon, Map<IAtom, IStereoAndConformation> chirality3DChemaxon) {
        ArrayList<StereoChange> stereoChangeList = new ArrayList<StereoChange>();
        ArrayList<IAtom> queryAtoms = new ArrayList<IAtom>();
        for (IAtomContainer ac : reaction.getReactants().atomContainers()) {
            for (IAtom a : ac.atoms()) {
                queryAtoms.add(a);
            }
        }
        ArrayList<IAtom> targetAtoms = new ArrayList<IAtom>();
        for (IAtomContainer ac : reaction.getProducts().atomContainers()) {
            for (IAtom a : ac.atoms()) {
                targetAtoms.add(a);
            }
        }
        queryAtoms.stream().forEach(atomQ -> targetAtoms.stream().filter(atomT -> atomQ.getID().equals(atomT.getID()) && !atomQ.getSymbol().equalsIgnoreCase("H")).forEach(atomT -> {
            StereoChange sc;
            IStereoAndConformation rAtom2DCDKStereo = (IStereoAndConformation)chirality2DCDK.get(atomQ);
            IStereoAndConformation pAtom2DCDKStereo = (IStereoAndConformation)chirality2DCDK.get(atomT);
            IStereoAndConformation rAtom2DStereo = (IStereoAndConformation)chirality2DChemaxon.get(atomQ);
            IStereoAndConformation pAtom2DStereo = (IStereoAndConformation)chirality2DChemaxon.get(atomT);
            IStereoAndConformation rAtom3DStereo = (IStereoAndConformation)chirality3DChemaxon.get(atomQ);
            IStereoAndConformation pAtom3DStereo = (IStereoAndConformation)chirality3DChemaxon.get(atomT);
            if (this.isStereogenicChange(rAtom2DCDKStereo, pAtom2DCDKStereo)) {
                sc = new StereoChange(rAtom2DCDKStereo, pAtom2DCDKStereo, (IAtom)atomQ, (IAtom)atomT);
                stereoChangeList.add(sc);
            }
            if (this.isStereogenicChange(rAtom3DStereo, pAtom3DStereo)) {
                sc = new StereoChange(rAtom3DStereo, pAtom3DStereo, (IAtom)atomQ, (IAtom)atomT);
                stereoChangeList.add(sc);
            }
        }));
        return stereoChangeList;
    }

    public synchronized List<StereoChange> compare(IReaction reaction, Map<IAtom, IStereoAndConformation> chirality2DCDK, Map<IAtom, IStereoAndConformation> chirality2DChemaxon) {
        ArrayList<StereoChange> stereoChangeList = new ArrayList<StereoChange>();
        ArrayList<IAtom> queryAtoms = new ArrayList<IAtom>();
        for (IAtomContainer ac : reaction.getReactants().atomContainers()) {
            for (IAtom a : ac.atoms()) {
                queryAtoms.add(a);
            }
        }
        ArrayList<IAtom> targetAtoms = new ArrayList<IAtom>();
        for (IAtomContainer ac : reaction.getProducts().atomContainers()) {
            for (IAtom a : ac.atoms()) {
                targetAtoms.add(a);
            }
        }
        queryAtoms.stream().forEach(atomQ -> targetAtoms.stream().filter(atomT -> atomQ.getID().equals(atomT.getID()) && !atomQ.getSymbol().equalsIgnoreCase("H")).forEach(atomT -> {
            StereoChange sc;
            IStereoAndConformation pAtom2DStereo;
            IStereoAndConformation rAtom2DCDKStereo = (IStereoAndConformation)chirality2DCDK.get(atomQ);
            IStereoAndConformation pAtom2DCDKStereo = (IStereoAndConformation)chirality2DCDK.get(atomT);
            IStereoAndConformation rAtom2DStereo = (IStereoAndConformation)chirality2DChemaxon.get(atomQ);
            if (this.isStereogenicChange(rAtom2DStereo, pAtom2DStereo = (IStereoAndConformation)chirality2DChemaxon.get(atomT))) {
                sc = new StereoChange(rAtom2DStereo, pAtom2DStereo, (IAtom)atomQ, (IAtom)atomT);
                stereoChangeList.add(sc);
            }
            if (this.isStereogenicChange(rAtom2DCDKStereo, pAtom2DCDKStereo)) {
                sc = new StereoChange(rAtom2DCDKStereo, pAtom2DCDKStereo, (IAtom)atomQ, (IAtom)atomT);
                stereoChangeList.add(sc);
            }
        }));
        return stereoChangeList;
    }

    public synchronized List<StereoChange> compare(IReaction reaction, Map<IAtom, IStereoAndConformation> chirality2DCDK) {
        ArrayList<StereoChange> stereoChangeList = new ArrayList<StereoChange>();
        ArrayList<IAtom> queryAtoms = new ArrayList<IAtom>();
        for (IAtomContainer ac : reaction.getReactants().atomContainers()) {
            for (IAtom a : ac.atoms()) {
                queryAtoms.add(a);
            }
        }
        ArrayList<IAtom> targetAtoms = new ArrayList<IAtom>();
        for (IAtomContainer ac : reaction.getProducts().atomContainers()) {
            for (IAtom a : ac.atoms()) {
                targetAtoms.add(a);
            }
        }
        queryAtoms.forEach(atomQ -> targetAtoms.stream().filter(atomT -> atomQ.getID().equals(atomT.getID()) && !atomQ.getSymbol().equalsIgnoreCase("H")).forEachOrdered(atomT -> {
            IStereoAndConformation pAtom2DCDKStereo;
            IStereoAndConformation rAtom2DCDKStereo = (IStereoAndConformation)chirality2DCDK.get(atomQ);
            if (this.isStereogenicChange(rAtom2DCDKStereo, pAtom2DCDKStereo = (IStereoAndConformation)chirality2DCDK.get(atomT))) {
                StereoChange sc = new StereoChange(rAtom2DCDKStereo, pAtom2DCDKStereo, (IAtom)atomQ, (IAtom)atomT);
                stereoChangeList.add(sc);
            }
        }));
        return stereoChangeList;
    }

    public synchronized boolean isStereogenicChange(IStereoAndConformation a, IStereoAndConformation b) {
        if (a.equals(IStereoAndConformation.S) && b.equals(IStereoAndConformation.NONE)) {
            return true;
        }
        if (a.equals(IStereoAndConformation.R) && b.equals(IStereoAndConformation.NONE)) {
            return true;
        }
        if (b.equals(IStereoAndConformation.S) && a.equals(IStereoAndConformation.NONE)) {
            return true;
        }
        if (b.equals(IStereoAndConformation.R) && a.equals(IStereoAndConformation.NONE)) {
            return true;
        }
        if (a.equals(IStereoAndConformation.R) && b.equals(IStereoAndConformation.S)) {
            return true;
        }
        if (a.equals(IStereoAndConformation.S) && b.equals(IStereoAndConformation.R)) {
            return true;
        }
        if (a.equals(IStereoAndConformation.S) && b.equals(IStereoAndConformation.EITHER)) {
            return true;
        }
        if (a.equals(IStereoAndConformation.R) && b.equals(IStereoAndConformation.EITHER)) {
            return true;
        }
        if (b.equals(IStereoAndConformation.S) && a.equals(IStereoAndConformation.EITHER)) {
            return true;
        }
        if (b.equals(IStereoAndConformation.R) && a.equals(IStereoAndConformation.EITHER)) {
            return true;
        }
        if (a.equals(IStereoAndConformation.EITHER) && b.equals(IStereoAndConformation.EITHER)) {
            return true;
        }
        if (a.equals(IStereoAndConformation.NONE) && b.equals(IStereoAndConformation.EITHER)) {
            return true;
        }
        if (a.equals(IStereoAndConformation.EITHER) && b.equals(IStereoAndConformation.NONE)) {
            return true;
        }
        if (a.equals(IStereoAndConformation.Z) && b.equals(IStereoAndConformation.E)) {
            return true;
        }
        return a.equals(IStereoAndConformation.E) && b.equals(IStereoAndConformation.Z);
    }
}

