/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.mechanism.helper;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IMapping;
import org.openscience.cdk.interfaces.IReaction;
import uk.ac.ebi.reactionblast.mapping.Reactor;

public class AtomAtomMappingContainer
implements Serializable {
    private static final String NEW_LINE = System.getProperty("line.separator");
    private static final long serialVersionUID = 17879096958755L;
    private List<IAtom> reactantAtomArray = new ArrayList<IAtom>();
    private List<IAtom> productAtomArray = new ArrayList<IAtom>();

    public AtomAtomMappingContainer(Reactor reactor, boolean withoutH) throws Exception {
        this(reactor.getReactionWithAtomAtomMapping(), withoutH);
    }

    public AtomAtomMappingContainer(IAtomContainerSet reactants, IAtomContainerSet products, boolean withoutH) {
        int i;
        int i2;
        int atomNo = 0;
        int mappedAtomsR = 0;
        int mappedAtomsP = 0;
        IAtom[] atVect = null;
        if (withoutH) {
            for (i2 = 0; i2 < reactants.getAtomContainerCount(); ++i2) {
                IAtomContainer M = reactants.getAtomContainer(i2);
                for (IAtom a : M.atoms()) {
                    if (a.getSymbol().equalsIgnoreCase("H")) continue;
                    ++atomNo;
                }
            }
        } else {
            for (i2 = 0; i2 < reactants.getAtomContainerCount(); ++i2) {
                atomNo += reactants.getAtomContainer(i2).getAtomCount();
            }
        }
        atVect = new IAtom[atomNo];
        for (i2 = 0; i2 < atVect.length; ++i2) {
            atVect[i2] = null;
        }
        for (i2 = 0; i2 < reactants.getAtomContainerCount(); ++i2) {
            for (int j = 0; j < reactants.getAtomContainer(i2).getAtomCount(); ++j) {
                int atomID;
                IAtom at = reactants.getAtomContainer(i2).getAtom(j);
                if (withoutH && at.getSymbol().equalsIgnoreCase("H") || (atomID = Integer.valueOf(at.getID()).intValue()) <= 0) continue;
                atVect[atomID - 1] = at;
                ++mappedAtomsR;
            }
        }
        for (i2 = 0; i2 < mappedAtomsR; ++i2) {
            this.reactantAtomArray.add(atVect[i2]);
        }
        boolean findNull = false;
        boolean error = false;
        for (IAtom atVect1 : atVect) {
            if (findNull && atVect1 != null) {
                error = true;
            }
            if (atVect1 != null) continue;
            findNull = true;
        }
        if (error) {
            System.out.print("ERROR in AtomAtomMapping-found hole in the mapping (reactants atomIDs)");
            for (int i3 = 0; i3 < reactants.getAtomContainerCount(); ++i3) {
                System.out.println("Mol:" + reactants.getAtomContainer(i3).getID());
                for (int j = 0; j < reactants.getAtomContainer(i3).getAtomCount(); ++j) {
                    IAtom at = reactants.getAtomContainer(i3).getAtom(j);
                    System.out.println(at.getSymbol() + at.getID());
                }
            }
        }
        atomNo = 0;
        if (withoutH) {
            for (i = 0; i < products.getAtomContainerCount(); ++i) {
                IAtomContainer M = products.getAtomContainer(i);
                for (IAtom a : M.atoms()) {
                    if (a.getSymbol().equalsIgnoreCase("H")) continue;
                    ++atomNo;
                }
            }
        } else {
            for (i = 0; i < products.getAtomContainerCount(); ++i) {
                atomNo += products.getAtomContainer(i).getAtomCount();
            }
        }
        atVect = new IAtom[atomNo];
        for (i = 0; i < atVect.length; ++i) {
            atVect[i] = null;
        }
        for (i = 0; i < products.getAtomContainerCount(); ++i) {
            for (int j = 0; j < products.getAtomContainer(i).getAtomCount(); ++j) {
                int atomID;
                IAtom at = products.getAtomContainer(i).getAtom(j);
                if (withoutH && at.getSymbol().equalsIgnoreCase("H") || (atomID = Integer.valueOf(at.getID()).intValue()) <= 0) continue;
                atVect[atomID - 1] = at;
                ++mappedAtomsP;
            }
        }
        for (i = 0; i < mappedAtomsP; ++i) {
            this.productAtomArray.add(atVect[i]);
        }
        findNull = false;
        error = false;
        IAtom[] i4 = atVect;
        int j = i4.length;
        for (int at = 0; at < j; ++at) {
            IAtom atVect1 = i4[at];
            if (findNull && atVect1 != null) {
                error = true;
            }
            if (atVect1 != null) continue;
            findNull = true;
        }
        if (mappedAtomsP != mappedAtomsR) {
            error = true;
        }
        if (error) {
            System.out.print("ERROR in AtomAtomMapping-found hole in the mapping (products atomIDs)");
            System.out.print("mapped reactants atoms: " + mappedAtomsR + ", mapped products atoms: " + mappedAtomsP);
            for (int i5 = 0; i5 < products.getAtomContainerCount(); ++i5) {
                System.out.println("Mol:" + products.getAtomContainer(i5).getID());
                for (j = 0; j < products.getAtomContainer(i5).getAtomCount(); ++j) {
                    IAtom at = products.getAtomContainer(i5).getAtom(j);
                    System.out.println(at.getSymbol() + at.getID());
                }
            }
        }
    }

    public AtomAtomMappingContainer(IReaction reaction, boolean withoutH) {
        for (IMapping m : reaction.mappings()) {
            IAtom rAtom = (IAtom)m.getChemObject(0);
            IAtom pAtom = (IAtom)m.getChemObject(1);
            if (withoutH && rAtom != null && pAtom != null && (rAtom.getSymbol().equalsIgnoreCase("H") || pAtom.getSymbol().equalsIgnoreCase("H"))) continue;
            this.reactantAtomArray.add(rAtom);
            this.productAtomArray.add(pAtom);
        }
    }

    public synchronized String toString() {
        int i;
        StringBuilder result = new StringBuilder();
        result.append(this.reactantAtomArray.size()).append(NEW_LINE);
        for (i = 0; i < this.reactantAtomArray.size(); ++i) {
            result.append(i).append("\t");
        }
        result.append(NEW_LINE);
        for (i = 0; i < this.reactantAtomArray.size(); ++i) {
            result.append(this.reactantAtomArray.get(i).getSymbol()).append(this.reactantAtomArray.get(i).getID()).append("\t");
        }
        result.append(NEW_LINE);
        for (i = 0; i < this.productAtomArray.size(); ++i) {
            result.append(this.productAtomArray.get(i).getSymbol()).append(this.productAtomArray.get(i).getID()).append("\t");
        }
        result.append(NEW_LINE);
        return result.toString();
    }

    public synchronized IAtom getMappedProductAtom(IAtom reactantAtom) {
        IAtom a = null;
        int reactantIdx = -1;
        for (int i = 0; i < this.reactantAtomArray.size(); ++i) {
            if (!this.reactantAtomArray.get(i).getID().equals(reactantAtom.getID())) continue;
            reactantIdx = i;
        }
        if (reactantIdx != -1) {
            a = this.productAtomArray.get(reactantIdx);
        }
        return a;
    }

    public synchronized IAtom getReactantAtom(int idx) {
        IAtom ret = null;
        if (idx < this.reactantAtomArray.size() && idx > -1) {
            ret = this.reactantAtomArray.get(idx);
        }
        return ret;
    }

    public synchronized IAtom getProductAtom(int idx) {
        IAtom ret = null;
        if (idx < this.productAtomArray.size() && idx > -1) {
            ret = this.productAtomArray.get(idx);
        }
        return ret;
    }

    public synchronized int getSize() {
        return this.reactantAtomArray.size();
    }

    public synchronized int getSizeNoHydrogens() {
        int count = 0;
        count = this.reactantAtomArray.stream().filter(a -> !a.getSymbol().equals("H")).map(_item -> 1).reduce(count, Integer::sum);
        return count;
    }

    public synchronized boolean isReactantAtomPresent(IAtom atom) {
        return this.reactantAtomArray.contains(atom);
    }

    public synchronized boolean isProductAtomPresent(IAtom atom) {
        return this.productAtomArray.contains(atom);
    }
}

