/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.mechanism.helper;

import java.io.Serializable;
import org.openscience.cdk.interfaces.IAtom;
import uk.ac.ebi.reactionblast.stereo.IStereoAndConformation;

public class AtomStereoChangeInformation
implements Serializable {
    private static final long serialVersionUID = 1896986585959789L;
    private final IAtom reactantAtom;
    private final IAtom productAtom;
    private boolean stereoChange = false;
    private IStereoAndConformation atomStereoR;
    private IStereoAndConformation atomStereoP;

    public AtomStereoChangeInformation(IAtom rAtom, IAtom pAtom) {
        this.reactantAtom = rAtom;
        this.productAtom = pAtom;
        this.setStereoChange(true);
    }

    public AtomStereoChangeInformation(IAtom atomE, IAtom atomP, IStereoAndConformation aStereoR, IStereoAndConformation aStereoP) {
        this(atomE, atomP);
        this.atomStereoR = aStereoR;
        this.atomStereoP = aStereoP;
    }

    public synchronized IAtom getReactantAtom() {
        return this.reactantAtom;
    }

    public synchronized IAtom getProductAtom() {
        return this.productAtom;
    }

    public synchronized boolean isStereoChange() {
        return this.stereoChange;
    }

    private synchronized void setStereoChange(boolean stereoChange) {
        this.stereoChange = stereoChange;
    }

    public IStereoAndConformation getReactantAtomStereo() {
        return this.atomStereoR;
    }

    public IStereoAndConformation getProductAtomStereo() {
        return this.atomStereoP;
    }

    public void setAtomStereo(IStereoAndConformation atomStereoR, IStereoAndConformation atomStereoP) {
        this.atomStereoR = atomStereoR;
        this.atomStereoP = atomStereoP;
    }
}

