/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.mechanism.helper;

import java.io.Serializable;
import org.openscience.cdk.interfaces.IBond;

public class BondChange
implements Serializable {
    private static final String NEW_LINE = System.getProperty("line.separator");
    private static final long serialVersionUID = 9890766688070991L;
    private final IBond reactantBond;
    private final IBond productBond;
    private float bondChangeDelta = 0.0f;

    public static synchronized int convertBondOrder(IBond bond) {
        int value;
        switch (bond.getOrder()) {
            case QUADRUPLE: {
                value = 4;
                break;
            }
            case TRIPLE: {
                value = 3;
                break;
            }
            case DOUBLE: {
                value = 2;
                break;
            }
            case SINGLE: {
                value = 1;
                break;
            }
            default: {
                value = 1;
            }
        }
        return value;
    }

    public static synchronized int convertBondStereo(IBond bond) {
        int value;
        switch (bond.getStereo()) {
            case UP: {
                value = 1;
                break;
            }
            case UP_INVERTED: {
                value = 1;
                break;
            }
            case DOWN: {
                value = 6;
                break;
            }
            case DOWN_INVERTED: {
                value = 6;
                break;
            }
            case UP_OR_DOWN: {
                value = 4;
                break;
            }
            case UP_OR_DOWN_INVERTED: {
                value = 4;
                break;
            }
            case E_OR_Z: {
                value = 3;
                break;
            }
            default: {
                value = 0;
            }
        }
        return value;
    }

    public BondChange(IBond reactantBond, IBond productBond) {
        this.reactantBond = reactantBond;
        this.productBond = productBond;
        if (this.reactantBond != null && this.productBond != null) {
            float change = BondChange.convertBondOrder(this.productBond) - BondChange.convertBondOrder(this.reactantBond);
            if (change != 0.0f) {
                this.setBondChangeInformation(change);
            } else if (change == 0.0f) {
                this.setBondChangeInformation(0.0f);
            }
        } else if (this.reactantBond == null && this.productBond != null) {
            this.setBondChangeInformation(BondChange.convertBondOrder(this.productBond));
        } else if (this.reactantBond != null && this.productBond == null) {
            this.setBondChangeInformation(BondChange.convertBondOrder(this.reactantBond));
        }
    }

    public synchronized IBond getReactantBond() {
        return this.reactantBond;
    }

    public synchronized IBond getProductBond() {
        return this.productBond;
    }

    public synchronized float getBondChangeDelta() {
        return this.bondChangeDelta;
    }

    private synchronized void setBondChangeInformation(float bondChangeInformation) {
        this.bondChangeDelta = bondChangeInformation;
    }

    public synchronized String toString() {
        StringBuilder result = new StringBuilder();
        result.append("\t");
        result.append(NEW_LINE);
        if (this.reactantBond != null) {
            result.append("R: ").append(this.reactantBond.getAtom(0).getSymbol());
            result.append("(").append(this.reactantBond.getAtom(0).getID()).append(")");
            result.append("[").append(BondChange.convertBondOrder(this.reactantBond)).append("]");
            result.append(this.reactantBond.getAtom(1).getSymbol());
            result.append("(").append(this.reactantBond.getAtom(1).getID()).append(")");
        } else {
            result.append("NA");
        }
        if (this.productBond != null) {
            result.append(", P: ").append(this.productBond.getAtom(0).getSymbol());
            result.append("(").append(this.productBond.getAtom(0).getID()).append(")");
            result.append("[").append(BondChange.convertBondOrder(this.productBond)).append("]");
            result.append(this.productBond.getAtom(1).getSymbol());
            result.append("(").append(this.productBond.getAtom(1).getID()).append(")");
            result.append(NEW_LINE);
        } else {
            result.append(", NA");
            result.append(NEW_LINE);
        }
        return result.toString();
    }
}

