/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.mechanism.helper;

import java.io.Serializable;
import java.util.logging.Level;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.exception.InvalidSmilesException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.silent.SilentChemObjectBuilder;
import org.openscience.cdk.smiles.SmilesParser;
import org.openscience.cdk.smiles.smarts.parser.SMARTSParser;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.smsd.algorithm.matchers.AtomBondMatcher;
import org.openscience.smsd.algorithm.matchers.AtomMatcher;
import org.openscience.smsd.algorithm.matchers.BondMatcher;
import org.openscience.smsd.algorithm.vflib.substructure.VF2;
import org.openscience.smsd.helper.MoleculeInitializer;
import org.openscience.smsd.tools.ExtAtomContainerManipulator;

class CountSubstructures
extends MoleculeInitializer
implements Serializable {
    private static final ILoggingTool LOGGER = LoggingToolFactory.createLoggingTool(CountSubstructures.class);
    private static final long serialVersionUID = 12343289751445148L;
    private SmilesParser sp = new SmilesParser(SilentChemObjectBuilder.getInstance());
    private IAtomContainer mol;

    CountSubstructures(IAtomContainer atomContainer) throws CloneNotSupportedException {
        try {
            this.mol = null;
            this.mol = ExtAtomContainerManipulator.removeHydrogensExceptSingleAndPreserveAtomID(atomContainer);
            CountSubstructures.initializeMolecule(this.mol);
        }
        catch (CDKException ex) {
            LOGGER.error(Level.SEVERE, null, ex);
        }
    }

    public int substructureSize(String smiles) throws CDKException {
        AtomMatcher atomMatcher = AtomBondMatcher.atomMatcher(false, false);
        BondMatcher bondMatcher = AtomBondMatcher.bondMatcher(false, false);
        try {
            IAtomContainer parseSmiles = this.sp.parseSmiles(smiles);
            VF2 vf = new VF2(parseSmiles, this.mol, atomMatcher, bondMatcher);
            return vf.isSubgraph() ? vf.getFirstAtomMapping().getCount() : 0;
        }
        catch (InvalidSmilesException ex) {
            VF2 vf = new VF2(SMARTSParser.parse(smiles, this.mol.getBuilder()), this.mol);
            return vf.isSubgraph() ? vf.getFirstAtomMapping().getCount() : 0;
        }
    }
}

