/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.mechanism.helper;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.logging.Level;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.interfaces.IRingSet;
import org.openscience.cdk.silent.RingSet;
import org.openscience.cdk.smiles.SmilesGenerator;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;
import org.openscience.smsd.AtomAtomMapping;
import org.openscience.smsd.helper.MoleculeInitializer;
import org.openscience.smsd.tools.ExtAtomContainerManipulator;
import uk.ac.ebi.reactionblast.fingerprints.Feature;
import uk.ac.ebi.reactionblast.fingerprints.PatternFingerprinter;
import uk.ac.ebi.reactionblast.fingerprints.interfaces.IPatternFingerprinter;
import uk.ac.ebi.reactionblast.mechanism.helper.CountSubstructures;
import uk.ac.ebi.reactionblast.mechanism.helper.MatrixPrinter;
import uk.ac.ebi.reactionblast.mechanism.helper.ReactionCenterFragment;
import uk.ac.ebi.reactionblast.mechanism.interfaces.EnumSubstrateProduct;
import uk.ac.ebi.reactionblast.signature.RBlastMoleculeSignature;
import uk.ac.ebi.reactionblast.tools.CDKSMILES;

public abstract class Utility
extends MatrixPrinter
implements Serializable {
    private static final ILoggingTool LOGGER = LoggingToolFactory.createLoggingTool(Utility.class);

    public static String getMoietyAsSMILES(IAtomContainer reactant, IAtomContainer product, boolean remove_AAM) {
        AtomAtomMapping atomAtomMapping = new AtomAtomMapping(reactant, product);
        for (IAtom a : reactant.atoms()) {
            for (IAtom b : product.atoms()) {
                if (!(a.getID() == null ? b.getID() == null : a.getID().equals(b.getID()))) continue;
                atomAtomMapping.put(a, b);
            }
        }
        StringBuilder sb = new StringBuilder("");
        try {
            sb.append(Utility.getSMILES(atomAtomMapping.getCommonFragment(), remove_AAM));
        }
        catch (Exception ex) {
            LOGGER.error(Level.SEVERE, null, ex);
        }
        return sb.toString();
    }

    public static String getSMILES(IReaction reaction, boolean remove_AAM) {
        StringBuilder sb = new StringBuilder("");
        try {
            for (IAtomContainer mol : reaction.getReactants().atomContainers()) {
                sb.append(Utility.getSMILES(mol, remove_AAM));
            }
            sb.append(">>");
            for (IAtomContainer mol : reaction.getProducts().atomContainers()) {
                sb.append(Utility.getSMILES(mol, remove_AAM));
            }
        }
        catch (Exception ex) {
            LOGGER.error(Level.SEVERE, null, ex);
        }
        return sb.toString();
    }

    public static String getCircularSMILES(IAtomContainer mol, IAtom atom, int level, boolean remove_AAM) throws Exception {
        int refAtom = Utility.getAtomIndexByID(mol, atom);
        IAtomContainer fragment = Utility.getCircularFragment(mol, refAtom, level);
        String smiles = Utility.getSMILES(fragment, remove_AAM);
        return smiles;
    }

    public static String getSMILES(IAtomContainer mol, boolean remove_AAM) {
        String smiles = "";
        try {
            return new CDKSMILES(mol, true, remove_AAM).getCanonicalSMILES();
        }
        catch (CloneNotSupportedException ex) {
            LOGGER.error(Level.SEVERE, null, ex);
            return smiles;
        }
    }

    protected static List<IAtom> getAtoms(IAtomContainer mol) {
        ArrayList<IAtom> atoms = new ArrayList<IAtom>(mol.getAtomCount());
        for (IAtom atom : mol.atoms()) {
            atoms.add(atom);
        }
        return atoms;
    }

    protected static String getMoleculeID(IBond bond, IAtomContainerSet molset) {
        for (IAtomContainer mol : molset.atomContainers()) {
            if (!mol.contains(bond)) continue;
            return mol.getID();
        }
        return null;
    }

    protected static String getMoleculeID(IAtom atom, IAtomContainerSet molset) {
        for (IAtomContainer mol : molset.atomContainers()) {
            if (!mol.contains(atom)) continue;
            return mol.getID();
        }
        return null;
    }

    protected static IAtomContainer getAtomContainer(IBond bond, IAtomContainerSet molset) {
        for (IAtomContainer mol : molset.atomContainers()) {
            if (!mol.contains(bond)) continue;
            return mol;
        }
        return null;
    }

    protected static IAtomContainer getAtomContainer(IAtom atom, IAtomContainerSet molset) {
        for (IAtomContainer mol : molset.atomContainers()) {
            if (!mol.contains(atom)) continue;
            return mol;
        }
        return null;
    }

    protected static int getAtomIndexByID(IAtomContainer molWithoutH, IAtom refAtom) {
        for (IAtom atom : molWithoutH.atoms()) {
            if (!atom.getID().equalsIgnoreCase(refAtom.getID())) continue;
            return molWithoutH.indexOf(atom);
        }
        return -1;
    }

    protected static String getSignature(IAtomContainer mol, IAtom atom, int height) throws CloneNotSupportedException {
        IAtomContainer molWithoutH = ExtAtomContainerManipulator.removeHydrogensExceptSingleAndPreserveAtomID(mol);
        int atomIndex = Utility.getAtomIndexByID(molWithoutH, atom);
        RBlastMoleculeSignature moleculeSignature = new RBlastMoleculeSignature(molWithoutH);
        moleculeSignature.setUseCharge(true);
        moleculeSignature.setBondSensitive(true);
        moleculeSignature.setUseAromatics(true);
        if (atomIndex >= 0) {
            return moleculeSignature.getAtomSignature(atomIndex, height).toCanonicalString();
        }
        return "";
    }

    protected static void setFragmentMatches(SortedMap<String, Integer> atomRCChangesMap, List<IAtomContainer> fragments) throws CloneNotSupportedException {
        for (IAtomContainer fragment : fragments) {
            CountSubstructures countSubstructures = new CountSubstructures(fragment);
            atomRCChangesMap.keySet().stream().forEach(pattern -> {
                int hit = 0;
                try {
                    hit = countSubstructures.substructureSize((String)pattern);
                }
                catch (CDKException ex) {
                    LOGGER.error(Level.SEVERE, null, ex);
                }
                int val = hit == 0 ? 0 : (Integer)atomRCChangesMap.get(pattern) + 1;
                atomRCChangesMap.put((String)pattern, val);
            });
        }
    }

    protected static void setReactionCenterMatches(IPatternFingerprinter atomRCChangesMap, List<String> signatures) {
        signatures.stream().forEach(fragment -> {
            try {
                atomRCChangesMap.add(new Feature((String)fragment, 1.0));
            }
            catch (CDKException ex) {
                LOGGER.error(Level.SEVERE, null, ex);
            }
        });
    }

    protected static void setCircularSignatureFingerprints(String rid, IAtomContainer mol, IAtom atom, Map<Integer, IPatternFingerprinter> patternFP) throws CDKException, CloneNotSupportedException {
        for (int i = 1; i < 5; ++i) {
            if (!patternFP.containsKey(i)) {
                PatternFingerprinter fp = new PatternFingerprinter();
                fp.setFingerprintID(rid + ":Signature: " + i);
                patternFP.put(i, fp);
            }
            String signature = Utility.getSignature(mol, atom, i);
            patternFP.get(i).add(new Feature(signature, 1.0));
        }
        if (!patternFP.containsKey(-1)) {
            PatternFingerprinter fp = new PatternFingerprinter();
            fp.setFingerprintID(rid + ":Signature: -1");
            patternFP.put(-1, fp);
        }
        String signature = Utility.getSignature(mol, atom, -1);
        patternFP.get(-1).add(new Feature(signature, 1.0));
    }

    protected static String getCanonisedBondChangePattern(IBond reactBond, IBond prodBond) {
        String concatE = Utility.getCanonicalisedBondChangePattern(reactBond);
        String concatP = Utility.getCanonicalisedBondChangePattern(prodBond);
        ArrayList<String> pattern = new ArrayList<String>(2);
        pattern.add(0, concatE);
        pattern.add(1, concatP);
        Collections.sort(pattern, String.CASE_INSENSITIVE_ORDER);
        return ((String)pattern.get(0)).concat("*").concat((String)pattern.get(1));
    }

    protected static String getCanonicalisedBondChangePattern(IBond bond) {
        String symbol = Utility.getBondOrderSign(bond);
        ArrayList<String> atoms = new ArrayList<String>(2);
        atoms.add(0, bond.getAtom(0).getSymbol());
        atoms.add(1, bond.getAtom(1).getSymbol());
        Collections.sort(atoms, String.CASE_INSENSITIVE_ORDER);
        String concatenatedSymbols = ((String)atoms.get(0)).concat(symbol).concat((String)atoms.get(1));
        return concatenatedSymbols.trim();
    }

    public static String getBondOrderSign(IBond bond) {
        Object bondSymbol = "";
        if (bond.getFlag(32)) {
            bondSymbol = (String)bondSymbol + "@";
        } else if (bond.getFlag(2)) {
            bondSymbol = (String)bondSymbol + "%";
        } else if (bond.getOrder() == IBond.Order.SINGLE) {
            bondSymbol = (String)bondSymbol + "-";
        } else if (bond.getOrder() == IBond.Order.DOUBLE) {
            bondSymbol = (String)bondSymbol + "=";
        } else if (bond.getOrder() == IBond.Order.TRIPLE) {
            bondSymbol = (String)bondSymbol + "#";
        } else if (bond.getOrder() == IBond.Order.QUADRUPLE) {
            return "$";
        }
        return bondSymbol;
    }

    public static int getNeighbourBondOrderCountFromRing(IBond ringBond, IRingSet singleRings) {
        int minValue = 9999;
        for (IAtomContainer ring : singleRings.atomContainers()) {
            int value = 0;
            if (ring.contains(ringBond.getAtom(0)) && ring.contains(ringBond.getAtom(1))) {
                for (IBond bond : ring.bonds()) {
                    if (!bond.contains(ringBond.getAtom(0)) && !bond.contains(ringBond.getAtom(1))) continue;
                    value += bond.getOrder().numeric().intValue();
                }
            }
            if (value >= minValue) continue;
            minValue = value;
        }
        return minValue;
    }

    public static IRingSet getSmallestRingSet(IBond ringBond, IRingSet singleRings) {
        RingSet rs = new RingSet();
        for (IAtomContainer ring : singleRings.atomContainers()) {
            if (!ring.contains(ringBond.getAtom(0)) || !ring.contains(ringBond.getAtom(1))) continue;
            if (rs.getAtomContainerCount() == 0) {
                rs.addAtomContainer(ring);
                continue;
            }
            for (IAtomContainer smallestRing : rs.atomContainers()) {
                if (ring.getAtomCount() == smallestRing.getAtomCount()) {
                    if (rs.contains(ring)) continue;
                    rs.addAtomContainer(ring);
                    continue;
                }
                if (ring.getAtomCount() >= smallestRing.getAtomCount()) continue;
                rs.removeAllAtomContainers();
                rs.addAtomContainer(ring);
            }
        }
        return rs;
    }

    protected static void initializeMolecule(IAtomContainer atomContainer) throws CDKException {
        MoleculeInitializer.initializeMolecule(atomContainer);
    }

    public static IAtomContainer getCircularFragment(IAtomContainer mol, int startAtomIndex, int radius) throws Exception {
        IAtomContainer fragment = ExtAtomContainerManipulator.cloneWithIDs(mol);
        HashSet<IAtom> removeList = new HashSet<IAtom>();
        Collection<IAtom> solutionSphereList = Utility.circularFragment(fragment, startAtomIndex, radius);
        for (IAtom atom : fragment.atoms()) {
            if (solutionSphereList.contains(atom)) continue;
            removeList.add(atom);
        }
        Iterator it = removeList.iterator();
        while (it.hasNext()) {
            fragment.removeAtom((IAtom)it.next());
        }
        IAtomContainer canonicalise = Utility.canonicalise(fragment);
        ExtAtomContainerManipulator.aromatizeDayLight(canonicalise);
        return fragment;
    }

    public static IAtomContainer canonicalise(IAtomContainer org_mol) throws CloneNotSupportedException, CDKException {
        IAtomContainer cloneMolecule = ExtAtomContainerManipulator.cloneWithIDs(org_mol);
        int[] p = new int[cloneMolecule.getAtomCount()];
        try {
            SmilesGenerator smiles = new SmilesGenerator(1797);
            String string = smiles.create(cloneMolecule, p);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.debug("Fragment not fit to canonicalise!");
        }
        Utility.permuteWithoutClone(p, cloneMolecule);
        if (org_mol.getID() != null) {
            cloneMolecule.setID(org_mol.getID());
        }
        return cloneMolecule;
    }

    private static void permuteWithoutClone(int[] p, IAtomContainer atomContainer) {
        int n = atomContainer.getAtomCount();
        IAtom[] permutedAtoms = new IAtom[n];
        for (int i = 0; i < n; ++i) {
            IAtom atom;
            permutedAtoms[p[i]] = atom = atomContainer.getAtom(i);
            atom.setProperty("label", p[i]);
        }
        atomContainer.setAtoms(permutedAtoms);
        IBond[] bonds = AtomContainerManipulator.getBondArray(atomContainer);
        Arrays.sort(bonds, (o1, o2) -> {
            int u = (Integer)o1.getAtom(0).getProperty("label");
            int v = (Integer)o1.getAtom(1).getProperty("label");
            int x = (Integer)o2.getAtom(0).getProperty("label");
            int y = (Integer)o2.getAtom(1).getProperty("label");
            int min1 = Math.min(u, v);
            int min2 = Math.min(x, y);
            int max1 = Math.max(u, v);
            int max2 = Math.max(x, y);
            int minCmp = Integer.compare(min1, min2);
            if (minCmp != 0) {
                return minCmp;
            }
            int maxCmp = Integer.compare(max1, max2);
            if (maxCmp != 0) {
                return maxCmp;
            }
            LOGGER.debug("pokemon!");
            throw new InternalError();
        });
        atomContainer.setBonds(bonds);
    }

    public static Collection<IAtom> circularFragment(IAtomContainer atomContainer, int rootAtom, int max) throws CDKException {
        IAtom root = atomContainer.getAtom(rootAtom);
        HashSet<IAtom> paths = new HashSet<IAtom>();
        LinkedList<IAtom> closedList = new LinkedList<IAtom>();
        LinkedList<IAtom> openList = new LinkedList<IAtom>();
        openList.add(root);
        LinkedList<IAtom> neighbours = new LinkedList<IAtom>();
        int level = 0;
        while (!openList.isEmpty()) {
            IAtom currentPath = (IAtom)openList.removeFirst();
            paths.add(currentPath);
            closedList.add(currentPath);
            neighbours.addAll(atomContainer.getConnectedAtomsList(currentPath));
            if (!openList.isEmpty() || neighbours.isEmpty() || max <= level && max != -1) continue;
            neighbours.stream().filter(a -> !closedList.contains(a)).forEach(a -> openList.add((IAtom)a));
            ++level;
            neighbours.clear();
        }
        return paths;
    }

    protected static void setCircularFingerprints(String rid, IAtomContainer molOrignal, IAtom atom, Map<Integer, IPatternFingerprinter> patternFP) throws Exception, CloneNotSupportedException {
        IAtomContainer clone = molOrignal.clone();
        for (int i = 0; i < 3; ++i) {
            if (!patternFP.containsKey(i)) {
                PatternFingerprinter fp = new PatternFingerprinter();
                fp.setFingerprintID(rid + ":Signature: " + i);
                patternFP.put(i, fp);
            }
            String circularSMILES = Utility.getCircularSMILES(clone, atom, i, true);
            patternFP.get(i).add(new Feature(circularSMILES, 1.0));
        }
        if (!patternFP.containsKey(-1)) {
            PatternFingerprinter fp = new PatternFingerprinter();
            fp.setFingerprintID(rid + ":Signature: -1");
            patternFP.put(-1, fp);
        }
        String circularSMILES = Utility.getCircularSMILES(clone, atom, -1, true);
        patternFP.get(-1).add(new Feature(circularSMILES, 1.0));
    }

    protected static List<ReactionCenterFragment> getCircularReactionPatternFingerprints(IAtomContainer molOrignal, IAtom atom, EnumSubstrateProduct type) throws Exception, CloneNotSupportedException {
        ArrayList<ReactionCenterFragment> fragmentsRC = new ArrayList<ReactionCenterFragment>();
        IAtomContainer clone = molOrignal.clone();
        for (int i = 0; i < 3; ++i) {
            String smiles = Utility.getCircularSMILES(clone, atom, i, true);
            ReactionCenterFragment reactionCenterFragment = new ReactionCenterFragment(smiles, i, type);
            fragmentsRC.add(reactionCenterFragment);
        }
        String smiles = Utility.getCircularSMILES(clone, atom, -1, true);
        ReactionCenterFragment reactionCenterFragment = new ReactionCenterFragment(smiles, -1, type);
        fragmentsRC.add(reactionCenterFragment);
        return fragmentsRC;
    }
}

