/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.signature;

import java.util.List;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import signature.AbstractVertexSignature;

public class RBlastAtomSignature
extends AbstractVertexSignature {
    public static final String CHARGE_SEPARATOR = ":";
    private final IAtomContainer atomContainer;
    private boolean useAromatics = true;
    private boolean useCharge = true;
    private boolean isBondSensitive = true;

    public RBlastAtomSignature(int atomIndex, IAtomContainer atomContainer) {
        this.atomContainer = atomContainer;
        super.createMaximumHeight(atomIndex, atomContainer.getAtomCount());
    }

    public RBlastAtomSignature(int atomIndex, IAtomContainer atomContainer, int height) {
        this.atomContainer = atomContainer;
        super.create(atomIndex, atomContainer.getAtomCount(), height);
    }

    public boolean isUseAromatics() {
        return this.useAromatics;
    }

    public void setUseAromatics(boolean useAromatics) {
        this.useAromatics = useAromatics;
    }

    public boolean isUseCharge() {
        return this.useCharge;
    }

    public void setUseCharge(boolean useCharge) {
        this.useCharge = useCharge;
    }

    public boolean isBondSensitive() {
        return this.isBondSensitive;
    }

    public void setBondSensitive(boolean isBondSensitive) {
        this.isBondSensitive = isBondSensitive;
    }

    @Override
    public String getVertexSymbol(int atomIndex) {
        IAtom atom = this.atomContainer.getAtom(atomIndex);
        Integer charge = atom.getFormalCharge();
        if (!this.useCharge || charge == null || charge == 0) {
            return atom.getSymbol();
        }
        return atom.getSymbol() + CHARGE_SEPARATOR + charge;
    }

    @Override
    protected int[] getConnected(int atomIndex) {
        List<IAtom> connectedAtoms = this.atomContainer.getConnectedAtomsList(this.atomContainer.getAtom(atomIndex));
        int[] connected = new int[connectedAtoms.size()];
        int i = 0;
        for (IAtom connectedAtom : connectedAtoms) {
            connected[i] = this.atomContainer.indexOf(connectedAtom);
            ++i;
        }
        return connected;
    }

    @Override
    protected String getEdgeLabel(int atomIndexA, int atomIndexB) {
        IAtom atomA = this.atomContainer.getAtom(atomIndexA);
        IAtom atomB = this.atomContainer.getAtom(atomIndexB);
        IBond bond = this.atomContainer.getBond(atomA, atomB);
        if (this.useAromatics && bond.getFlag(32)) {
            return "@";
        }
        if (this.useAromatics && bond.getFlag(2)) {
            return "%";
        }
        if (!this.isBondSensitive) {
            return "";
        }
        switch (bond.getOrder()) {
            case SINGLE: {
                return "";
            }
            case DOUBLE: {
                return "=";
            }
            case TRIPLE: {
                return "#";
            }
            case QUADRUPLE: {
                return "$";
            }
        }
        return "";
    }

    @Override
    protected int getIntLabel(int atomIndex) {
        return 0;
    }

    @Override
    protected int convertEdgeLabelToColor(String edgeLabel) {
        switch (edgeLabel) {
            case "": {
                return 1;
            }
            case "=": {
                return 2;
            }
            case "#": {
                return 3;
            }
            case "$": {
                return 4;
            }
            case "@": {
                return 5;
            }
            case "%": {
                return 6;
            }
        }
        return 0;
    }
}

