/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.signature;

import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import signature.AbstractGraphBuilder;

public class RBlastMoleculeFromSignatureBuilder
extends AbstractGraphBuilder {
    private final IChemObjectBuilder builder;
    private IAtomContainer container;
    private boolean useAromatics = true;
    private boolean useCharge = true;
    private boolean isBondSensitive = true;

    public RBlastMoleculeFromSignatureBuilder(IChemObjectBuilder builder) {
        this.builder = builder;
    }

    @Override
    public void makeEdge(int vertexIndex1, int vertexIndex2, String vertexSymbol1, String vertexSymbol2, String edgeLabel) {
        if (edgeLabel.isEmpty() || !this.isBondSensitive) {
            this.container.addBond(vertexIndex1, vertexIndex2, IBond.Order.SINGLE);
        } else if (edgeLabel.equals("=")) {
            this.container.addBond(vertexIndex1, vertexIndex2, IBond.Order.DOUBLE);
        } else if (edgeLabel.equals("#")) {
            this.container.addBond(vertexIndex1, vertexIndex2, IBond.Order.TRIPLE);
        } else if (edgeLabel.equals("@")) {
            this.container.addBond(vertexIndex1, vertexIndex2, IBond.Order.SINGLE);
            if (this.useAromatics) {
                IBond bond = this.container.getBond(this.container.getBondCount() - 1);
                bond.getAtom(0).setFlag(32, true);
                bond.getAtom(1).setFlag(32, true);
                bond.setFlag(32, true);
            }
        } else if (edgeLabel.equals("%")) {
            this.container.addBond(vertexIndex1, vertexIndex2, IBond.Order.SINGLE);
            if (this.useAromatics) {
                IBond bond = this.container.getBond(this.container.getBondCount() - 1);
                bond.getAtom(0).setFlag(2, true);
                bond.getAtom(1).setFlag(2, true);
                bond.setFlag(2, true);
            }
        }
    }

    @Override
    public void makeGraph() {
        this.container = this.builder.newInstance(IAtomContainer.class, new Object[0]);
    }

    @Override
    public void makeVertex(String label) {
        IAtom atom;
        if (label.contains(":")) {
            String[] parts = label.split("\\:");
            atom = this.builder.newInstance(IAtom.class, parts[0]);
            if (this.useCharge) {
                int charge = Integer.parseInt(parts[1]);
                atom.setFormalCharge(charge);
            }
        } else {
            atom = this.builder.newInstance(IAtom.class, label);
        }
        this.container.addAtom(atom);
    }

    public IAtomContainer getAtomContainer() {
        return this.container;
    }

    public boolean isUseAromatics() {
        return this.useAromatics;
    }

    public void setUseAromatics(boolean useAromatics) {
        this.useAromatics = useAromatics;
    }

    public boolean isUseCharge() {
        return this.useCharge;
    }

    public void setUseCharge(boolean useCharge) {
        this.useCharge = useCharge;
    }

    public boolean isBondSensitive() {
        return this.isBondSensitive;
    }

    public void setBondSensitive(boolean isBondSensitive) {
        this.isBondSensitive = isBondSensitive;
    }
}

