/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.signature;

import java.util.ArrayList;
import java.util.List;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.tools.manipulator.ReactionManipulator;
import uk.ac.ebi.reactionblast.signature.RBlastAtomSignature;
import uk.ac.ebi.reactionblast.signature.RBlastMoleculeSignature;

public class SignatureMatcher {
    private int minHeight;
    private int maxHeight;

    public SignatureMatcher() {
        this(1, 3);
    }

    public SignatureMatcher(int minHeight) {
        this(minHeight, 3);
    }

    public SignatureMatcher(int minHeight, int maxHeight) {
        this.minHeight = minHeight;
        this.maxHeight = maxHeight;
    }

    public List<IAtom> getMatchingRootAtoms(List<String> signatureStrings, IReaction reaction) {
        ArrayList<IAtom> roots = new ArrayList<IAtom>();
        for (IAtomContainer atomContainer : ReactionManipulator.getAllAtomContainers(reaction)) {
            this.getMatchingRootAtoms(roots, signatureStrings, atomContainer);
        }
        return roots;
    }

    public List<IAtom> getMatchingRootAtoms(List<String> signatureStrings, IAtomContainer atomContainer) {
        ArrayList<IAtom> roots = new ArrayList<IAtom>();
        this.getMatchingRootAtoms(roots, signatureStrings, atomContainer);
        return roots;
    }

    private void getMatchingRootAtoms(List<IAtom> roots, List<String> signatureStrings, IAtomContainer atomContainer) {
        RBlastMoleculeSignature moleculeSignature = new RBlastMoleculeSignature(atomContainer);
        for (int atomIndex = 0; atomIndex < atomContainer.getAtomCount(); ++atomIndex) {
            RBlastAtomSignature matchingAtomSignature = this.match(atomIndex, signatureStrings, moleculeSignature);
            if (matchingAtomSignature == null) continue;
            roots.add(atomContainer.getAtom(atomIndex));
        }
    }

    private RBlastAtomSignature match(int atomIndex, List<String> signatureStrings, RBlastMoleculeSignature moleculeSignature) {
        for (int height = this.maxHeight; height >= this.minHeight; --height) {
            RBlastAtomSignature sigOfHAtI = moleculeSignature.getAtomSignature(atomIndex, height);
            String signatureStringOfHAtI = sigOfHAtI.toCanonicalString();
            for (String querySignatureString : signatureStrings) {
                if (!querySignatureString.equals(signatureStringOfHAtI)) continue;
                System.out.println("match of height " + height + " at " + atomIndex + " to " + querySignatureString);
                return sigOfHAtI;
            }
        }
        return null;
    }
}

