/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.stereo.compare;

import java.util.Iterator;
import java.util.Map;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.smsd.Isomorphism;
import org.openscience.smsd.algorithm.matchers.AtomBondMatcher;
import org.openscience.smsd.algorithm.matchers.AtomMatcher;
import org.openscience.smsd.algorithm.matchers.BondMatcher;
import org.openscience.smsd.interfaces.Algorithm;
import uk.ac.ebi.reactionblast.stereo.IStereoAndConformation;
import uk.ac.ebi.reactionblast.stereo.tools.Chirality2DTool;
import uk.ac.ebi.reactionblast.stereo.tools.Chirality3DTool;

public class ChiralityComparisonTool {
    public static void compare(IAtomContainer atomContainerA, IAtomContainer atomContainerB) throws Exception {
        Map<IAtom, IStereoAndConformation> chiralityMapA = ChiralityComparisonTool.has3DCoordinates(atomContainerA) ? new Chirality3DTool().getTetrahedralChiralities(atomContainerA) : new Chirality2DTool().getTetrahedralChiralities(atomContainerA);
        Map<IAtom, IStereoAndConformation> chiralityMapB = ChiralityComparisonTool.has3DCoordinates(atomContainerB) ? new Chirality3DTool().getTetrahedralChiralities(atomContainerB) : new Chirality2DTool().getTetrahedralChiralities(atomContainerB);
        AtomMatcher atomMatcher = AtomBondMatcher.atomMatcher(false, false);
        BondMatcher bondMatcher = AtomBondMatcher.bondMatcher(true, false);
        Isomorphism isomorphism = new Isomorphism(atomContainerA, atomContainerB, Algorithm.DEFAULT, atomMatcher, bondMatcher);
        Map<IAtom, IAtom> atomMap = isomorphism.getFirstAtomMapping().getMappingsByAtoms();
        atomMap.keySet().stream().forEach(atomA -> {
            IAtom atomB = (IAtom)atomMap.get(atomA);
            boolean isStereoA = chiralityMapA.containsKey(atomA);
            boolean isStereoB = chiralityMapB.containsKey(atomB);
            if (isStereoA && isStereoB) {
                IStereoAndConformation stereoA = (IStereoAndConformation)chiralityMapA.get(atomA);
                IStereoAndConformation stereoB = (IStereoAndConformation)chiralityMapB.get(atomB);
                System.out.println(stereoA + " " + stereoB);
            }
        });
    }

    private static boolean has3DCoordinates(IAtomContainer atomContainerA) {
        Iterator<IAtom> iterator = atomContainerA.atoms().iterator();
        if (iterator.hasNext()) {
            IAtom atom = iterator.next();
            return atom.getPoint3d() != null;
        }
        return false;
    }

    private ChiralityComparisonTool() {
    }
}

