/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.stereo.compare;

import java.util.List;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.geometry.cip.CIPTool;
import org.openscience.cdk.geometry.cip.ILigand;
import org.openscience.cdk.geometry.cip.VisitedAtoms;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.tools.SaturationChecker;

public class StereoCenterAnalyser {
    public static synchronized boolean hasPotentialStereoCenter(IAtom atom, IAtomContainer atomContainer) {
        List<IAtom> neighbours = atomContainer.getConnectedAtomsList(atom);
        int numberOfNeighbours = neighbours.size();
        boolean hasImplicitHydrogen = false;
        if (numberOfNeighbours == 4) {
            hasImplicitHydrogen = false;
        } else if (numberOfNeighbours == 3) {
            Integer implicitCount = atom.getImplicitHydrogenCount();
            if (implicitCount != null && implicitCount == 1) {
                hasImplicitHydrogen = true;
            } else {
                SaturationChecker checker = new SaturationChecker();
                try {
                    if (checker.calculateNumberOfImplicitHydrogens(atom, atomContainer) == 1) {
                        hasImplicitHydrogen = true;
                    }
                }
                catch (CDKException e) {
                    e.printStackTrace();
                }
            }
            if (!hasImplicitHydrogen) {
                return false;
            }
        } else {
            if (numberOfNeighbours > 4) {
                return false;
            }
            if (numberOfNeighbours < 3) {
                return false;
            }
        }
        ILigand[] ligands = new ILigand[4];
        int index = 0;
        VisitedAtoms bitSet = new VisitedAtoms();
        int chiralAtomIndex = atomContainer.indexOf(atom);
        for (IAtom neighbour : neighbours) {
            int ligandAtomIndex = atomContainer.indexOf(neighbour);
            ligands[index] = CIPTool.defineLigand(atomContainer, bitSet, chiralAtomIndex, ligandAtomIndex);
            ++index;
        }
        if (hasImplicitHydrogen) {
            ligands[index] = CIPTool.defineLigand(atomContainer, bitSet, chiralAtomIndex, -1);
        }
        CIPTool.order(ligands);
        return CIPTool.checkIfAllLigandsAreDifferent(ligands);
    }

    private StereoCenterAnalyser() {
    }
}

