/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.stereo.ebi;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.smsd.tools.ExtAtomContainerManipulator;
import uk.ac.ebi.centres.cdk.CDKPerceptor;
import uk.ac.ebi.centres.descriptor.Planar;
import uk.ac.ebi.centres.descriptor.Tetrahedral;
import uk.ac.ebi.centres.descriptor.Trigonal;
import uk.ac.ebi.reactionblast.mechanism.helper.Utility;
import uk.ac.ebi.reactionblast.stereo.IStereoAndConformation;

public abstract class StereoCenteralityTool
extends Utility {
    private static final ILoggingTool LOGGER = LoggingToolFactory.createLoggingTool(StereoCenteralityTool.class);
    private static final long serialVersionUID = 17867606807697859L;

    private static IAtom getAtomByID(String id, IAtomContainer ac) {
        for (IAtom a : ac.atoms()) {
            if (!a.getID().equals(id)) continue;
            return a;
        }
        return null;
    }

    public static Map<IAtom, IStereoAndConformation> getChirality2D(IReaction reaction) throws CDKException, CloneNotSupportedException {
        Map<IAtom, IStereoAndConformation> chirality2D;
        IAtomContainer containerWithoutH;
        HashMap<IAtom, IStereoAndConformation> chiralityMap = new HashMap<IAtom, IStereoAndConformation>();
        CDKPerceptor perceptor = new CDKPerceptor();
        for (IAtomContainer ac : reaction.getReactants().atomContainers()) {
            containerWithoutH = ExtAtomContainerManipulator.removeHydrogensExceptSingleAndPreserveAtomID(ac);
            chirality2D = StereoCenteralityTool.getChirality2D(containerWithoutH, perceptor);
            if (chirality2D.isEmpty()) continue;
            chirality2D.entrySet().stream().forEach(m -> {
                IAtom atomByID = StereoCenteralityTool.getAtomByID(((IAtom)m.getKey()).getID(), ac);
                if (atomByID != null) {
                    atomByID.setProperty("Stereo", m.getValue());
                    chiralityMap.put(atomByID, (IStereoAndConformation)m.getValue());
                }
            });
        }
        for (IAtomContainer ac : reaction.getProducts().atomContainers()) {
            containerWithoutH = ExtAtomContainerManipulator.removeHydrogensExceptSingleAndPreserveAtomID(ac);
            chirality2D = StereoCenteralityTool.getChirality2D(containerWithoutH, perceptor);
            if (chirality2D.isEmpty()) continue;
            chirality2D.entrySet().stream().forEach(m -> {
                IAtom atomByID = StereoCenteralityTool.getAtomByID(((IAtom)m.getKey()).getID(), ac);
                if (atomByID != null) {
                    atomByID.setProperty("Stereo", m.getValue());
                    chiralityMap.put(atomByID, (IStereoAndConformation)m.getValue());
                }
            });
        }
        return chiralityMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<IAtom, IStereoAndConformation> getChirality2D(IAtomContainer ac, CDKPerceptor perceptor) {
        HashMap<IAtom, IStereoAndConformation> chiralityMap = new HashMap<IAtom, IStereoAndConformation>();
        Boolean flag = false;
        ExecutorService executor = Executors.newCachedThreadPool();
        Callable<Boolean> task = () -> {
            perceptor.perceive(ac);
            return true;
        };
        Future<Boolean> future = executor.submit(task);
        try {
            flag = future.get(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException ex) {
            flag = false;
        }
        finally {
            future.cancel(true);
        }
        if (!flag.booleanValue()) {
            LOGGER.error(Level.WARNING, null, "Time out hit in computing stereo centers");
        }
        for (IAtom atom2 : ac.atoms()) {
            if (Tetrahedral.R.equals(atom2.getProperty("descriptor"))) {
                chiralityMap.put(atom2, IStereoAndConformation.R);
                continue;
            }
            if (Tetrahedral.S.equals(atom2.getProperty("descriptor"))) {
                chiralityMap.put(atom2, IStereoAndConformation.S);
                continue;
            }
            if (Planar.E.equals(atom2.getProperty("descriptor"))) {
                chiralityMap.put(atom2, IStereoAndConformation.E);
                continue;
            }
            if (Planar.Z.equals(atom2.getProperty("descriptor"))) {
                chiralityMap.put(atom2, IStereoAndConformation.Z);
                continue;
            }
            if (Trigonal.Re.equals(atom2.getProperty("descriptor"))) {
                chiralityMap.put(atom2, IStereoAndConformation.P);
                continue;
            }
            if (Trigonal.Si.equals(atom2.getProperty("descriptor"))) {
                chiralityMap.put(atom2, IStereoAndConformation.M);
                continue;
            }
            chiralityMap.put(atom2, IStereoAndConformation.NONE);
        }
        for (IBond bond : ac.bonds()) {
            if (Planar.E.equals(bond.getProperty("descriptor"))) {
                chiralityMap.put(bond.getAtom(0), IStereoAndConformation.E);
                chiralityMap.put(bond.getAtom(1), IStereoAndConformation.E);
                continue;
            }
            if (Planar.Z.equals(bond.getProperty("descriptor"))) {
                chiralityMap.put(bond.getAtom(0), IStereoAndConformation.Z);
                chiralityMap.put(bond.getAtom(1), IStereoAndConformation.Z);
                continue;
            }
            if (Trigonal.Re.equals(bond.getProperty("descriptor"))) {
                chiralityMap.put(bond.getAtom(0), IStereoAndConformation.P);
                chiralityMap.put(bond.getAtom(1), IStereoAndConformation.P);
                continue;
            }
            if (!Trigonal.Si.equals(bond.getProperty("descriptor"))) continue;
            chiralityMap.put(bond.getAtom(0), IStereoAndConformation.M);
            chiralityMap.put(bond.getAtom(1), IStereoAndConformation.M);
        }
        chiralityMap.keySet().stream().forEach(atom -> atom.setProperty("Stereo", chiralityMap.get(atom)));
        return chiralityMap;
    }
}

