/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.stereo.tools;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openscience.cdk.geometry.cip.CIPTool;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.ITetrahedralChirality;
import org.openscience.cdk.stereo.StereoTool;
import org.openscience.cdk.stereo.TetrahedralChirality;
import uk.ac.ebi.reactionblast.stereo.IStereoAndConformation;
import uk.ac.ebi.reactionblast.stereo.compare.ChiralityTool;

public class Chirality3DTool
implements ChiralityTool {
    @Override
    public Map<IAtom, IStereoAndConformation> getTetrahedralChiralities(IAtomContainer atomContainer) {
        return this.getTetrahedralChiralities(atomContainer, false);
    }

    @Override
    public Map<IAtom, IStereoAndConformation> getTetrahedralChiralities(IAtomContainer atomContainer, boolean getNoneAssigments) {
        HashMap<IAtom, IStereoAndConformation> chiralMap = new HashMap<IAtom, IStereoAndConformation>();
        for (IAtom atom : atomContainer.atoms()) {
            List<IAtom> neighbours = atomContainer.getConnectedAtomsList(atom);
            if (neighbours.size() != 4) continue;
            IAtom n1 = neighbours.get(0);
            IAtom n2 = neighbours.get(1);
            IAtom n3 = neighbours.get(2);
            IAtom n4 = neighbours.get(3);
            ITetrahedralChirality.Stereo stereo = StereoTool.getStereo(n1, n2, n3, n4);
            IAtom[] ligands = new IAtom[]{n1, n2, n3, n4};
            TetrahedralChirality stereoCenter = new TetrahedralChirality(atom, ligands, stereo);
            CIPTool.CIP_CHIRALITY chirality = CIPTool.getCIPChirality(atomContainer, stereoCenter);
            if (!getNoneAssigments && chirality == CIPTool.CIP_CHIRALITY.NONE) continue;
            switch (chirality) {
                case NONE: {
                    chiralMap.put(atom, IStereoAndConformation.NONE);
                }
                case R: {
                    chiralMap.put(atom, IStereoAndConformation.R);
                }
                case S: {
                    chiralMap.put(atom, IStereoAndConformation.S);
                }
            }
            chiralMap.put(atom, IStereoAndConformation.NONE);
        }
        return chiralMap;
    }
}

