/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.stereo.wedge;

import java.util.ArrayList;
import java.util.SortedMap;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IStereoElement;
import org.openscience.cdk.interfaces.ITetrahedralChirality;
import org.openscience.cdk.stereo.TetrahedralChirality;
import uk.ac.ebi.reactionblast.stereo.wedge.WedgeRule;

public class ExplicitHydrogenSingleDownWedgeRule
extends WedgeRule {
    private final IBond.Stereo[] pattern = new IBond.Stereo[]{IBond.Stereo.DOWN, IBond.Stereo.NONE, IBond.Stereo.NONE, IBond.Stereo.NONE};

    @Override
    public IBond.Stereo[] getPattern() {
        return this.pattern;
    }

    @Override
    public IStereoElement execute(IAtom centralAtom, IAtomContainer atomContainer, SortedMap<Double, IBond> angleMap) {
        int[] permutation = this.getMatchPermutation();
        ArrayList<IBond> bonds = new ArrayList<IBond>(angleMap.values());
        IAtom[] ligandAtoms = new IAtom[4];
        for (int index = 0; index < 4; ++index) {
            IBond bond = (IBond)bonds.get(permutation[index]);
            ligandAtoms[index] = bond.getOther(centralAtom);
        }
        ITetrahedralChirality.Stereo chirality = ITetrahedralChirality.Stereo.ANTI_CLOCKWISE;
        return new TetrahedralChirality(centralAtom, ligandAtoms, chirality);
    }
}

