/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.stereo.wedge;

import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IStereoElement;
import uk.ac.ebi.reactionblast.stereo.IStereoAndConformation;
import uk.ac.ebi.reactionblast.stereo.compare.StereoCenterAnalyser;
import uk.ac.ebi.reactionblast.stereo.tools.Chirality2DTool;
import uk.ac.ebi.reactionblast.stereo.wedge.WedgeStereoAnalysisResult;
import uk.ac.ebi.reactionblast.stereo.wedge.WedgeStereoLifter;

public class WedgeStereoAnalyser {
    public static WedgeStereoAnalysisResult getResult(IAtom atom, IAtomContainer atomContainer, WedgeStereoLifter lifter) {
        boolean isPotentialStereoCenter = StereoCenterAnalyser.hasPotentialStereoCenter(atom, atomContainer);
        IStereoElement element = lifter.lift(atom, atomContainer);
        return WedgeStereoAnalyser.getResult(atomContainer, isPotentialStereoCenter, element);
    }

    private static WedgeStereoAnalysisResult getResult(IAtomContainer atomContainer, boolean isPotentialStereoCenter, IStereoElement stereoElement) {
        if (isPotentialStereoCenter) {
            if (stereoElement == null) {
                return WedgeStereoAnalysisResult.MISSING;
            }
            IStereoAndConformation chirality = Chirality2DTool.getChirality2D(stereoElement, atomContainer);
            WedgeStereoAnalysisResult result = WedgeStereoAnalyser.convertCipToResult(chirality);
            if (result == WedgeStereoAnalysisResult.NONE) {
                return WedgeStereoAnalysisResult.ERROR;
            }
            return result;
        }
        if (stereoElement == null) {
            return WedgeStereoAnalysisResult.NONE;
        }
        return WedgeStereoAnalysisResult.ERROR;
    }

    private static WedgeStereoAnalysisResult convertCipToResult(IStereoAndConformation cipChirality) {
        switch (cipChirality) {
            case NONE: {
                return WedgeStereoAnalysisResult.NONE;
            }
            case R: {
                return WedgeStereoAnalysisResult.CHIRAL_R;
            }
            case S: {
                return WedgeStereoAnalysisResult.CHIRAL_S;
            }
        }
        return WedgeStereoAnalysisResult.NONE;
    }

    private WedgeStereoAnalyser() {
    }
}

