/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.stereo.wedge;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import javax.vecmath.Point2d;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IStereoElement;
import uk.ac.ebi.reactionblast.stereo.wedge.ACWTetrahedralWedgeRule;
import uk.ac.ebi.reactionblast.stereo.wedge.CWTetrahedralWedgeRule;
import uk.ac.ebi.reactionblast.stereo.wedge.ExplicitHydrogenSingleDownWedgeRule;
import uk.ac.ebi.reactionblast.stereo.wedge.ExplicitHydrogenSingleUpWedgeRule;
import uk.ac.ebi.reactionblast.stereo.wedge.FullTetrahedralWedgeRule;
import uk.ac.ebi.reactionblast.stereo.wedge.WedgeRule;

public class WedgeStereoLifter {
    private final List<WedgeRule> rules = new ArrayList<WedgeRule>();

    public WedgeStereoLifter() {
        this.rules.add(new CWTetrahedralWedgeRule());
        this.rules.add(new ACWTetrahedralWedgeRule());
        this.rules.add(new ExplicitHydrogenSingleUpWedgeRule());
        this.rules.add(new ExplicitHydrogenSingleDownWedgeRule());
        this.rules.add(new FullTetrahedralWedgeRule());
    }

    private WedgeRule getRule(IBond.Stereo[] stereos) {
        for (WedgeRule rule : this.rules) {
            if (!rule.matches(stereos)) continue;
            return rule;
        }
        return null;
    }

    public IStereoElement lift(IAtom atom, IAtomContainer atomContainer) {
        List<IBond> bonds = atomContainer.getConnectedBondsList(atom);
        if (bonds.size() < 3) {
            return null;
        }
        IBond referenceBond = bonds.get(0);
        IAtom reference = referenceBond.getOther(atom);
        TreeMap<Double, IBond> angleMap = new TreeMap<Double, IBond>();
        angleMap.put(0.0, referenceBond);
        for (int index = 1; index < bonds.size(); ++index) {
            IBond bond = bonds.get(index);
            IAtom bondAtom = bond.getOther(atom);
            double angle = this.getFullAngle(atom, reference, bondAtom);
            angleMap.put(Math.PI * 2 - angle, bond);
        }
        IBond.Stereo[] stereos = new IBond.Stereo[bonds.size()];
        int i = 0;
        for (Double angle : angleMap.keySet()) {
            IBond bond = (IBond)angleMap.get(angle);
            stereos[i] = bond.getStereo();
            ++i;
        }
        WedgeRule rule = this.getRule(stereos);
        if (rule != null) {
            return rule.execute(atom, atomContainer, angleMap);
        }
        return null;
    }

    private double getFullAngle(IAtom centralAtom, IAtom partner1, IAtom partner2) {
        Point2d atomP = centralAtom.getPoint2d();
        Point2d partner1P = partner1.getPoint2d();
        Point2d partner2P = partner2.getPoint2d();
        double angle1 = Math.atan2(partner1P.y - atomP.y, partner1P.x - atomP.x);
        double angle2 = Math.atan2(partner2P.y - atomP.y, partner2P.x - atomP.x);
        double angle = angle2 - angle1;
        if (angle2 < 0.0 && angle1 > 0.0 && angle2 < -1.5707963267948966) {
            angle = Math.PI + angle2 + Math.PI - angle1;
        }
        if (angle2 > 0.0 && angle1 < 0.0 && angle1 < -1.5707963267948966) {
            angle = -Math.PI + angle2 - Math.PI - angle1;
        }
        if (angle < 0.0) {
            return Math.PI * 2 + angle;
        }
        return angle;
    }
}

