/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.tools;

import java.util.Map;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IReaction;

public abstract class BasicDebugger {
    protected static final String NEW_LINE = System.getProperty("line.separator");

    public static void printAtomAtomMapping(Map<IAtom, IAtom> mappings) {
        System.out.println();
        mappings.entrySet().stream().map(m -> {
            System.out.println("e:" + ((IAtom)m.getKey()).getID());
            return m;
        }).forEach(m -> System.out.println("p:" + ((IAtom)m.getValue()).getID()));
    }

    protected static void printReaction(IReaction reaction) {
        IAtomContainer M;
        int j;
        IAtomContainerSet Educt = reaction.getReactants();
        IAtomContainerSet Product2 = reaction.getProducts();
        System.out.println("*******************************");
        System.out.println("Educt Mol Count: " + Educt.getAtomContainerCount());
        System.out.println("*******************************");
        for (j = 0; j < Educt.getAtomContainerCount(); ++j) {
            M = Educt.getAtomContainer(j);
            System.out.println("Mol ID: " + M.getID());
            System.out.println("SingleElectron: " + M.getSingleElectronCount());
            System.out.println("Stoic: " + reaction.getReactantCoefficient(M));
            System.out.println("Split Mol Atom Count: " + M.getAtomCount());
            BasicDebugger.printAtoms(M);
        }
        System.out.println("*******************************");
        System.out.println("Product Mol Count: " + Product2.getAtomContainerCount());
        System.out.println("*******************************");
        for (j = 0; j < Product2.getAtomContainerCount(); ++j) {
            M = Product2.getAtomContainer(j);
            System.out.println("Mol ID: " + M.getID());
            System.out.println("SingleElectron: " + M.getSingleElectronCount());
            System.out.println("Stoic: " + reaction.getProductCoefficient(M));
            System.out.println("Split Mol Atom Count: " + M.getAtomCount());
            BasicDebugger.printAtoms(M);
        }
        System.out.println(NEW_LINE + "%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%" + NEW_LINE + NEW_LINE);
    }

    protected static void printAtoms(IAtomContainer mol) {
        System.out.print("Atom: ");
        for (IAtom a : mol.atoms()) {
            System.out.print(a.getSymbol());
            if (a.getID() == null) continue;
            System.out.print("[" + a.getID() + "]");
        }
        System.out.println();
        System.out.println();
    }

    protected static void printMolecule(IAtomContainer molecule) {
        System.out.println("AtomContainer " + molecule.getID() + ": " + molecule.getAtomCount());
        for (int i = 0; i < molecule.getAtomCount(); ++i) {
            System.out.print(molecule.getAtom(i).getSymbol() + " : " + molecule.getAtom(i).getID() + ",  ");
        }
        System.out.println();
    }
}

