/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.tools;

import java.util.BitSet;

public class Distance {
    private static BitSet A;
    private static BitSet B;

    public static double getEuclideanDistance(BitSet Molecule1, BitSet Molecule2) throws Exception {
        A = (BitSet)Molecule1.clone();
        B = (BitSet)Molecule2.clone();
        float _bitset1_cardinality = A.cardinality();
        float _bitset2_cardinality = B.cardinality();
        if (A.size() != B.size()) {
            throw new Exception("Bisets must have the same bit length");
        }
        BitSet one_and_two = (BitSet)A.clone();
        one_and_two.and(B);
        float _common_bit_count = one_and_two.cardinality();
        double Val = Math.sqrt(_bitset1_cardinality + _bitset2_cardinality - _common_bit_count - _common_bit_count);
        return Val;
    }

    public static double getNormalizedEuclideanDistance(BitSet Molecule1, BitSet Molecule2) throws Exception {
        A = (BitSet)Molecule1.clone();
        B = (BitSet)Molecule2.clone();
        float _bitset1_cardinality = A.cardinality();
        float _bitset2_cardinality = B.cardinality();
        if (A.size() != B.size()) {
            throw new Exception("Bisets must have the same bit length");
        }
        BitSet one_and_two = (BitSet)A.clone();
        one_and_two.and(B);
        float _common_bit_count = one_and_two.cardinality();
        double Val = Math.sqrt(_bitset1_cardinality + _bitset2_cardinality - _common_bit_count - _common_bit_count);
        float N1 = _bitset1_cardinality + _bitset2_cardinality - _common_bit_count;
        float N2 = 1.0f - _bitset1_cardinality - _bitset2_cardinality + _common_bit_count;
        float N = N1 + N2;
        return Val / (double)N;
    }

    public static double getHammingDistance(BitSet Molecule1, BitSet Molecule2) throws Exception {
        A = (BitSet)Molecule1.clone();
        B = (BitSet)Molecule2.clone();
        float _bitset1_cardinality = A.cardinality();
        float _bitset2_cardinality = B.cardinality();
        if (A.size() != B.size()) {
            throw new Exception("Bisets must have the same bit length");
        }
        BitSet one_and_two = (BitSet)A.clone();
        one_and_two.and(B);
        float _common_bit_count = one_and_two.cardinality();
        double Val = _bitset1_cardinality + _bitset2_cardinality - _common_bit_count - _common_bit_count;
        return Val;
    }

    public static double getNormalizedHammingDistance(BitSet Molecule1, BitSet Molecule2) throws Exception {
        A = (BitSet)Molecule1.clone();
        B = (BitSet)Molecule2.clone();
        float _bitset1_cardinality = A.cardinality();
        float _bitset2_cardinality = B.cardinality();
        if (A.size() != B.size()) {
            throw new Exception("Bisets must have the same bit length");
        }
        BitSet one_and_two = (BitSet)A.clone();
        one_and_two.and(B);
        float _common_bit_count = one_and_two.cardinality();
        double Val = _bitset1_cardinality + _bitset2_cardinality - _common_bit_count - _common_bit_count;
        float N1 = _bitset1_cardinality + _bitset2_cardinality - _common_bit_count;
        float N2 = 1.0f - _bitset1_cardinality - _bitset2_cardinality + _common_bit_count;
        float N = N1 + N2;
        return Val / (double)N;
    }

    public static double getSoergelDistance(BitSet Molecule1, BitSet Molecule2) throws Exception {
        A = (BitSet)Molecule1.clone();
        B = (BitSet)Molecule2.clone();
        float _bitset1_cardinality = A.cardinality();
        float _bitset2_cardinality = B.cardinality();
        if (A.size() != B.size()) {
            throw new Exception("Bisets must have the same bit length");
        }
        BitSet one_and_two = (BitSet)A.clone();
        one_and_two.and(B);
        float _common_bit_count = one_and_two.cardinality();
        double Val = (_bitset1_cardinality + _bitset2_cardinality - _common_bit_count) / _common_bit_count;
        return Val;
    }

    private Distance() {
    }
}

