/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.tools;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StreamTokenizer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import uk.ac.ebi.reactionblast.tools.matrix.CholeskyDecomposition;
import uk.ac.ebi.reactionblast.tools.matrix.EigenvalueDecomposition;
import uk.ac.ebi.reactionblast.tools.matrix.LUDecomposition;
import uk.ac.ebi.reactionblast.tools.matrix.Maths;
import uk.ac.ebi.reactionblast.tools.matrix.QRDecomposition;
import uk.ac.ebi.reactionblast.tools.matrix.SingularValueDecomposition;

public class EBIMatrix
implements Cloneable,
Serializable {
    static final String NEW_LINE = System.getProperty("line.separator");
    private static final long serialVersionUID = 19787786981017786L;
    private static final ILoggingTool LOGGER = LoggingToolFactory.createLoggingTool(EBIMatrix.class);
    private double[][] matrix;
    private int rows;
    private int columns;

    public static List<Double> elimination(EBIMatrix matrix, List<Double> vector) {
        int k;
        int j;
        int n = vector.size();
        int[] pivot = new int[n];
        EBIMatrix a = matrix.duplicate();
        ArrayList<Double> b = new ArrayList<Double>(vector);
        for (j = 0; j < n - 1; ++j) {
            int i;
            double c = Math.abs(a.matrix[j][j]);
            pivot[j] = j;
            int ipvt = j;
            for (i = j + 1; i < n; ++i) {
                if (!(Math.abs(a.matrix[i][j]) > c)) continue;
                c = Math.abs(a.matrix[i][j]);
                ipvt = i;
            }
            if (pivot[j] != ipvt) {
                double temp;
                pivot[j] = ipvt;
                pivot[ipvt] = j;
                for (k = 0; k < n; ++k) {
                    temp = a.matrix[j][k];
                    a.matrix[j][k] = a.matrix[pivot[j]][k];
                    a.matrix[pivot[j]][k] = temp;
                }
                temp = (Double)b.get(j);
                b.set(j, (Double)b.get(pivot[j]));
                b.set(pivot[j], temp);
            }
            for (i = j + 1; i < n; ++i) {
                double[] dArray = a.matrix[i];
                int n2 = j;
                dArray[n2] = dArray[n2] / a.matrix[j][j];
            }
            for (i = j + 1; i < n; ++i) {
                for (k = j + 1; k < n; ++k) {
                    double[] dArray = a.matrix[i];
                    int n3 = k;
                    dArray[n3] = dArray[n3] - a.matrix[i][j] * a.matrix[j][k];
                }
                b.set(i, (Double)b.get(i) - a.matrix[i][j] * (Double)b.get(j));
                a.matrix[i][j] = 0.0;
            }
        }
        ArrayList<Double> result = new ArrayList<Double>(n);
        result.set(n - 1, (Double)b.get(n - 1) / a.matrix[n - 1][n - 1]);
        for (j = n - 2; j >= 0; --j) {
            result.set(j, (Double)b.get(j));
            for (k = n - 1; k > j; --k) {
                result.set(j, (Double)result.get(j) - (Double)result.get(k) * a.matrix[j][k]);
            }
            result.set(j, (Double)result.get(j) / a.matrix[j][k]);
        }
        return result;
    }

    public static EBIMatrix random(int m, int n) {
        EBIMatrix A = new EBIMatrix(m, n);
        double[][] X = A.getArray();
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                X[i][j] = Math.random();
            }
        }
        return A;
    }

    public static EBIMatrix identity(int m, int n) {
        EBIMatrix A = new EBIMatrix(m, n);
        double[][] X = A.getArray();
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                X[i][j] = i == j ? 1.0 : 0.0;
            }
        }
        return A;
    }

    public static EBIMatrix read(BufferedReader input) throws IOException {
        int j;
        StreamTokenizer tokenizer = new StreamTokenizer(input);
        tokenizer.resetSyntax();
        tokenizer.wordChars(0, 255);
        tokenizer.whitespaceChars(0, 32);
        tokenizer.eolIsSignificant(true);
        ArrayList<Object> v = new ArrayList<Object>();
        while (tokenizer.nextToken() == 10) {
        }
        if (tokenizer.ttype == -1) {
            throw new IOException("Unexpected EOF on matrix read.");
        }
        do {
            v.add(Double.valueOf(tokenizer.sval));
        } while (tokenizer.nextToken() == -3);
        int n = v.size();
        double[] row = new double[n];
        for (j = 0; j < n; ++j) {
            row[j] = ((Number)v.get(j)).doubleValue();
        }
        v.removeAll(v);
        v.add(row);
        while (tokenizer.nextToken() == -3) {
            row = new double[n];
            v.add(row);
            j = 0;
            do {
                if (j >= n) {
                    throw new IOException("Row " + v.size() + " is too long.");
                }
                Double.valueOf(tokenizer.sval);
            } while (tokenizer.nextToken() == -3);
            if (j >= n) continue;
            throw new IOException("Row " + v.size() + " is too short.");
        }
        int m = v.size();
        double[][] A = new double[m][];
        for (int i = 0; i < v.size(); ++i) {
            A[i] = (double[])v.get(i);
        }
        return new EBIMatrix(A);
    }

    public static EBIMatrix constructWithCopy(double[][] A) {
        int m = A.length;
        int n = A[0].length;
        EBIMatrix X = new EBIMatrix(m, n);
        double[][] C2 = X.getArray();
        for (int i = 0; i < m; ++i) {
            if (A[i].length != n) {
                throw new IllegalArgumentException("All rows must have the same length.");
            }
            System.arraycopy(A[i], 0, C2[i], 0, n);
        }
        return X;
    }

    public EBIMatrix(int rows, int columns) {
        this.rows = rows;
        this.columns = columns;
        this.matrix = new double[rows][columns];
    }

    public EBIMatrix(double[][] A) {
        int i;
        this.rows = A.length;
        this.columns = A[0].length;
        for (i = 0; i < this.rows; ++i) {
            if (A[i].length == this.columns) continue;
            throw new IllegalArgumentException("All rows must have the same length.");
        }
        this.matrix = new double[this.rows][this.columns];
        for (i = 0; i < this.rows; ++i) {
            System.arraycopy(A[i], 0, this.matrix[i], 0, this.columns);
        }
    }

    public EBIMatrix(double[][] A, int m, int n) {
        this.matrix = A;
        this.rows = m;
        this.columns = n;
    }

    public EBIMatrix(int m, int n, double s) {
        this.rows = m;
        this.columns = n;
        this.matrix = new double[m][n];
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                this.matrix[i][j] = s;
            }
        }
    }

    public EBIMatrix(double[] vals, int m) {
        this.rows = m;
        int n = this.columns = m != 0 ? vals.length / m : 0;
        if (m * this.columns != vals.length) {
            throw new IllegalArgumentException("Array length must be a multiple of m.");
        }
        this.matrix = new double[m][this.columns];
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                this.matrix[i][j] = vals[i + j * m];
            }
        }
    }

    public synchronized void initMatrix(double v) {
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                this.matrix[i][j] = v;
            }
        }
    }

    public synchronized double getValue(int i, int j) {
        double val = -1.0;
        if (i <= this.rows && j <= this.columns) {
            val = this.matrix[i][j];
        } else {
            LOGGER.debug("Error: Array of out bound");
        }
        return val;
    }

    public synchronized EBIMatrix duplicate() {
        EBIMatrix result = new EBIMatrix(this.rows, this.columns);
        double[][] data = result.getArray();
        for (int i = 0; i < this.rows; ++i) {
            System.arraycopy(this.matrix[i], 0, data[i], 0, this.columns);
        }
        return result;
    }

    public synchronized Object clone() throws CloneNotSupportedException {
        return this.duplicate();
    }

    public synchronized double[][] getArrayCopy() {
        double[][] C2 = new double[this.rows][this.columns];
        for (int i = 0; i < this.rows; ++i) {
            System.arraycopy(this.matrix[i], 0, C2[i], 0, this.columns);
        }
        return C2;
    }

    public synchronized double[] getColumnPackedCopy() {
        double[] vals = new double[this.rows * this.columns];
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                vals[i + j * this.rows] = this.matrix[i][j];
            }
        }
        return vals;
    }

    public synchronized double[] getRowPackedCopy() {
        double[] vals = new double[this.rows * this.columns];
        for (int i = 0; i < this.rows; ++i) {
            System.arraycopy(this.matrix[i], 0, vals, i * this.columns, this.columns);
        }
        return vals;
    }

    public synchronized double[][] getArray() {
        return this.matrix;
    }

    public synchronized EBIMatrix getMatrix(int rowStart, int rowEnd, int colStart, int colEnd) {
        EBIMatrix X = new EBIMatrix(rowEnd - rowStart + 1, colEnd - colStart + 1);
        double[][] B = X.getArray();
        try {
            for (int i = rowStart; i <= rowEnd; ++i) {
                for (int j = colStart; j <= colEnd; ++j) {
                    B[i - rowStart][j - colStart] = this.matrix[i][j];
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
        return X;
    }

    public synchronized EBIMatrix transpose() {
        EBIMatrix X = new EBIMatrix(this.columns, this.rows);
        double[][] C2 = X.getArray();
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                C2[j][i] = this.matrix[i][j];
            }
        }
        return X;
    }

    public synchronized boolean setValue(int row, int col, double value) {
        double val = value;
        boolean flag = false;
        if (row <= this.rows && col <= this.columns) {
            flag = true;
            this.matrix[row][col] = val;
        } else {
            try {
                throw new CDKException("Array out of Bound");
            }
            catch (CDKException ex) {
                LOGGER.error(Level.SEVERE, null, ex);
            }
        }
        return flag;
    }

    public synchronized int getRowDimension() {
        return this.rows;
    }

    public synchronized int getColumnDimension() {
        return this.columns;
    }

    public synchronized List<Double> getDiagonalElements() {
        ArrayList<Double> val = new ArrayList<Double>();
        if (this.rows == this.columns) {
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.columns; ++j) {
                    if (i != j) continue;
                    val.add(this.matrix[i][j]);
                }
            }
        } else {
            System.out.println("Row =/= Columns");
        }
        return val;
    }

    public synchronized EBIMatrix getMatrix(int[] r, int[] c) {
        EBIMatrix X = new EBIMatrix(r.length, c.length);
        double[][] B = X.getArray();
        try {
            for (int i = 0; i < r.length; ++i) {
                for (int j = 0; j < c.length; ++j) {
                    B[i][j] = this.matrix[r[i]][c[j]];
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
        return X;
    }

    public synchronized EBIMatrix getMatrix(int rowStart, int rowEnd, int[] c) {
        EBIMatrix X = new EBIMatrix(rowEnd - rowStart + 1, c.length);
        double[][] B = X.getArray();
        try {
            for (int i = rowStart; i <= rowEnd; ++i) {
                for (int j = 0; j < c.length; ++j) {
                    B[i - rowStart][j] = this.matrix[i][c[j]];
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
        return X;
    }

    public synchronized EBIMatrix getMatrix(int[] r, int colStart, int colEnd) {
        EBIMatrix X = new EBIMatrix(r.length, colEnd - colStart + 1);
        double[][] B = X.getArray();
        try {
            for (int i = 0; i < r.length; ++i) {
                for (int j = colStart; j <= colEnd; ++j) {
                    B[i][j - colStart] = this.matrix[r[i]][j];
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
        return X;
    }

    public synchronized void set(int i, int j, double s) {
        this.matrix[i][j] = s;
    }

    public synchronized void setMatrix(int rowStart, int rowEnd, int colStart, int colEnd, EBIMatrix X) {
        try {
            for (int i = rowStart; i <= rowEnd; ++i) {
                for (int j = colStart; j <= colEnd; ++j) {
                    this.matrix[i][j] = X.getValue(i - rowStart, j - colStart);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
    }

    public synchronized void setMatrix(int[] r, int[] c, EBIMatrix X) {
        try {
            for (int i = 0; i < r.length; ++i) {
                for (int j = 0; j < c.length; ++j) {
                    this.matrix[r[i]][c[j]] = X.getValue(i, j);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices" + e);
        }
    }

    public synchronized void setMatrix(int[] r, int colStart, int colEnd, EBIMatrix X) {
        try {
            for (int i = 0; i < r.length; ++i) {
                for (int j = colStart; j <= colEnd; ++j) {
                    this.matrix[r[i]][j] = X.getValue(i, j - colStart);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
    }

    public synchronized void setMatrix(int rowStart, int rowEnd, int[] c, EBIMatrix X) {
        try {
            for (int i = rowStart; i <= rowEnd; ++i) {
                for (int j = 0; j < c.length; ++j) {
                    this.matrix[i][c[j]] = X.getValue(i - rowStart, j);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
    }

    public synchronized boolean is_element_max_in_column(int iPos, int jPos) {
        boolean flag = true;
        double refValue = this.matrix[iPos][jPos];
        for (int j = 0; j < this.columns; ++j) {
            double searchValue;
            if (j == jPos || !((searchValue = this.matrix[iPos][j]) > refValue)) continue;
            flag = false;
        }
        return flag;
    }

    public synchronized boolean is_element_min_in_column(int iPos, int jPos) {
        boolean flag = true;
        double refValue = this.matrix[iPos][jPos];
        for (int j = 0; j < this.columns; ++j) {
            double searchValue;
            if (j == jPos || !((searchValue = this.matrix[iPos][j]) < refValue)) continue;
            flag = false;
        }
        return flag;
    }

    public synchronized void reSizeMatrix(int RowSize, int ColSize) {
        this.rows = RowSize;
        this.columns = ColSize;
        this.matrix = new double[this.rows][this.columns];
    }

    public synchronized boolean is_element_max_in_row(int iPos, int jPos) {
        boolean flag = true;
        double refValue = this.matrix[iPos][jPos];
        for (int i = 0; i < this.rows; ++i) {
            double searchValue;
            if (i == iPos || !((searchValue = this.matrix[i][jPos]) > refValue)) continue;
            flag = false;
        }
        return flag;
    }

    public synchronized boolean is_element_min_in_row(int iPos, int jPos) {
        boolean flag = true;
        double refValue = this.matrix[iPos][jPos];
        for (int i = 0; i < this.rows; ++i) {
            double searchValue;
            if (i == iPos || !((searchValue = this.matrix[i][jPos]) < refValue)) continue;
            flag = false;
        }
        return flag;
    }

    public synchronized void swapColumns(int coloumn1, int coloumn2) {
        if (coloumn1 <= this.getColumnDimension() && coloumn2 <= this.getColumnDimension()) {
            for (int i = 0; i < this.rows; ++i) {
                double tempValue = this.matrix[i][coloumn1];
                this.matrix[i][coloumn1] = this.matrix[i][coloumn2];
                this.matrix[i][coloumn2] = tempValue;
                tempValue = 0.0;
            }
        } else {
            try {
                throw new CDKException("Index out of range" + coloumn1 + ", " + coloumn2);
            }
            catch (CDKException ex) {
                LOGGER.error(ex);
            }
        }
    }

    public synchronized void swapRows(int row1, int row2) throws CDKException {
        if (row1 <= this.getRowDimension() && row2 <= this.getRowDimension()) {
            for (int i = 0; i < this.columns; ++i) {
                double tempValue = this.matrix[row1][i];
                this.matrix[row1][i] = this.matrix[row2][i];
                this.matrix[row2][i] = tempValue;
            }
        } else {
            throw new CDKException("Index out of range" + row1 + ", " + row2);
        }
    }

    public synchronized void pivot(int row, int col) {
        double tempValue;
        int i;
        for (i = 0; i < this.rows; ++i) {
            tempValue = this.matrix[i][row];
            this.matrix[i][row] = this.matrix[i][col];
            this.matrix[i][col] = tempValue;
        }
        for (i = 0; i < this.columns; ++i) {
            tempValue = this.matrix[row][i];
            this.matrix[row][i] = this.matrix[col][i];
            this.matrix[col][i] = tempValue;
        }
    }

    public synchronized EBIMatrix normalize(EBIMatrix S) {
        EBIMatrix result = this.duplicate();
        for (int p = 0; p < this.columns; ++p) {
            double length = 0.0;
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    length += result.matrix[i][p] * result.matrix[j][p] * S.matrix[i][j];
                }
            }
            if ((length = Math.sqrt(length)) != 0.0) {
                for (int q = 0; q < this.rows; ++q) {
                    double[] dArray = result.matrix[q];
                    int n = p;
                    dArray[n] = dArray[n] / length;
                }
                continue;
            }
            System.out.println("Warning(orthonormalize):" + (p + 1) + ". Vector has length null");
        }
        return result;
    }

    public synchronized EBIMatrix mul(double a) {
        EBIMatrix result = new EBIMatrix(this.rows, this.columns);
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                result.matrix[i][j] = this.matrix[i][j] * a;
            }
        }
        return result;
    }

    public synchronized List<Double> mul(List<Double> a) {
        if (a == null || this.columns != a.size()) {
            return null;
        }
        ArrayList<Double> result = new ArrayList<Double>(this.rows);
        for (int i = 0; i < this.rows; ++i) {
            double sum = 0.0;
            for (int j = 0; j < this.columns; ++j) {
                sum += this.matrix[i][j] * a.get(j);
            }
            result.add(i, sum);
        }
        return result;
    }

    public synchronized EBIMatrix mul(EBIMatrix b) {
        if (b == null || this.columns != b.getRowDimension()) {
            return null;
        }
        EBIMatrix result = new EBIMatrix(this.rows, b.getColumnDimension());
        for (int i = 0; i < this.rows; ++i) {
            for (int k = 0; k < b.getColumnDimension(); ++k) {
                double sum = 0.0;
                for (int j = 0; j < this.columns; ++j) {
                    sum += this.matrix[i][j] * b.matrix[j][k];
                }
                result.matrix[i][k] = sum;
            }
        }
        return result;
    }

    private synchronized void checkMatrixDimensions(EBIMatrix B) {
        if (B.getRowDimension() != this.rows || B.getColumnDimension() != this.columns) {
            throw new IllegalArgumentException("EBIMatrix dimensions must agree.");
        }
    }

    public synchronized EBIMatrix arrayTimes(EBIMatrix B) {
        this.checkMatrixDimensions(B);
        EBIMatrix X = new EBIMatrix(this.rows, this.columns);
        double[][] C2 = X.getArray();
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                C2[i][j] = this.matrix[i][j] * B.matrix[i][j];
            }
        }
        return X;
    }

    public synchronized EBIMatrix arrayTimesEquals(EBIMatrix B) {
        this.checkMatrixDimensions(B);
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                double[] dArray = this.matrix[i];
                int n = j;
                dArray[n] = dArray[n] * B.matrix[i][j];
            }
        }
        return this;
    }

    public synchronized EBIMatrix arrayRightDivide(EBIMatrix B) {
        this.checkMatrixDimensions(B);
        EBIMatrix X = new EBIMatrix(this.rows, this.columns);
        double[][] C2 = X.getArray();
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                C2[i][j] = this.matrix[i][j] / B.matrix[i][j];
            }
        }
        return X;
    }

    public synchronized EBIMatrix arrayRightDivideEquals(EBIMatrix B) {
        this.checkMatrixDimensions(B);
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                double[] dArray = this.matrix[i];
                int n = j;
                dArray[n] = dArray[n] / B.matrix[i][j];
            }
        }
        return this;
    }

    public synchronized EBIMatrix arrayLeftDivide(EBIMatrix B) {
        this.checkMatrixDimensions(B);
        EBIMatrix X = new EBIMatrix(this.rows, this.columns);
        double[][] C2 = X.getArray();
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                C2[i][j] = B.matrix[i][j] / this.matrix[i][j];
            }
        }
        return X;
    }

    public synchronized EBIMatrix arrayLeftDivideEquals(EBIMatrix B) {
        this.checkMatrixDimensions(B);
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                this.matrix[i][j] = B.matrix[i][j] / this.matrix[i][j];
            }
        }
        return this;
    }

    public synchronized EBIMatrix times(double s) {
        EBIMatrix X = new EBIMatrix(this.rows, this.columns);
        double[][] C2 = X.getArray();
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                C2[i][j] = s * this.matrix[i][j];
            }
        }
        return X;
    }

    public synchronized EBIMatrix timesEquals(double s) {
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                this.matrix[i][j] = s * this.matrix[i][j];
            }
        }
        return this;
    }

    public synchronized EBIMatrix times(EBIMatrix B) {
        if (B.getRowDimension() != this.columns) {
            throw new IllegalArgumentException("EBIMatrix inner dimensions must agree.");
        }
        EBIMatrix X = new EBIMatrix(this.rows, B.getColumnDimension());
        double[][] C2 = X.getArray();
        double[] Bcolj = new double[this.columns];
        for (int j = 0; j < B.getColumnDimension(); ++j) {
            for (int k = 0; k < this.columns; ++k) {
                Bcolj[k] = B.matrix[k][j];
            }
            for (int i = 0; i < this.rows; ++i) {
                double[] Arowi = this.matrix[i];
                double s = 0.0;
                for (int k = 0; k < this.columns; ++k) {
                    s += Arowi[k] * Bcolj[k];
                }
                C2[i][j] = s;
            }
        }
        return X;
    }

    public synchronized LUDecomposition lu() {
        return new LUDecomposition(this);
    }

    public synchronized QRDecomposition qr() {
        return new QRDecomposition(this);
    }

    public synchronized CholeskyDecomposition chol() {
        return new CholeskyDecomposition(this);
    }

    public synchronized SingularValueDecomposition svd() {
        return new SingularValueDecomposition(this);
    }

    public synchronized EigenvalueDecomposition eig() {
        return new EigenvalueDecomposition(this);
    }

    public synchronized EBIMatrix solve(EBIMatrix B) {
        return this.rows == this.columns ? new LUDecomposition(this).solve(B) : new QRDecomposition(this).solve(B);
    }

    public synchronized EBIMatrix solveTranspose(EBIMatrix B) {
        return this.transpose().solve(B.transpose());
    }

    public synchronized EBIMatrix inverse() {
        return this.solve(EBIMatrix.identity(this.rows, this.rows));
    }

    public synchronized double det() {
        return new LUDecomposition(this).det();
    }

    public synchronized int rank() {
        return new SingularValueDecomposition(this).rank();
    }

    public synchronized double cond() {
        return new SingularValueDecomposition(this).cond();
    }

    public synchronized double trace() {
        double t = 0.0;
        for (int i = 0; i < Math.min(this.rows, this.columns); ++i) {
            t += this.matrix[i][i];
        }
        return t;
    }

    public synchronized EBIMatrix diagonalize(int nrot) {
        int iq;
        int ip;
        EBIMatrix m = this.duplicate();
        if (m.getRowDimension() != m.getColumnDimension()) {
            LOGGER.debug("EBIMatrix.diagonal: Sizes mismatched");
            return null;
        }
        int n = m.getRowDimension();
        EBIMatrix v = new EBIMatrix(this.columns, this.columns);
        ArrayList<Double> d = new ArrayList<Double>(this.columns);
        double[] b = new double[n + 1];
        double[] z = new double[n + 1];
        for (ip = 0; ip < n; ++ip) {
            for (iq = 0; iq < n; ++iq) {
                v.matrix[ip][iq] = 0.0;
            }
            v.matrix[ip][ip] = 1.0;
        }
        for (ip = 0; ip < n; ++ip) {
            d.add(ip, m.matrix[ip][ip]);
            b[ip] = m.matrix[ip][ip];
            z[ip] = 0.0;
        }
        nrot = 0;
        for (int i = 1; i <= 50; ++i) {
            double sm = 0.0;
            for (ip = 0; ip < n - 1; ++ip) {
                for (iq = ip + 1; iq < n; ++iq) {
                    sm += Math.abs(m.matrix[ip][iq]);
                }
            }
            if (sm == 0.0) {
                return v;
            }
            double tresh = i < 4 ? 0.2 * sm / (double)(n * n) : 0.0;
            for (ip = 0; ip < n - 1; ++ip) {
                for (iq = ip + 1; iq < n; ++iq) {
                    int j;
                    double t;
                    double g = 100.0 * Math.abs(m.matrix[ip][iq]);
                    if (i > 4 && Math.abs((Double)d.get(ip) + g) == Math.abs((Double)d.get(ip)) && Math.abs((Double)d.get(ip) + g) == Math.abs((Double)d.get(ip))) {
                        m.matrix[ip][iq] = 0.0;
                        continue;
                    }
                    if (!(Math.abs(m.matrix[ip][iq]) > tresh)) continue;
                    double h = (Double)d.get(iq) - (Double)d.get(ip);
                    if (Math.abs(h) + g == Math.abs(h)) {
                        t = m.matrix[ip][iq] / h;
                    } else {
                        double theta = 0.5 * h / m.matrix[ip][iq];
                        t = 1.0 / (Math.abs(theta) + Math.sqrt(1.0 + theta * theta));
                        if (theta < 0.0) {
                            t = -t;
                        }
                    }
                    double c = 1.0 / Math.sqrt(1.0 + t * t);
                    double s = t * c;
                    double tau = s / (1.0 + c);
                    h = t * m.matrix[ip][iq];
                    int n2 = ip;
                    z[n2] = z[n2] - h;
                    int n3 = iq;
                    z[n3] = z[n3] + h;
                    d.set(ip, (Double)d.get(ip) - h);
                    d.set(iq, (Double)d.get(iq) + h);
                    m.matrix[ip][iq] = 0.0;
                    for (j = 0; j < ip; ++j) {
                        g = m.matrix[j][ip];
                        h = m.matrix[j][iq];
                        m.matrix[j][ip] = g - s * (h + g * tau);
                        m.matrix[j][iq] = h + s * (g - h * tau);
                    }
                    for (j = ip + 1; j < iq; ++j) {
                        g = m.matrix[ip][j];
                        h = m.matrix[j][iq];
                        m.matrix[ip][j] = g - s * (h + g * tau);
                        m.matrix[j][iq] = h + s * (g - h * tau);
                    }
                    for (j = iq + 1; j < n; ++j) {
                        g = m.matrix[ip][j];
                        h = m.matrix[iq][j];
                        m.matrix[ip][j] = g - s * (h + g * tau);
                        m.matrix[iq][j] = h + s * (g - h * tau);
                    }
                    for (j = 0; j < n; ++j) {
                        g = v.matrix[j][ip];
                        h = v.matrix[j][iq];
                        v.matrix[j][ip] = g - s * (h + g * tau);
                        v.matrix[j][iq] = h + s * (g - h * tau);
                    }
                    ++nrot;
                }
            }
            for (ip = 0; ip < n; ++ip) {
                int n4 = ip;
                b[n4] = b[n4] + z[ip];
                d.set(ip, b[ip]);
                z[ip] = 0.0;
            }
        }
        System.out.println("Too many iterations in routine JACOBI");
        return v;
    }

    public synchronized EBIMatrix orthonormalize(EBIMatrix S) {
        EBIMatrix result = this.duplicate();
        for (int p = 0; p < this.columns; ++p) {
            int q;
            int j;
            double length;
            int i;
            for (i = 0; i < this.rows; ++i) {
                result.matrix[i][p] = this.matrix[i][p];
            }
            for (int k = 0; k < p; ++k) {
                length = 0.0;
                for (i = 0; i < this.rows; ++i) {
                    double innersum = 0.0;
                    for (j = 0; j < this.rows; ++j) {
                        innersum += result.matrix[j][p] * S.matrix[i][j];
                    }
                    length += result.matrix[i][k] * innersum;
                }
                for (q = 0; q < this.rows; ++q) {
                    double[] dArray = result.matrix[q];
                    int n = p;
                    dArray[n] = dArray[n] - result.matrix[q][k] * length;
                }
            }
            length = 0.0;
            for (i = 0; i < this.rows; ++i) {
                for (j = 0; j < this.rows; ++j) {
                    length += result.matrix[i][p] * result.matrix[j][p] * S.matrix[i][j];
                }
            }
            if ((length = Math.sqrt(length)) != 0.0) {
                for (q = 0; q < this.rows; ++q) {
                    double[] dArray = result.matrix[q];
                    int n = p;
                    dArray[n] = dArray[n] / length;
                }
                continue;
            }
            System.out.println("Warning(orthonormalize):" + (p + 1) + ". Vector has length null");
        }
        return result;
    }

    public synchronized void print(NumberFormat format, int width) {
        this.print(new PrintWriter(System.out, true), format, width);
    }

    public synchronized void print(int w, int d) {
        this.print(new PrintWriter(System.out, true), w, d);
    }

    public synchronized void print(PrintWriter output, int w, int d) {
        DecimalFormat format = new DecimalFormat();
        format.setDecimalFormatSymbols(new DecimalFormatSymbols(Locale.US));
        format.setMinimumIntegerDigits(1);
        format.setMaximumFractionDigits(d);
        format.setMinimumFractionDigits(d);
        format.setGroupingUsed(false);
        this.print(output, format, w + 2);
    }

    public synchronized void print(PrintWriter output, NumberFormat format, int width) {
        output.println();
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                String s = format.format(this.matrix[i][j]);
                int padding = Math.max(1, width - s.length());
                for (int k = 0; k < padding; ++k) {
                    output.print(' ');
                }
                output.print(s);
            }
            output.println();
        }
        output.println();
    }

    public synchronized String toString() {
        int j;
        if (this.rows <= 0 || this.columns <= 0) {
            return "[]";
        }
        DecimalFormat format = new DecimalFormat("00.0000");
        format.setPositivePrefix("+");
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < this.rows - 1; ++i) {
            for (j = 0; j < this.columns - 1; ++j) {
                if (Math.round(this.matrix[i][j] * 10000.0) != 0L) {
                    str.append(format.format(this.matrix[i][j])).append(" ");
                    continue;
                }
                str.append("-------- ");
            }
            if (Math.round(this.matrix[i][this.columns - 1] * 10000.0) != 0L) {
                str.append(format.format(this.matrix[i][this.columns - 1])).append(NEW_LINE);
                continue;
            }
            str.append("--------").append(NEW_LINE);
        }
        for (j = 0; j < this.columns - 1; ++j) {
            if (Math.round(this.matrix[this.rows - 1][j] * 10000.0) != 0L) {
                str.append(format.format(this.matrix[this.rows - 1][j])).append(" ");
                continue;
            }
            str.append("-------- ");
        }
        if (Math.round(this.matrix[this.rows - 1][this.columns - 1] * 10000.0) != 0L) {
            str.append(format.format(this.matrix[this.rows - 1][this.columns - 1]));
        } else {
            str.append("-------- ");
        }
        return str.toString();
    }

    public double contraction() {
        double result = 0.0;
        for (int i = 0; i < this.getRowDimension(); ++i) {
            for (int j = 0; j < this.getColumnDimension(); ++j) {
                result += this.matrix[i][j];
            }
        }
        return result;
    }

    public EBIMatrix similar(EBIMatrix U) {
        EBIMatrix result = new EBIMatrix(U.getColumnDimension(), U.getColumnDimension());
        for (int i = 0; i < U.getColumnDimension(); ++i) {
            for (int j = 0; j < U.getColumnDimension(); ++j) {
                double sum = 0.0;
                for (int k = 0; k < U.getColumnDimension(); ++k) {
                    double innersum = 0.0;
                    for (int l = 0; l < U.getColumnDimension(); ++l) {
                        innersum += this.matrix[k][l] * U.matrix[l][j];
                    }
                    sum += U.matrix[k][i] * innersum;
                }
                result.matrix[i][j] = sum;
            }
        }
        return result;
    }

    public synchronized double norm1() {
        double f = 0.0;
        for (int j = 0; j < this.columns; ++j) {
            double s = 0.0;
            for (int i = 0; i < this.rows; ++i) {
                s += Math.abs(this.matrix[i][j]);
            }
            f = Math.max(f, s);
        }
        return f;
    }

    public synchronized double norm2() {
        return new SingularValueDecomposition(this).norm2();
    }

    public synchronized double normInf() {
        double f = 0.0;
        for (int i = 0; i < this.rows; ++i) {
            double s = 0.0;
            for (int j = 0; j < this.columns; ++j) {
                s += Math.abs(this.matrix[i][j]);
            }
            f = Math.max(f, s);
        }
        return f;
    }

    public synchronized double normF() {
        double f = 0.0;
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                f = Maths.hypot(f, this.matrix[i][j]);
            }
        }
        return f;
    }

    public synchronized EBIMatrix uminus() {
        EBIMatrix X = new EBIMatrix(this.rows, this.columns);
        double[][] C2 = X.getArray();
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                C2[i][j] = -this.matrix[i][j];
            }
        }
        return X;
    }

    public synchronized EBIMatrix plus(EBIMatrix B) {
        this.checkMatrixDimensions(B);
        EBIMatrix X = new EBIMatrix(this.rows, this.columns);
        double[][] C2 = X.getArray();
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                C2[i][j] = this.matrix[i][j] + B.matrix[i][j];
            }
        }
        return X;
    }

    public synchronized EBIMatrix plusEquals(EBIMatrix B) {
        this.checkMatrixDimensions(B);
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                double[] dArray = this.matrix[i];
                int n = j;
                dArray[n] = dArray[n] + B.matrix[i][j];
            }
        }
        return this;
    }

    public synchronized EBIMatrix minus(EBIMatrix B) {
        this.checkMatrixDimensions(B);
        EBIMatrix X = new EBIMatrix(this.rows, this.columns);
        double[][] C2 = X.getArray();
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                C2[i][j] = this.matrix[i][j] - B.matrix[i][j];
            }
        }
        return X;
    }

    public synchronized EBIMatrix minusEquals(EBIMatrix B) {
        this.checkMatrixDimensions(B);
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                double[] dArray = this.matrix[i];
                int n = j;
                dArray[n] = dArray[n] - B.matrix[i][j];
            }
        }
        return this;
    }
}

