/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.tools;

import java.util.ArrayList;
import org.openscience.cdk.graph.PathTools;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IElectronContainer;

public class EBIMolSplitter {
    public static boolean isConnected(IAtomContainer atomContainer) {
        boolean flag = false;
        IAtomContainer ac = atomContainer.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        IAtom atom = null;
        IAtomContainer molecule = atomContainer.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        ArrayList<IAtom> sphere = new ArrayList<IAtom>();
        for (int f = 0; f < atomContainer.getAtomCount(); ++f) {
            atom = atomContainer.getAtom(f);
            atom.setFlag(16, false);
            ac.addAtom(atomContainer.getAtom(f));
        }
        for (IBond bond : atomContainer.bonds()) {
            bond.setFlag(16, false);
            ac.addBond(bond);
        }
        atom = ac.getAtom(0);
        sphere.add(atom);
        atom.setFlag(16, true);
        PathTools.breadthFirstSearch(ac, sphere, molecule);
        if (molecule.getAtomCount() == atomContainer.getAtomCount()) {
            flag = true;
        }
        return flag;
    }

    public static IAtomContainerSet splitMolecules(IAtomContainer atomContainer) {
        IAtom atom;
        IAtomContainer ac = atomContainer.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        IAtomContainerSet molecules = atomContainer.getBuilder().newInstance(IAtomContainerSet.class, new Object[0]);
        ArrayList<IAtom> sphere = new ArrayList<IAtom>();
        for (int f = 0; f < atomContainer.getAtomCount(); ++f) {
            atom = atomContainer.getAtom(f);
            atom.setFlag(16, false);
            ac.addAtom(atom);
        }
        for (IElectronContainer eContainer : atomContainer.electronContainers()) {
            eContainer.setFlag(16, false);
            ac.addElectronContainer(eContainer);
        }
        while (ac.getAtomCount() > 0) {
            atom = ac.getAtom(0);
            IAtomContainer molecule = atomContainer.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
            sphere.clear();
            sphere.add(atom);
            atom.setFlag(16, true);
            PathTools.breadthFirstSearch(ac, sphere, molecule);
            molecules.addAtomContainer(molecule);
            ac.remove(molecule);
        }
        return molecules;
    }

    private EBIMolSplitter() {
    }
}

