/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.tools;

import java.util.HashMap;
import org.openscience.cdk.AtomContainer;
import org.openscience.cdk.Mapping;
import org.openscience.cdk.Reaction;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IMapping;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.tools.manipulator.ReactionManipulator;
import org.openscience.smsd.tools.ExtAtomContainerManipulator;

public class ExtReactionManipulatorTool
extends ReactionManipulator {
    public static synchronized IReaction deepClone(IReaction reaction) throws CloneNotSupportedException {
        int j;
        IAtomContainer mol;
        int i;
        int i2;
        IAtomContainer acClone;
        Reaction clone = new Reaction();
        for (IAtomContainer ac : reaction.getReactants().atomContainers()) {
            acClone = new AtomContainer(ac).clone();
            for (i2 = 0; i2 < ac.getAtomCount(); ++i2) {
                acClone.getAtom(i2).setID(ac.getAtom(i2).getID());
            }
            acClone.setID(ac.getID());
            acClone.addProperties(ac.getProperties());
            clone.getReactants().addAtomContainer(acClone);
        }
        for (IAtomContainer ac : reaction.getProducts().atomContainers()) {
            acClone = new AtomContainer(ac).clone();
            for (i2 = 0; i2 < ac.getAtomCount(); ++i2) {
                acClone.getAtom(i2).setID(ac.getAtom(i2).getID());
            }
            acClone.setID(ac.getID());
            acClone.addProperties(ac.getProperties());
            clone.getProducts().addAtomContainer(acClone);
        }
        for (IAtomContainer ac : reaction.getAgents().atomContainers()) {
            acClone = new AtomContainer(ac).clone();
            acClone.setID(ac.getID());
            acClone.addProperties(ac.getProperties());
            clone.getAgents().addAtomContainer(acClone);
        }
        HashMap<IAtom, IAtom> atomatom = new HashMap<IAtom, IAtom>();
        for (i = 0; i < reaction.getReactants().getAtomContainerCount(); ++i) {
            mol = reaction.getReactants().getAtomContainer(i);
            IAtomContainer mol2 = clone.getReactants().getAtomContainer(i);
            for (j = 0; j < mol.getAtomCount(); ++j) {
                atomatom.put(mol.getAtom(j), mol2.getAtom(j));
            }
        }
        for (i = 0; i < reaction.getProducts().getAtomContainerCount(); ++i) {
            mol = reaction.getProducts().getAtomContainer(i);
            IAtomContainer mol2 = clone.getProducts().getAtomContainer(i);
            for (j = 0; j < mol.getAtomCount(); ++j) {
                atomatom.put(mol.getAtom(j), mol2.getAtom(j));
            }
        }
        for (IMapping mapping : reaction.mappings()) {
            clone.addMapping(new Mapping((IChemObject)atomatom.get(mapping.getChemObject(0)), (IChemObject)atomatom.get(mapping.getChemObject(1))));
        }
        clone.setID(reaction.getID());
        return clone;
    }

    public static IReaction addExplicitH(IReaction reaction) throws CloneNotSupportedException {
        IAtomContainer addExplicitH;
        IReaction r = reaction.getBuilder().newInstance(IReaction.class, new Object[0]);
        for (IAtomContainer ac : reaction.getReactants().atomContainers()) {
            addExplicitH = ExtAtomContainerManipulator.addExplicitH(ac);
            r.addReactant(addExplicitH, reaction.getReactantCoefficient(ac));
        }
        for (IAtomContainer ac : reaction.getProducts().atomContainers()) {
            addExplicitH = ExtAtomContainerManipulator.addExplicitH(ac);
            r.addProduct(addExplicitH, reaction.getProductCoefficient(ac));
        }
        r.setDirection(reaction.getDirection());
        r.setID(reaction.getID() == null ? "" : reaction.getID());
        return r;
    }
}

