/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.tools;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.vecmath.Vector2d;
import org.openscience.cdk.AtomContainer;
import org.openscience.cdk.Reaction;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IMapping;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.silent.SilentChemObjectBuilder;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.ReactionManipulator;
import org.openscience.smsd.AtomAtomMapping;
import uk.ac.ebi.reactionblast.graphics.direct.DirectMoleculeDrawer;
import uk.ac.ebi.reactionblast.graphics.direct.DirectRBLastReactionDrawer;
import uk.ac.ebi.reactionblast.graphics.direct.OutlineHighlighter;
import uk.ac.ebi.reactionblast.graphics.direct.Params;
import uk.ac.ebi.reactionblast.graphics.direct.RootSystem;
import uk.ac.ebi.reactionblast.graphics.direct.SignatureRootFinder;
import uk.ac.ebi.reactionblast.graphics.direct.SimpleHighlighter;
import uk.ac.ebi.reactionblast.graphics.direct.awtlayout.AbstractAWTReactionLayout;
import uk.ac.ebi.reactionblast.graphics.direct.awtlayout.LeftToRightAWTReactionLayout;
import uk.ac.ebi.reactionblast.graphics.direct.awtlayout.TopToBottomAWTReactionLayout;
import uk.ac.ebi.reactionblast.graphics.direct.layout.AbstractDirectReactionLayout;
import uk.ac.ebi.reactionblast.graphics.direct.layout.BoundsTree;
import uk.ac.ebi.reactionblast.graphics.direct.layout.LeftToRightReactionLayout;
import uk.ac.ebi.reactionblast.graphics.direct.layout.SingleMoleculeLayout;
import uk.ac.ebi.reactionblast.graphics.direct.layout.TopToBottomReactionLayout;
import uk.ac.ebi.reactionblast.graphics.direct.layout.ZoomToFitGridLayout;
import uk.ac.ebi.reactionblast.graphics.direct.layout.ZoomToFitLayout;
import uk.ac.ebi.reactionblast.mapping.helper.RBlastReaction;
import uk.ac.ebi.reactionblast.signature.SignatureMatcher;
import uk.ac.ebi.reactionblast.tools.CreateDirectory;
import uk.ac.ebi.reactionblast.tools.LayoutCheck;

public class ImageGenerator {
    private static final ILoggingTool LOGGER = LoggingToolFactory.createLoggingTool(ImageGenerator.class);
    public static final int SUB_IMAGE_WIDTH = 300;
    public static final int SUB_IMAGE_HEIGHT = 300;
    private final List<QueryTargetPair> queryTargetPairs = new ArrayList<QueryTargetPair>();
    private final Params params = new Params();

    public static synchronized Image getBlankImage(int width, int height) {
        return new BufferedImage(width, height, 6);
    }

    protected static synchronized void makeReactionCenterHighlightedReactionToFile(IReaction reaction, AbstractDirectReactionLayout layout, AbstractAWTReactionLayout awtLayout, int width, int height, File outFile) throws IOException {
        Params params = new Params();
        params.leftToRightMoleculeLabelFontSize = 10;
        params.drawMappings = false;
        params.drawHighlights = true;
        params.highlightsAbove = true;
        params.drawAtomID = false;
        params.drawMoleculeID = false;
        params.drawLabelPanel = true;
        params.drawAromaticCircles = true;
        params.useCircularHighlight = false;
        params.drawSubgraphBoxes = false;
        params.drawBondStereoChanges = false;
        params.drawBondFormedCleavedMarks = true;
        params.drawBondOrderChangedMarks = true;
        params.arrowGap = 30;
        params.arrowLength = 60;
        params.drawFatArrow = true;
        params.drawArrowFilled = true;
        params.borderY = 40;
        params.drawRS = true;
        params.shouldCrop = true;
        RBlastReaction rblReaction = new RBlastReaction(reaction, true);
        Map<IAtomContainer, List<RootSystem>> rootSystems = SignatureRootFinder.findRootSystems(rblReaction);
        DirectRBLastReactionDrawer reactionDrawer = new DirectRBLastReactionDrawer(params, layout, awtLayout);
        Color rootColor = Color.RED;
        Color neighbourColor = Color.GREEN;
        DirectMoleculeDrawer moleculeDrawer = reactionDrawer.getReactionDrawer().getMoleculeDrawer();
        moleculeDrawer.getHighlighters().clear();
        for (IAtomContainer atomContainer : rootSystems.keySet()) {
            List<RootSystem> rootSystemList = rootSystems.get(atomContainer);
            for (RootSystem rootSystem : rootSystemList) {
                IAtomContainer rootContainer = reaction.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
                rootSystem.getRoots().stream().forEach(root -> rootContainer.addAtom((IAtom)root));
                IAtomContainer neighbourContainer = reaction.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
                rootSystem.getLeaves().stream().forEach(leaf -> neighbourContainer.addAtom((IAtom)leaf));
                SimpleHighlighter highlighter = new SimpleHighlighter(params);
                highlighter.addHighlights(rootContainer, rootColor);
                highlighter.addHighlights(neighbourContainer, neighbourColor);
                moleculeDrawer.addHighlighter(highlighter);
            }
        }
        BufferedImage image = (BufferedImage)ImageGenerator.getBlankImage(width, height);
        Graphics2D g = (Graphics2D)image.getGraphics();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, width, height);
        Rectangle2D finalBounds = reactionDrawer.drawRBlastReaction(rblReaction, width, height, g);
        if (params.shouldCrop && (finalBounds.getWidth() != (double)width || finalBounds.getHeight() != (double)height)) {
            image = image.getSubimage((int)finalBounds.getX(), (int)finalBounds.getY(), (int)finalBounds.getWidth(), (int)finalBounds.getHeight());
        }
        g.dispose();
        ImageIO.write((RenderedImage)image, "PNG", outFile);
    }

    protected static synchronized void makeLeftToRighHighlightedReactionToFile(IReaction reaction, AbstractDirectReactionLayout layout, AbstractAWTReactionLayout awtLayout, int width, int height, boolean shouldCrop, File outFile) throws IOException {
        RBlastReaction rblReaction = new RBlastReaction(reaction, true);
        DirectRBLastReactionDrawer drawer = new DirectRBLastReactionDrawer(new Params(), layout, awtLayout);
        drawer.getParams().drawMappings = false;
        drawer.getParams().drawAromaticCircles = false;
        drawer.getParams().drawAtomID = false;
        drawer.getParams().drawLonePairs = false;
        drawer.getParams().drawMoleculeID = true;
        drawer.getParams().drawSubgraphBoxes = false;
        drawer.getParams().highlightSubgraphs = true;
        drawer.getParams().drawSubgraphMappingLines = false;
        drawer.getParams().highlightsBelow = false;
        drawer.getParams().highlightsAbove = true;
        drawer.getParams().drawAromaticCircles = true;
        drawer.getParams().highlightAlpha = 0.25f;
        drawer.getParams().drawRS = true;
        drawer.getParams().labelYGap = 25.0;
        drawer.getParams().borderY = 40;
        drawer.getParams().borderX = 40;
        drawer.getParams().arrowGap = 30;
        drawer.getParams().arrowLength = 60;
        drawer.getParams().drawArrowFilled = true;
        drawer.getParams().drawFatArrow = true;
        drawer.getParams().shouldCrop = shouldCrop;
        drawer.getParams().leftToRightMoleculeLabelFontSize = 10;
        Image drawRBlastReaction = drawer.drawRBlastReaction(rblReaction, width, height);
        ImageIO.write((RenderedImage)((Object)drawRBlastReaction), "PNG", outFile);
    }

    protected static synchronized void makeLeftToRighHighlightedReactionToFile(IReaction cdkReaction, int width, int height, boolean shouldCrop, File outFile) throws IOException {
        RBlastReaction rbReaction = new RBlastReaction(cdkReaction, true);
        DirectRBLastReactionDrawer drawer = new DirectRBLastReactionDrawer(new Params(), new LeftToRightReactionLayout(), new LeftToRightAWTReactionLayout());
        drawer.getParams().drawMappings = false;
        drawer.getParams().drawAromaticCircles = false;
        drawer.getParams().drawAtomID = false;
        drawer.getParams().drawLonePairs = false;
        drawer.getParams().drawMoleculeID = true;
        drawer.getParams().drawSubgraphBoxes = false;
        drawer.getParams().highlightSubgraphs = true;
        drawer.getParams().drawSubgraphMappingLines = false;
        drawer.getParams().highlightsBelow = false;
        drawer.getParams().highlightsAbove = true;
        drawer.getParams().drawAromaticCircles = true;
        drawer.getParams().highlightAlpha = 0.25f;
        drawer.getParams().drawRS = true;
        drawer.getParams().labelYGap = 25.0;
        drawer.getParams().borderY = 40;
        drawer.getParams().arrowGap = 30;
        drawer.getParams().arrowLength = 60;
        drawer.getParams().drawFatArrow = true;
        drawer.getParams().shouldCrop = shouldCrop;
        drawer.getParams().leftToRightMoleculeLabelFontSize = 10;
        BufferedImage image = (BufferedImage)ImageGenerator.getBlankImage(width, height);
        Graphics2D g = (Graphics2D)image.getGraphics();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, width, height);
        Rectangle2D finalBounds = drawer.drawRBlastReaction(rbReaction, width, height, g);
        if (shouldCrop && (finalBounds.getWidth() != (double)width || finalBounds.getHeight() != (double)height)) {
            image = image.getSubimage((int)finalBounds.getX(), (int)finalBounds.getY(), (int)finalBounds.getWidth(), (int)finalBounds.getHeight());
        }
        g.dispose();
        ImageIO.write((RenderedImage)image, "PNG", outFile);
    }

    protected static synchronized void makeTopToBottomRHighlightedReactionToFile(IReaction cdkReaction, int width, int height, File outFile) throws IOException {
        RBlastReaction rbReaction = new RBlastReaction(cdkReaction, true);
        DirectRBLastReactionDrawer drawer = new DirectRBLastReactionDrawer(new Params(), new TopToBottomReactionLayout(), new TopToBottomAWTReactionLayout());
        drawer.getParams().drawMappings = false;
        drawer.getParams().drawAromaticCircles = false;
        drawer.getParams().drawAtomID = true;
        drawer.getParams().drawLonePairs = false;
        drawer.getParams().drawSubgraphBoxes = false;
        drawer.getParams().highlightSubgraphs = true;
        drawer.getParams().drawSubgraphMappingLines = false;
        drawer.getParams().highlightsBelow = false;
        drawer.getParams().highlightsAbove = true;
        drawer.getParams().drawAromaticCircles = true;
        drawer.getParams().highlightAlpha = 0.25f;
        drawer.getParams().drawRS = true;
        drawer.getParams().labelYGap = 25.0;
        drawer.getParams().borderY = 40;
        drawer.getParams().arrowGap = 30;
        drawer.getParams().arrowLength = 60;
        drawer.getParams().drawFatArrow = true;
        drawer.getParams().drawArrowFilled = true;
        drawer.getParams().drawLabelPanel = false;
        drawer.getParams().drawMoleculeID = true;
        drawer.getParams().topToBottomMoleculeLabelFontSize = 10;
        Image image = drawer.drawRBlastReaction(rbReaction, width, height);
        ImageIO.write((RenderedImage)((Object)image), "PNG", outFile);
    }

    public static synchronized void LeftToRightReactionLayoutImageSmall(IReaction cdkReaction, String rmrID, String outputDir) throws Exception {
        int width = 600;
        int height = 400;
        File outFile = new File(ImageGenerator.getDir(outputDir), rmrID + ".png");
        ImageGenerator.makeLeftToRighHighlightedReactionToFile(cdkReaction, width, height, true, outFile);
    }

    public static synchronized void LeftToRightReactionCenterImageSmall(IReaction cdkReaction, String rmrID, String outputDir) throws Exception {
        int width = 600;
        int height = 400;
        File outFile = new File(ImageGenerator.getDir(outputDir), rmrID + ".png");
        ImageGenerator.makeReactionCenterHighlightedReactionToFile(cdkReaction, new LeftToRightReactionLayout(), new LeftToRightAWTReactionLayout(), width, height, outFile);
    }

    public static synchronized void TopToBottomReactionLayoutImageSmall(IReaction cdkReaction, String rmrID, String outputDir) throws Exception {
        int height = 400;
        int width = 600;
        File outFile = new File(ImageGenerator.getDir(outputDir), rmrID + ".png");
        ImageGenerator.makeTopToBottomRHighlightedReactionToFile(cdkReaction, width, height, outFile);
    }

    public static synchronized void LeftToRightReactionLayoutImage(IReaction cdkReaction, String rmrID, String outputDir) throws Exception {
        int height = 800;
        int width = 1200;
        File outFile = new File(ImageGenerator.getDir(outputDir), rmrID + ".png");
        ImageGenerator.makeLeftToRighHighlightedReactionToFile(cdkReaction, width, height, false, outFile);
    }

    public static synchronized void LeftToRightReactionCenterImage(IReaction cdkReaction, String rmrID, String outputDir) throws Exception {
        int height = 800;
        int width = 1200;
        File outFile = new File(ImageGenerator.getDir(outputDir), rmrID + ".png");
        ImageGenerator.makeReactionCenterHighlightedReactionToFile(cdkReaction, new LeftToRightReactionLayout(), new LeftToRightAWTReactionLayout(), width, height, outFile);
    }

    public static synchronized void TopToBottomReactionLayoutImage(IReaction cdkReaction, String rmrID, String outputDir) throws Exception {
        int height = 800;
        int width = 1200;
        File outFile = new File(ImageGenerator.getDir(outputDir), rmrID + ".png");
        ImageGenerator.makeTopToBottomRHighlightedReactionToFile(cdkReaction, width, height, outFile);
    }

    private static synchronized File getDir(String outputDir) {
        boolean success;
        File file = new File(outputDir);
        if (!file.exists() && !(success = file.mkdirs())) {
            LOGGER.debug("Could not make dir " + file);
        }
        return file;
    }

    private IReaction layoutReaction(IReaction mappedReaction, String reactionID) {
        IAtomContainer moleculeWithLayoutCheck;
        Reaction reactionWithLayout = new Reaction();
        reactionWithLayout.setDirection(IReaction.Direction.FORWARD);
        reactionWithLayout.setID(reactionID);
        for (IAtomContainer ac : mappedReaction.getReactants().atomContainers()) {
            moleculeWithLayoutCheck = LayoutCheck.getMoleculeWithLayoutCheck(ac);
            moleculeWithLayoutCheck.setID(ac.getID());
            reactionWithLayout.addReactant(ac, mappedReaction.getReactantCoefficient(ac));
        }
        for (IAtomContainer ac : mappedReaction.getProducts().atomContainers()) {
            moleculeWithLayoutCheck = LayoutCheck.getMoleculeWithLayoutCheck(ac);
            moleculeWithLayoutCheck.setID(ac.getID());
            reactionWithLayout.addProduct(ac, mappedReaction.getProductCoefficient(ac));
        }
        for (IMapping m : mappedReaction.mappings()) {
            reactionWithLayout.addMapping(m);
        }
        reactionWithLayout.setFlags(mappedReaction.getFlags());
        reactionWithLayout.setProperties(mappedReaction.getProperties());
        return reactionWithLayout;
    }

    public void addImages(IAtomContainer query2, IAtomContainer target, String label, Map<Integer, Integer> maxac) throws IOException, Exception {
        SingleMoleculeLayout msl = new SingleMoleculeLayout(this.params);
        msl.layout(query2, new Vector2d(0.0, 0.0));
        msl.layout(target, new Vector2d(0.0, 0.0));
        IAtomContainer cloneOfQuery = new AtomContainer(query2).clone();
        IAtomContainer cloneOfTarget = new AtomContainer(target).clone();
        IAtomContainer querySubgraph = query2.getBuilder().newInstance(IAtomContainer.class, cloneOfQuery);
        IAtomContainer targetSubgraph = target.getBuilder().newInstance(IAtomContainer.class, cloneOfTarget);
        ArrayList<IAtom> n1 = new ArrayList<IAtom>(query2.getAtomCount());
        ArrayList<IAtom> n2 = new ArrayList<IAtom>(target.getAtomCount());
        for (Map.Entry<Integer, Integer> aMaps : maxac.entrySet()) {
            IAtom qAtom = cloneOfQuery.getAtom(aMaps.getKey());
            IAtom tAtom = cloneOfTarget.getAtom(aMaps.getValue());
            qAtom.setID(aMaps.getKey().toString());
            tAtom.setID(aMaps.getValue().toString());
            n1.add(qAtom);
            n2.add(tAtom);
        }
        for (IAtom atom : cloneOfQuery.atoms()) {
            if (n1.contains(atom)) continue;
            querySubgraph.removeAtom(atom);
        }
        for (IAtom atom : cloneOfTarget.atoms()) {
            if (n2.contains(atom)) continue;
            targetSubgraph.removeAtom(atom);
        }
        this.queryTargetPairs.add(new QueryTargetPair(cloneOfQuery, cloneOfTarget, querySubgraph, targetSubgraph, label));
    }

    public void addImages(IAtomContainer query2, IAtomContainer target, String label, AtomAtomMapping maxac) throws IOException, Exception {
        SingleMoleculeLayout msl = new SingleMoleculeLayout(this.params);
        msl.layout(query2, new Vector2d(0.0, 0.0));
        msl.layout(target, new Vector2d(0.0, 0.0));
        IAtomContainer cloneOfQuery = new AtomContainer(query2).clone();
        IAtomContainer cloneOfTarget = new AtomContainer(target).clone();
        IAtomContainer querySubgraph = query2.getBuilder().newInstance(IAtomContainer.class, cloneOfQuery);
        IAtomContainer targetSubgraph = target.getBuilder().newInstance(IAtomContainer.class, cloneOfTarget);
        ArrayList<IAtom> n1 = new ArrayList<IAtom>(query2.getAtomCount());
        ArrayList<IAtom> n2 = new ArrayList<IAtom>(target.getAtomCount());
        for (Map.Entry<IAtom, IAtom> aMaps : maxac.getMappingsByAtoms().entrySet()) {
            IAtom qAtom = aMaps.getKey();
            IAtom tAtom = aMaps.getValue();
            qAtom.setID(String.valueOf(maxac.getQueryIndex(qAtom)));
            tAtom.setID(String.valueOf(maxac.getQueryIndex(tAtom)));
            n1.add(qAtom);
            n2.add(tAtom);
        }
        for (IAtom atom : cloneOfQuery.atoms()) {
            if (n1.contains(atom)) continue;
            querySubgraph.removeAtom(atom);
        }
        for (IAtom atom : cloneOfTarget.atoms()) {
            if (n2.contains(atom)) continue;
            targetSubgraph.removeAtom(atom);
        }
        this.queryTargetPairs.add(new QueryTargetPair(cloneOfQuery, cloneOfTarget, querySubgraph, targetSubgraph, label));
    }

    public void createImage(String outImageFileName, String qName, String tName) {
        DirectMoleculeDrawer moleculeDrawer = new DirectMoleculeDrawer();
        IChemObjectBuilder builder = SilentChemObjectBuilder.getInstance();
        IAtomContainerSet leftHandMoleculeSet = builder.newInstance(IAtomContainerSet.class, new Object[0]);
        IAtomContainerSet rightHandMoleculeSet = builder.newInstance(IAtomContainerSet.class, new Object[0]);
        this.queryTargetPairs.stream().map(pair2 -> {
            moleculeDrawer.addHighlights(pair2.querySubgraph);
            return pair2;
        }).map(pair2 -> {
            moleculeDrawer.addHighlights(pair2.targetSubgraph);
            return pair2;
        }).map(pair2 -> {
            leftHandMoleculeSet.addAtomContainer(pair2.query);
            return pair2;
        }).forEach(pair2 -> rightHandMoleculeSet.addAtomContainer(pair2.target));
        int width = 600;
        int height = 300 * this.queryTargetPairs.size();
        BufferedImage image = moleculeDrawer.makeBlankImage(width, height);
        Graphics2D g = (Graphics2D)((Image)image).getGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        ArrayList<IAtomContainer> mols = new ArrayList<IAtomContainer>();
        this.queryTargetPairs.stream().map(pair2 -> {
            mols.add(pair2.query);
            return pair2;
        }).forEach(pair2 -> mols.add(pair2.target));
        ZoomToFitGridLayout layoutDrawer = new ZoomToFitGridLayout(moleculeDrawer, this.queryTargetPairs.size(), 2);
        layoutDrawer.layout(mols, new Dimension(300, 300), g);
        float labelX = 150.0f;
        float labelY = 15.0f;
        g.setColor(Color.BLACK);
        for (QueryTargetPair pair3 : this.queryTargetPairs) {
            g.drawString(pair3.label, labelX, labelY);
            labelY += 300.0f;
        }
        g.dispose();
        try {
            ImageIO.write((RenderedImage)image, "PNG", new File(outImageFileName + ".png"));
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public RenderedImage createImage() {
        DirectMoleculeDrawer moleculeDrawer = new DirectMoleculeDrawer();
        IChemObjectBuilder builder = SilentChemObjectBuilder.getInstance();
        IAtomContainerSet leftHandMoleculeSet = builder.newInstance(IAtomContainerSet.class, new Object[0]);
        IAtomContainerSet rightHandMoleculeSet = builder.newInstance(IAtomContainerSet.class, new Object[0]);
        this.queryTargetPairs.stream().map(pair2 -> {
            moleculeDrawer.addHighlights(pair2.querySubgraph);
            return pair2;
        }).map(pair2 -> {
            moleculeDrawer.addHighlights(pair2.targetSubgraph);
            return pair2;
        }).map(pair2 -> {
            leftHandMoleculeSet.addAtomContainer(pair2.query);
            return pair2;
        }).forEach(pair2 -> rightHandMoleculeSet.addAtomContainer(pair2.target));
        int width = 600;
        int height = 300 * this.queryTargetPairs.size();
        BufferedImage image = moleculeDrawer.makeBlankImage(width, height);
        Graphics2D g = (Graphics2D)((Image)image).getGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        ArrayList<IAtomContainer> mols = new ArrayList<IAtomContainer>();
        this.queryTargetPairs.stream().map(pair2 -> {
            mols.add(pair2.query);
            return pair2;
        }).forEach(pair2 -> mols.add(pair2.target));
        ZoomToFitGridLayout layoutDrawer = new ZoomToFitGridLayout(moleculeDrawer, this.queryTargetPairs.size(), 2);
        layoutDrawer.layout(mols, new Dimension(300, 300), g);
        float labelX = 150.0f;
        float labelY = 15.0f;
        g.setColor(Color.BLACK);
        for (QueryTargetPair pair3 : this.queryTargetPairs) {
            g.drawString(pair3.label, labelX, labelY);
            labelY += 300.0f;
        }
        g.dispose();
        return image;
    }

    public synchronized void directMoleculeImageNaturalScale(File outputDirName, IAtomContainer molecule, String molID) throws IOException {
        DirectMoleculeDrawer moleculeDrawer = new DirectMoleculeDrawer();
        Params p1 = moleculeDrawer.getParams();
        p1.drawAtomID = false;
        p1.atomSymbolFontSize = 14;
        p1.moleculeLabelFontSize = 14;
        p1.bondLength = 50;
        p1.filledWedgeWidth = 10;
        p1.dashedWedgeStroke = 1.5f;
        p1.dashedGapFactor = 0.1;
        p1.drawMoleculeID = true;
        SingleMoleculeLayout layout = new SingleMoleculeLayout(p1, false);
        Vector2d center = new Vector2d(0.0, 0.0);
        layout.invert(molecule);
        BoundsTree boundsTree = layout.layout(molecule, center);
        Dimension canvasSize = new Dimension((int)boundsTree.getWidth(), (int)boundsTree.getHeight());
        int width = canvasSize.width + 2 * p1.borderX;
        int height = canvasSize.height + 2 * p1.borderY;
        int centerX = width / 2;
        if (p1.drawMoleculeID) {
            int centerY = (int)((double)(height / 2) - p1.labelYGap);
        } else {
            int centerY = height / 2;
        }
        BufferedImage image = moleculeDrawer.makeBlankImage(width, height);
        Graphics2D g = (Graphics2D)((Image)image).getGraphics();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, width, height);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        moleculeDrawer.drawMolecule(molecule, g);
        File outFile = new File(outputDirName, molID + ".png");
        ImageIO.write((RenderedImage)image, "PNG", outFile);
    }

    public synchronized void directMoleculeImageZoomedToFit(File outputDirName, IAtomContainer molecule, String molID) throws IOException {
        int width = 800;
        int height = 600;
        this.directMoleculeImageZoomedToFit(outputDirName, molecule, molID, width, height);
    }

    public synchronized void directMoleculeImageZoomedToFit(File outputDirName, IAtomContainer molecule, String molID, int width, int height) throws IOException {
        DirectMoleculeDrawer moleculeDrawer = new DirectMoleculeDrawer();
        Params par = moleculeDrawer.getParams();
        par.drawAtomID = false;
        par.bondLength = 50;
        par.moleculeLabelFontSize = 20;
        par.atomSymbolFontSize = 20;
        par.labelYGap = 30.0;
        par.filledWedgeWidth = 10;
        par.dashedWedgeStroke = 1.0f;
        par.dashedGapFactor = 0.1;
        par.borderX = 40;
        par.borderY = 40;
        par.drawImplicitHydrogens = true;
        BufferedImage image = moleculeDrawer.makeBlankImage(width, height);
        Graphics2D g = (Graphics2D)((Image)image).getGraphics();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, width, height);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        ZoomToFitLayout layout = new ZoomToFitLayout(moleculeDrawer);
        layout.invert(molecule);
        layout.layout(molecule, new Dimension(width, height), g);
        File outFile = new File(outputDirName, molID + ".png");
        ImageIO.write((RenderedImage)image, "PNG", outFile);
    }

    public synchronized void drawTopToBottomReactionLayout(String outputDir, IReaction cdkReaction, String rmrID) throws Exception {
        this.drawTopToBottomReactionLayout(new CreateDirectory().createDirectory(outputDir, false), cdkReaction, rmrID);
    }

    public synchronized void drawTopToBottomReactionLayout(File outputDirName, IReaction cdkReaction, String rmrID) throws Exception {
        int width = 800;
        int height = 1000;
        RBlastReaction rbReaction = new RBlastReaction(cdkReaction, true);
        DirectRBLastReactionDrawer drawer = new DirectRBLastReactionDrawer(new Params(), new TopToBottomReactionLayout(), new TopToBottomAWTReactionLayout());
        drawer.getParams().drawMappings = false;
        drawer.getParams().drawAromaticCircles = true;
        drawer.getParams().drawAtomID = true;
        drawer.getParams().drawLonePairs = false;
        drawer.getParams().drawSubgraphBoxes = false;
        drawer.getParams().highlightSubgraphs = true;
        drawer.getParams().drawSubgraphMappingLines = false;
        drawer.getParams().highlightsBelow = false;
        drawer.getParams().highlightsAbove = true;
        drawer.getParams().drawAromaticCircles = true;
        drawer.getParams().highlightAlpha = 0.25f;
        drawer.getParams().drawRS = true;
        drawer.getParams().leftToRightMoleculeLabelFontSize = 10;
        drawer.getParams().labelYGap = 25.0;
        drawer.getParams().borderY = 40;
        drawer.getParams().arrowGap = 30;
        drawer.getParams().arrowLength = 60;
        drawer.getParams().drawFatArrow = true;
        drawer.getParams().drawArrowFilled = true;
        Image image = drawer.drawRBlastReaction(rbReaction, width, height);
        File outFile = new File(outputDirName, rmrID + ".png");
        ImageIO.write((RenderedImage)((Object)image), "PNG", outFile);
    }

    public synchronized void drawLeftToRightReactionLayout(String outputDirName, IReaction cdkReaction, String rmrID) throws Exception {
        this.drawLeftToRightReactionLayout(new CreateDirectory().createDirectory(outputDirName, false), cdkReaction, rmrID);
    }

    public synchronized void drawLeftToRightReactionLayout(File outputDirName, IReaction mappedReaction, String reactionID) throws Exception {
        int width = 2048;
        int height = 600;
        IReaction reactionWithLayout = this.layoutReaction(mappedReaction, reactionID);
        RBlastReaction rbReaction = new RBlastReaction(reactionWithLayout, true);
        DirectRBLastReactionDrawer drawer = new DirectRBLastReactionDrawer(new Params(), new LeftToRightReactionLayout(), new LeftToRightAWTReactionLayout());
        drawer.getParams().drawMappings = false;
        drawer.getParams().drawAtomID = false;
        drawer.getParams().drawLonePairs = false;
        drawer.getParams().drawSubgraphBoxes = false;
        drawer.getParams().highlightSubgraphs = true;
        drawer.getParams().drawSubgraphMappingLines = false;
        drawer.getParams().highlightsBelow = false;
        drawer.getParams().highlightsAbove = true;
        drawer.getParams().drawAromaticCircles = true;
        drawer.getParams().drawRS = true;
        drawer.getParams().leftToRightMoleculeLabelFontSize = 10;
        drawer.getParams().labelYGap = 25.0;
        drawer.getParams().borderY = 40;
        drawer.getParams().arrowGap = 30;
        drawer.getParams().arrowLength = 60;
        drawer.getParams().drawFatArrow = true;
        drawer.getParams().drawArrowFilled = true;
        drawer.getParams().highlightAlpha = 0.3f;
        drawer.getParams().bondStrokeWidth = 2.0f;
        Image image = drawer.drawRBlastReaction(rbReaction, width, height);
        File outFile = new File(outputDirName, reactionID + ".png");
        ImageIO.write((RenderedImage)((Object)image), "PNG", outFile);
    }

    public void drawLeftToRightReactionCenterMoleculeImage(File outputDir, IReaction mappedReaction, List<String> reactionCenterSigs, String reactionID) throws IOException {
        int width = 1000;
        int height = 800;
        Params par = new Params();
        par.drawMappings = false;
        par.drawHighlights = true;
        par.highlightsAbove = true;
        par.drawAtomID = false;
        par.drawMoleculeID = true;
        par.labelYGap *= 2.0;
        par.drawAromaticCircles = true;
        par.useCircularHighlight = true;
        par.circularHighlightIsConcentric = true;
        par.circularHighlightTransparentFilled = false;
        par.circularHighlightShowAtoms = false;
        par.drawSubgraphBoxes = false;
        par.drawBondStereoChanges = false;
        par.drawBondFormedCleavedMarks = false;
        par.drawBondOrderChangedMarks = false;
        par.drawRS = true;
        IReaction reactionWithLayout = this.layoutReaction(mappedReaction, reactionID);
        DirectRBLastReactionDrawer reactionDrawer = new DirectRBLastReactionDrawer(par, new LeftToRightReactionLayout());
        RBlastReaction rblReaction = new RBlastReaction(reactionWithLayout, true);
        this.setHighightsFromSignatures(reactionDrawer, rblReaction, reactionCenterSigs);
        BufferedImage image = reactionDrawer.getReactionDrawer().getMoleculeDrawer().makeBlankImage(width, height);
        Graphics2D g = (Graphics2D)((Image)image).getGraphics();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, width, height);
        reactionDrawer.drawRBlastReaction(rblReaction, width, height, g);
        g.dispose();
        File file = new File(outputDir, reactionID + ".png");
        ImageIO.write((RenderedImage)image, "PNG", file);
    }

    private void setHighightsFromSignatures(DirectRBLastReactionDrawer drawer, RBlastReaction rblReaction, List<String> signatures) {
        IReaction reaction = this.layoutReaction(rblReaction.getReaction(), "Signature_" + rblReaction.getReaction().getID());
        SignatureMatcher matcher = new SignatureMatcher(1, 3);
        List<IAtom> roots = matcher.getMatchingRootAtoms(signatures, reaction);
        ArrayList<IAtom> filteredRoots = new ArrayList<IAtom>();
        this.filterByBonds(roots, filteredRoots, rblReaction.getBondsCleavedInReactant());
        this.filterByBonds(roots, filteredRoots, rblReaction.getBondsFormedInProduct());
        this.filterByBonds(roots, filteredRoots, rblReaction.getBondsOrderChangedInReactant());
        this.filterByBonds(roots, filteredRoots, rblReaction.getBondsOrderChangedInProduct());
        this.filterByAtoms(roots, filteredRoots, rblReaction.getAtomStereoProductMap().keySet());
        this.filterByAtoms(roots, filteredRoots, rblReaction.getAtomStereoReactantMap().keySet());
        Map<IAtom, IAtomContainer> atomToAtomContainerMap = this.getAtomToAtomContainerMap(reaction);
        Color rootColor = Color.RED;
        Color neighbourColor = Color.GREEN;
        DirectMoleculeDrawer moleculeDrawer = drawer.getReactionDrawer().getMoleculeDrawer();
        moleculeDrawer.getHighlighters().clear();
        for (IAtom atom : filteredRoots) {
            IAtomContainer rootContainer = reaction.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
            IAtomContainer atomContainer = atomToAtomContainerMap.get(atom);
            rootContainer.addAtom(atom);
            IAtomContainer neighbourContainer = reaction.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
            atomContainer.getConnectedAtomsList(atom).stream().forEach(neighbour -> neighbourContainer.addAtom((IAtom)neighbour));
            OutlineHighlighter highlighter = new OutlineHighlighter(moleculeDrawer.getParams());
            highlighter.addHighlights(rootContainer, rootColor);
            highlighter.addHighlights(neighbourContainer, neighbourColor);
            moleculeDrawer.addHighlighter(highlighter);
        }
    }

    private Map<IAtom, IAtomContainer> getAtomToAtomContainerMap(IReaction reaction) {
        HashMap<IAtom, IAtomContainer> map = new HashMap<IAtom, IAtomContainer>();
        ReactionManipulator.getAllAtomContainers(reaction).stream().forEach(atomContainer -> {
            for (IAtom atom : atomContainer.atoms()) {
                map.put(atom, (IAtomContainer)atomContainer);
            }
        });
        return map;
    }

    private void filterByBonds(List<IAtom> atomList, List<IAtom> filteredList, List<IBond> bonds) {
        atomList.stream().forEach(atom -> bonds.stream().filter(bond -> bond.contains((IAtom)atom)).forEach(_item -> filteredList.add((IAtom)atom)));
    }

    private void filterByAtoms(List<IAtom> atomList, List<IAtom> filteredList, Set<IAtom> validAtoms) {
        HashSet<IAtom> setDiff = new HashSet<IAtom>(atomList);
        setDiff.retainAll(validAtoms);
        filteredList.addAll(setDiff);
    }

    static {
        System.setProperty("java.awt.headless", "true");
        LOGGER.info("Headless enabled: " + GraphicsEnvironment.isHeadless());
    }

    private class QueryTargetPair {
        public final IAtomContainer query;
        public final IAtomContainer target;
        public final IAtomContainer querySubgraph;
        public final IAtomContainer targetSubgraph;
        public final String label;

        QueryTargetPair(IAtomContainer query2, IAtomContainer target, IAtomContainer querySubgraph, IAtomContainer targetSubgraph, String label) {
            this.query = query2;
            this.target = target;
            this.querySubgraph = querySubgraph;
            this.targetSubgraph = targetSubgraph;
            this.label = label;
        }
    }
}

