/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.tools;

import java.awt.Image;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import javax.imageio.ImageIO;
import org.openscience.cdk.AtomContainer;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;
import uk.ac.ebi.reactionblast.fingerprints.interfaces.IPatternFingerprinter;
import uk.ac.ebi.reactionblast.mechanism.BondChangeCalculator;
import uk.ac.ebi.reactionblast.mechanism.MappingSolution;
import uk.ac.ebi.reactionblast.mechanism.ReactionMechanismTool;
import uk.ac.ebi.reactionblast.tools.ExtReactionManipulatorTool;
import uk.ac.ebi.reactionblast.tools.ImageGenerator;
import uk.ac.ebi.reactionblast.tools.StandardizeReaction;
import uk.ac.ebi.reactionblast.tools.TestUtility;
import uk.ac.ebi.reactionblast.tools.rxnfile.MDLV2000Reader;

public class MappingUtility
extends TestUtility {
    static final String NEW_LINE = System.getProperty("line.separator");
    private static final ILoggingTool LOGGER = LoggingToolFactory.createLoggingTool(MappingUtility.class);

    public IReaction readReaction(String name) throws FileNotFoundException, CDKException, Exception {
        return this.readReaction(name, true);
    }

    public IReaction readReaction(String name, boolean reMap) throws FileNotFoundException, CDKException, Exception {
        return this.readReactionFile(name, "Output/", reMap, false);
    }

    public IReaction readReaction(String name, String dir, boolean reMap) throws FileNotFoundException, CDKException, Exception {
        return this.readReactionFile(name, dir, reMap, false);
    }

    public IReaction readReaction(String name, String dir) throws FileNotFoundException, CDKException, Exception {
        return this.readReactionFile(name, dir, false, false);
    }

    public IAtomContainer readMDLMolecule(String name, String dir) throws FileNotFoundException, CDKException {
        String filepath = dir + name + ".mol";
        MDLV2000Reader reader = new MDLV2000Reader(new FileReader(filepath));
        IAtomContainer AtomContainer3 = reader.read(new AtomContainer());
        AtomContainer3.setID(name);
        return AtomContainer3;
    }

    public IReaction map(IReaction reaction) {
        try {
            ReactionMechanismTool rmt = new ReactionMechanismTool(reaction, true, false, false, true, new StandardizeReaction());
            return rmt.getSelectedSolution().getBondChangeCalculator().getReactionWithCompressUnChangedHydrogens();
        }
        catch (Exception e) {
            LOGGER.error(Level.SEVERE, null, e);
            return reaction;
        }
    }

    public void writeToFile(Image image, String outputDirPath, String name) throws IOException {
        File outfile;
        File outputDir = new File(outputDirPath);
        if (!outputDir.exists()) {
            outputDir.mkdir();
        }
        if (!(outfile = new File(outputDir, name + ".png")).exists()) {
            outfile.createNewFile();
        }
        ImageIO.write((RenderedImage)((Object)image), "PNG", outfile);
    }

    public ReactionMechanismTool testReactions(String reactionID, String directory) throws FileNotFoundException, Exception {
        IReaction cdkReaction = null;
        try {
            cdkReaction = this.readReaction(reactionID, directory, false);
            ExtReactionManipulatorTool.addExplicitH(cdkReaction);
            try {
                for (IAtomContainer a : cdkReaction.getReactants().atomContainers()) {
                    AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(a);
                    AtomContainerManipulator.percieveAtomTypesAndConfigureUnsetProperties(a);
                }
                for (IAtomContainer a : cdkReaction.getProducts().atomContainers()) {
                    AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(a);
                    AtomContainerManipulator.percieveAtomTypesAndConfigureUnsetProperties(a);
                }
            }
            catch (Exception e) {
                LOGGER.error(Level.SEVERE, NEW_LINE, " Sorry- failed to create reaction smiles: ", e.getMessage());
            }
            ReactionMechanismTool annotation = this.getAnnotation(cdkReaction);
            return annotation;
        }
        catch (Exception e) {
            LOGGER.error(Level.SEVERE, NEW_LINE, " Sorry- looks like something failed ", e.getMessage());
            return null;
        }
    }

    public ReactionMechanismTool getAnnotation(IReaction cdkReaction) throws AssertionError, Exception {
        ReactionMechanismTool rmt = null;
        try {
            rmt = new ReactionMechanismTool(cdkReaction, true, true, false, true, new StandardizeReaction());
            MappingSolution s = rmt.getSelectedSolution();
            IReaction reactionWithCompressUnChangedHydrogens = s.getBondChangeCalculator().getReactionWithCompressUnChangedHydrogens();
            try {
                ImageGenerator.LeftToRightReactionCenterImage(reactionWithCompressUnChangedHydrogens, s.getReaction().getID() + s.getAlgorithmID() + "RC", "Output");
                ImageGenerator.TopToBottomReactionLayoutImage(reactionWithCompressUnChangedHydrogens, s.getReaction().getID() + s.getAlgorithmID(), "Output");
            }
            catch (Exception e) {
                LOGGER.error(Level.SEVERE, " Failed to generate image: ", e.getMessage());
            }
        }
        catch (Exception e) {
            LOGGER.error(Level.SEVERE, " Reaction Mechanism failed ", e.getMessage());
        }
        return rmt;
    }

    public BondChangeCalculator testRCReactions(String reactionID, String directory) throws FileNotFoundException, Exception {
        IReaction cdkReaction = this.readReaction(reactionID, directory, false);
        ReactionMechanismTool rmt = new ReactionMechanismTool(cdkReaction, true, true, true, false);
        MappingSolution s = rmt.getSelectedSolution();
        new ImageGenerator().drawLeftToRightReactionLayout("Output", s.getBondChangeCalculator().getReactionWithCompressUnChangedHydrogens(), reactionID + s.getAlgorithmID());
        StringBuilder sb = new StringBuilder();
        sb.append("++++++++++++++++++++++++++++++++++++++++++");
        sb.append(NEW_LINE);
        sb.append("Bond Changes:");
        sb.append(NEW_LINE);
        sb.append("//");
        sb.append(NEW_LINE);
        sb.append(s.getBondChangeCalculator().getFormedCleavedWFingerprint().toString());
        sb.append(NEW_LINE);
        sb.append(s.getBondChangeCalculator().getOrderChangesWFingerprint().toString());
        sb.append(NEW_LINE);
        sb.append(s.getBondChangeCalculator().getStereoChangesWFingerprint().toString());
        sb.append(NEW_LINE);
        sb.append(s.getBondChangeCalculator().getReactionCenterWFingerprint().toString());
        sb.append(NEW_LINE);
        sb.append("//");
        sb.append(NEW_LINE);
        System.out.println(sb.toString());
        StringBuilder rcSteps = new StringBuilder();
        rcSteps.append("Formed Cleaved");
        rcSteps.append(NEW_LINE);
        Map<Integer, IPatternFingerprinter> reactionCenterFormedCleavedFingerprint = s.getBondChangeCalculator().getReactionCenterFormedCleavedFingerprint();
        reactionCenterFormedCleavedFingerprint.entrySet().stream().filter(m -> (Integer)m.getKey() != -1).forEach(m -> rcSteps.append(m.getValue()));
        rcSteps.append("Order Change");
        rcSteps.append(NEW_LINE);
        Map<Integer, IPatternFingerprinter> reactionCenterOrderChangeFingerprint = s.getBondChangeCalculator().getReactionCenterOrderChangeFingerprint();
        reactionCenterOrderChangeFingerprint.entrySet().stream().filter(m -> (Integer)m.getKey() != -1).forEach(m -> rcSteps.append(m.getValue()));
        rcSteps.append("Stereo Change");
        rcSteps.append(NEW_LINE);
        Map<Integer, IPatternFingerprinter> reactionCenterStereoChangeFingerprint = s.getBondChangeCalculator().getReactionCenterStereoChangeFingerprint();
        reactionCenterStereoChangeFingerprint.entrySet().stream().filter(m -> (Integer)m.getKey() != -1).forEach(m -> rcSteps.append(m.getValue()));
        rcSteps.append(NEW_LINE);
        System.out.println(rcSteps.toString());
        return s.getBondChangeCalculator();
    }

    public BondChangeCalculator map(String reactionID, String directory) throws FileNotFoundException, Exception {
        IReaction cdkReaction = this.readReaction(reactionID, directory, false);
        ReactionMechanismTool rmt = new ReactionMechanismTool(cdkReaction, true, true, true, false);
        MappingSolution s = rmt.getSelectedSolution();
        new ImageGenerator().drawLeftToRightReactionLayout("Output", s.getBondChangeCalculator().getReactionWithCompressUnChangedHydrogens(), reactionID + s.getAlgorithmID());
        return s.getBondChangeCalculator();
    }
}

