/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.tools;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.imageio.ImageIO;
import javax.vecmath.Vector2d;
import org.openscience.cdk.AtomContainerSet;
import org.openscience.cdk.Reaction;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IElement;
import org.openscience.cdk.interfaces.IMapping;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.interfaces.IReactionSet;
import org.openscience.cdk.layout.StructureDiagramGenerator;
import org.openscience.cdk.silent.SilentChemObjectBuilder;
import org.openscience.cdk.tools.CDKHydrogenAdder;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.LonePairElectronChecker;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;
import org.openscience.smsd.tools.ExtAtomContainerManipulator;
import uk.ac.ebi.reactionblast.graphics.direct.DirectMoleculeDrawer;
import uk.ac.ebi.reactionblast.graphics.direct.layout.SingleMoleculeLayout;
import uk.ac.ebi.reactionblast.graphics.direct.layout.ZoomToFitLayout;
import uk.ac.ebi.reactionblast.mapping.blocks.BlockReactionCanoniser;
import uk.ac.ebi.reactionblast.mapping.helper.MappingHandler;
import uk.ac.ebi.reactionblast.mechanism.ReactionMechanismTool;
import uk.ac.ebi.reactionblast.tools.StandardizeReaction;
import uk.ac.ebi.reactionblast.tools.rxnfile.MDLRXNV2000Reader;

public class TestUtility {
    public static final String KEGG_RXN_DIR = "rxn/kegg/";
    public static final String RHEA_RXN_DIR = "rxn/rhea/";
    public static final String BRENDA_RXN_DIR = "rxn/brenda/";
    public static final String BUG_RXN_DIR = "rxn/bug/";
    public static final String OTHER_RXN = "rxn/other/";
    public static final String METRXN_RXN = "rxn/metrxn/";
    public static final String INFORCHEM_RXN = "rxn/infochem/";
    public static final String MACIE_RXN = "rxn/macie/";
    private static final ILoggingTool LOGGER = LoggingToolFactory.createLoggingTool(TestUtility.class);
    private static boolean DEBUG = false;

    protected void setLonePairs(IReaction reaction) {
        LonePairElectronChecker checker = new LonePairElectronChecker();
        this.setLonePairs(reaction.getReactants(), checker);
        this.setLonePairs(reaction.getProducts(), checker);
    }

    protected void setLonePairs(IAtomContainerSet AtomContainerSet2, LonePairElectronChecker checker) {
        for (IAtomContainer atomContainer : AtomContainerSet2.atomContainers()) {
            try {
                checker.saturate(atomContainer);
            }
            catch (CDKException c) {
                LOGGER.error(Level.SEVERE, null, c);
            }
        }
    }

    protected void detectAromaticity(IReaction reaction) {
        this.detectAromaticity(reaction.getReactants());
        this.detectAromaticity(reaction.getProducts());
    }

    protected void detectAromaticity(IAtomContainerSet molSet) {
        for (IAtomContainer ac : molSet.atomContainers()) {
            try {
                ExtAtomContainerManipulator.aromatizeCDK(ac);
            }
            catch (CDKException e) {
                LOGGER.error(e);
            }
        }
    }

    protected void setMappingIDs(IReaction reaction) {
        int i = 0;
        for (IMapping mapping : reaction.mappings()) {
            IAtom a0 = (IAtom)mapping.getChemObject(0);
            IAtom a1 = (IAtom)mapping.getChemObject(1);
            Object mappingID = a0.getProperty("cdk:AtomAtomMapping");
            if (mappingID != null) {
                a0.setID(String.valueOf(mappingID));
                a1.setID(String.valueOf(mappingID));
            } else {
                a0.setID(String.valueOf(i));
                a1.setID(String.valueOf(i));
            }
            ++i;
        }
    }

    protected void renumberMappingIDs(IReaction reaction) {
        int i = 1;
        for (IMapping mapping : reaction.mappings()) {
            IAtom a0 = (IAtom)mapping.getChemObject(0);
            IAtom a1 = (IAtom)mapping.getChemObject(1);
            a0.setID(String.valueOf(i));
            a1.setID(String.valueOf(i));
            mapping.setID(String.valueOf(i));
            ++i;
        }
    }

    protected void addImplicitHydrogens(IReaction reaction) {
        this.addImplicitHydrogens(reaction.getReactants());
        this.addImplicitHydrogens(reaction.getProducts());
    }

    protected void addImplicitHydrogens(IAtomContainerSet molSet) {
        for (IAtomContainer atomContainer : molSet.atomContainers()) {
            this.addImplicitHydrogens(atomContainer);
        }
    }

    protected void addImplicitHydrogens(IAtomContainer atomContainer) {
        try {
            CDKHydrogenAdder.getInstance(SilentChemObjectBuilder.getInstance()).addImplicitHydrogens(atomContainer);
        }
        catch (CDKException e) {
            LOGGER.error(Level.SEVERE, null, e);
        }
    }

    protected void typeAtoms(IAtomContainer atomContainer) {
        try {
            AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(atomContainer);
        }
        catch (CDKException e) {
            LOGGER.error(Level.SEVERE, null, e);
        }
    }

    protected IReaction canonise(IReaction reaction) {
        BlockReactionCanoniser labeller = new BlockReactionCanoniser();
        return labeller.getCanonicalReaction(reaction);
    }

    protected IAtomContainer layout(IAtomContainer AtomContainer3) {
        try {
            StructureDiagramGenerator sdg = new StructureDiagramGenerator();
            sdg.setMolecule(AtomContainer3, true);
            sdg.generateCoordinates();
            return sdg.getMolecule();
        }
        catch (CDKException e) {
            return AtomContainer3;
        }
    }

    protected BufferedImage makeBlankImage(int width, int height) {
        BufferedImage image = new BufferedImage(width, height, 4);
        Graphics2D g = (Graphics2D)image.getGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, width, height);
        return image;
    }

    protected void draw(DirectMoleculeDrawer molDrawer, IAtomContainer AtomContainer3, String dirPath, String name) throws IOException {
        int width = 700;
        int height = 700;
        SingleMoleculeLayout layout = new SingleMoleculeLayout(molDrawer.getParams());
        layout.layout(AtomContainer3, new Vector2d(width / 2, height / 2));
        ZoomToFitLayout layout2 = new ZoomToFitLayout(molDrawer);
        BufferedImage image = this.makeBlankImage(width, height);
        Graphics2D g = (Graphics2D)((Image)image).getGraphics();
        layout2.layout(AtomContainer3, new Dimension(width, height), g);
        File dir = new File(dirPath);
        if (!dir.exists()) {
            dir.mkdir();
        }
        ImageIO.write((RenderedImage)image, "PNG", new File(dir, name + ".png"));
    }

    private InputStream getFileWithUtil(String fileName) throws IOException {
        ClassLoader classLoader = this.getClass().getClassLoader();
        return classLoader.getResourceAsStream(fileName);
    }

    protected IReaction readReactionFile(String name, String dir, boolean reMap, boolean removeHydrogens) throws Exception {
        String filepath = dir + name + ".rxn";
        IReaction reaction = null;
        try (MDLRXNV2000Reader reader = new MDLRXNV2000Reader(this.getFileWithUtil(filepath));){
            reaction = reader.read(new Reaction());
            reaction.setID(name);
            if (DEBUG) {
                System.out.println("Read Reaction ");
                for (IAtomContainer iAtomContainer : reaction.getReactants().atomContainers()) {
                    System.out.println("r " + iAtomContainer.getTitle() + ":" + reaction.getReactantCoefficient(iAtomContainer));
                }
                for (IAtomContainer iAtomContainer : reaction.getProducts().atomContainers()) {
                    System.out.println("p " + iAtomContainer.getTitle() + ":" + reaction.getProductCoefficient(iAtomContainer));
                }
            }
        }
        catch (Exception ex) {
            LOGGER.error(Level.SEVERE, "Unable to parse the RXN file", ex.getMessage());
        }
        if (removeHydrogens && reaction != null) {
            Reaction hydrogenFreeReaction = new Reaction();
            AtomContainerSet hydrogenFreeReactants = new AtomContainerSet();
            for (IAtomContainer atomContainer : reaction.getReactants().atomContainers()) {
                TestUtility.setNullHCountToZero(atomContainer);
                AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(atomContainer);
                IAtomContainer acMinusH = ExtAtomContainerManipulator.convertExplicitToImplicitHydrogens(atomContainer);
                acMinusH.setID(atomContainer.getTitle());
                hydrogenFreeReactants.addAtomContainer(acMinusH);
            }
            hydrogenFreeReaction.setReactants(hydrogenFreeReactants);
            AtomContainerSet atomContainerSet = new AtomContainerSet();
            for (IAtomContainer atomContainer : reaction.getProducts().atomContainers()) {
                TestUtility.setNullHCountToZero(atomContainer);
                AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(atomContainer);
                IAtomContainer acMinusH = ExtAtomContainerManipulator.convertExplicitToImplicitHydrogens(atomContainer);
                acMinusH.setID(atomContainer.getTitle());
                atomContainerSet.addAtomContainer(acMinusH);
            }
            hydrogenFreeReaction.setProducts(atomContainerSet);
            for (IMapping mapping : reaction.mappings()) {
                if (((IElement)mapping.getChemObject(0)).getSymbol().equals("H") || ((IElement)mapping.getChemObject(1)).getSymbol().equals("H")) continue;
                hydrogenFreeReaction.addMapping(mapping);
            }
            reaction = hydrogenFreeReaction;
        }
        if (reMap) {
            MappingHandler.cleanMapping(reaction);
        } else {
            this.renumberMappingIDs(reaction);
        }
        return reaction;
    }

    static void setNullHCountToZero(IAtomContainer mol) {
        for (IAtom a : mol.atoms()) {
            if (a.getImplicitHydrogenCount() != null) continue;
            a.setImplicitHydrogenCount(0);
        }
    }

    protected List<IReaction> mapReactions(IReactionSet reactionSet, boolean remap) throws FileNotFoundException, Exception {
        ArrayList<IReaction> mappedReactionList = new ArrayList<IReaction>();
        for (IReaction cdkReaction : reactionSet.reactions()) {
            IReaction mappedReaction = this.mapReaction(cdkReaction, remap);
            mappedReactionList.add(mappedReaction);
        }
        return mappedReactionList;
    }

    protected IReaction mapReaction(IReaction cdkReaction, boolean remap) throws FileNotFoundException, Exception {
        String reactionName = cdkReaction.getID();
        IReaction cleanReaction = this.cleanReaction(cdkReaction, reactionName);
        ReactionMechanismTool rmt = new ReactionMechanismTool(cleanReaction, remap, true, false, true, new StandardizeReaction());
        IReaction mappedReaction = rmt.getSelectedSolution().getReaction();
        this.renumberMappingIDs(mappedReaction);
        return mappedReaction;
    }

    protected IReaction cleanReaction(IReaction reaction, String reactionName) throws Exception {
        reaction.setID(reactionName);
        return reaction;
    }
}

