/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.tools.bulk;

import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import uk.ac.ebi.reactionblast.interfaces.ITransformation;
import uk.ac.ebi.reactionblast.mechanism.BondChangeCalculator;

public class BondChangeCalculationTransformation
implements ITransformation<IReaction> {
    private static final ILoggingTool LOGGER = LoggingToolFactory.createLoggingTool(BondChangeCalculationTransformation.class);

    @Override
    public ITransformation.TargetType getTargetType() {
        return ITransformation.TargetType.REACTION;
    }

    @Override
    public IReaction transform(IReaction reaction) {
        try {
            boolean generate2D = false;
            boolean generate3D = false;
            BondChangeCalculator bcc = new BondChangeCalculator(reaction);
            bcc.computeBondChanges(generate2D, generate3D);
            return bcc.getReactionWithCompressUnChangedHydrogens();
        }
        catch (Exception e) {
            LOGGER.error(e);
            return null;
        }
    }
}

