/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.tools.bulk;

import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IReaction;
import uk.ac.ebi.reactionblast.interfaces.IDataSource;
import uk.ac.ebi.reactionblast.interfaces.IDataStore;
import uk.ac.ebi.reactionblast.interfaces.ITransformation;

public class BulkTransformer {
    private final ITransformation transformation;

    public BulkTransformer(ITransformation transformation) {
        this.transformation = transformation;
    }

    public void transform(IDataSource dataSource, IDataStore dataStore) {
        switch (this.transformation.getTargetType()) {
            case REACTION: {
                this.transformReactions(dataSource, dataStore);
                break;
            }
            case MOLECULE: {
                this.transformMolecules(dataSource, dataStore);
                break;
            }
        }
    }

    private void transformReactions(IDataSource<IReaction> dataSource, IDataStore dataStore) {
        IDataSource<IReaction> rxnDataSource = dataSource;
        for (IReaction reaction : rxnDataSource.getAll()) {
            IReaction transformedReaction;
            if (reaction == null || (transformedReaction = this.transformation.transform(reaction)) == null) continue;
            dataStore.store(transformedReaction);
        }
    }

    private void transformMolecules(IDataSource<IAtomContainer> dataSource, IDataStore dataStore) {
        IDataSource<IAtomContainer> molDataSource = dataSource;
        for (IAtomContainer molecule : molDataSource.getAll()) {
            IAtomContainer transformedMolecule;
            if (molecule == null || (transformedMolecule = this.transformation.transform(molecule)) == null) continue;
            dataStore.store(transformedMolecule);
        }
    }
}

