/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.tools.bulk;

import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.tools.manipulator.ReactionManipulator;
import org.openscience.smsd.tools.ExtAtomContainerManipulator;
import uk.ac.ebi.reactionblast.interfaces.ITransformation;

public class ReactionAromatizationTransformation
implements ITransformation<IReaction> {
    @Override
    public ITransformation.TargetType getTargetType() {
        return ITransformation.TargetType.REACTION;
    }

    @Override
    public IReaction transform(IReaction reaction) {
        for (IAtomContainer atomContainer : ReactionManipulator.getAllAtomContainers(reaction)) {
            try {
                ExtAtomContainerManipulator.aromatizeDayLight(atomContainer);
            }
            catch (CDKException e) {
                e.printStackTrace();
            }
        }
        return reaction;
    }
}

