/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.tools.bulk;

import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.tools.manipulator.ReactionManipulator;
import uk.ac.ebi.reactionblast.interfaces.ITransformation;

public class ReactionAtomIDTransformation
implements ITransformation<IReaction> {
    @Override
    public ITransformation.TargetType getTargetType() {
        return ITransformation.TargetType.REACTION;
    }

    @Override
    public IReaction transform(IReaction reaction) {
        for (IAtomContainer atomContainer : ReactionManipulator.getAllAtomContainers(reaction)) {
            for (IAtom atom : atomContainer.atoms()) {
                Object prop = atom.getProperty("cdk:AtomAtomMapping");
                if (prop == null) continue;
                int mappingID = (Integer)prop;
                atom.setID(String.valueOf(mappingID));
            }
        }
        return reaction;
    }
}

