/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.tools.bulk;

import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.silent.SilentChemObjectBuilder;
import org.openscience.cdk.tools.CDKHydrogenAdder;
import org.openscience.cdk.tools.manipulator.ReactionManipulator;
import org.openscience.smsd.tools.ExtAtomContainerManipulator;
import uk.ac.ebi.reactionblast.interfaces.ITransformation;

public class ReactionImplicitHydrogenTransformation
implements ITransformation<IReaction> {
    @Override
    public ITransformation.TargetType getTargetType() {
        return ITransformation.TargetType.REACTION;
    }

    @Override
    public IReaction transform(IReaction reaction) {
        CDKHydrogenAdder adder = CDKHydrogenAdder.getInstance(SilentChemObjectBuilder.getInstance());
        ReactionManipulator.getAllAtomContainers(reaction).forEach(atomContainer -> {
            try {
                ExtAtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(atomContainer);
                adder.addImplicitHydrogens((IAtomContainer)atomContainer);
            }
            catch (CDKException e) {
                e.printStackTrace();
            }
        });
        return reaction;
    }
}

