/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.tools.descriptors;

import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.logging.Level;
import org.openscience.cdk.AtomContainer;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.io.MDLV2000Reader;
import org.openscience.cdk.qsar.descriptors.molecular.APolDescriptor;
import org.openscience.cdk.qsar.descriptors.molecular.CPSADescriptor;
import org.openscience.cdk.qsar.descriptors.molecular.EccentricConnectivityIndexDescriptor;
import org.openscience.cdk.qsar.descriptors.molecular.FragmentComplexityDescriptor;
import org.openscience.cdk.qsar.descriptors.molecular.HBondAcceptorCountDescriptor;
import org.openscience.cdk.qsar.descriptors.molecular.HBondDonorCountDescriptor;
import org.openscience.cdk.qsar.descriptors.molecular.LargestPiSystemDescriptor;
import org.openscience.cdk.qsar.descriptors.molecular.PetitjeanNumberDescriptor;
import org.openscience.cdk.qsar.descriptors.molecular.RotatableBondsCountDescriptor;
import org.openscience.cdk.qsar.descriptors.molecular.TPSADescriptor;
import org.openscience.cdk.qsar.descriptors.molecular.VAdjMaDescriptor;
import org.openscience.cdk.qsar.descriptors.molecular.WeightDescriptor;
import org.openscience.cdk.qsar.descriptors.molecular.XLogPDescriptor;
import org.openscience.cdk.qsar.descriptors.molecular.ZagrebIndexDescriptor;
import org.openscience.cdk.qsar.result.DoubleResult;
import org.openscience.cdk.qsar.result.IntegerResult;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;
import org.openscience.smsd.helper.MoleculeInitializer;
import org.openscience.smsd.tools.ExtAtomContainerManipulator;
import uk.ac.ebi.reactionblast.interfaces.IMolDescriptors;

public class CDKMolecularDescriptor
extends MoleculeInitializer
implements IMolDescriptors {
    private static final ILoggingTool LOGGER = LoggingToolFactory.createLoggingTool(CDKMolecularDescriptor.class);
    private final IAtomContainer molecule;

    public CDKMolecularDescriptor(IAtomContainer molecule) throws CDKException {
        this.molecule = ExtAtomContainerManipulator.checkAndCleanMolecule(molecule);
        CDKMolecularDescriptor.initializeMolecule(molecule);
    }

    public CDKMolecularDescriptor(String molFile) throws Exception {
        FileInputStream ReadMolecule = new FileInputStream(molFile);
        MDLV2000Reader MolRead = new MDLV2000Reader(new InputStreamReader(ReadMolecule));
        MolRead.close();
        IAtomContainer newMol = MolRead.read(new AtomContainer());
        this.molecule = ExtAtomContainerManipulator.checkAndCleanMolecule(newMol);
        CDKMolecularDescriptor.initializeMolecule(this.molecule);
    }

    @Override
    public int getHBondAcceptors(boolean checkAromaticity) {
        HBondAcceptorCountDescriptor acc = new HBondAcceptorCountDescriptor();
        Object[] hBondparams = new Object[]{checkAromaticity};
        try {
            acc.setParameters(hBondparams);
        }
        catch (CDKException ex) {
            LOGGER.error(Level.SEVERE, null, ex);
        }
        int acceptors = ((IntegerResult)acc.calculate(this.molecule).getValue()).intValue();
        return acceptors;
    }

    @Override
    public int getHBondDoners(boolean checkAromaticity) {
        HBondDonorCountDescriptor don = new HBondDonorCountDescriptor();
        Object[] hBondparams = new Object[]{checkAromaticity};
        try {
            don.setParameters(hBondparams);
        }
        catch (CDKException ex) {
            LOGGER.error(Level.SEVERE, null, ex);
        }
        int donors = ((IntegerResult)don.calculate(this.molecule).getValue()).intValue();
        return donors;
    }

    @Override
    public double getXlogP(boolean checkAromaticity) {
        XLogPDescriptor xlogP = new XLogPDescriptor();
        Object[] xlogPparams = new Object[]{checkAromaticity, Boolean.TRUE};
        try {
            xlogP.setParameters(xlogPparams);
        }
        catch (CDKException ex) {
            LOGGER.error(Level.SEVERE, null, ex);
        }
        double xlogPvalue = ((DoubleResult)xlogP.calculate(this.molecule).getValue()).doubleValue();
        return xlogPvalue;
    }

    @Override
    public double getTPSADescriptor(boolean checkAromaticity) {
        TPSADescriptor tpsa = new TPSADescriptor();
        Object[] tpsaParameter = new Object[]{checkAromaticity};
        try {
            tpsa.setParameters(tpsaParameter);
        }
        catch (CDKException ex) {
            LOGGER.error(Level.SEVERE, null, ex);
        }
        double tpsaValue = ((DoubleResult)tpsa.calculate(this.molecule).getValue()).doubleValue();
        return tpsaValue;
    }

    @Override
    public double getCPSADescriptor() {
        CPSADescriptor cpsa = new CPSADescriptor();
        double cpsaValue = ((DoubleResult)cpsa.calculate(this.molecule).getValue()).doubleValue();
        return cpsaValue;
    }

    @Override
    public double getZagrebIndexDescriptor() {
        ZagrebIndexDescriptor zag = new ZagrebIndexDescriptor();
        double value = ((DoubleResult)zag.calculate(this.molecule).getValue()).doubleValue();
        return value;
    }

    @Override
    public double getAPolDescriptor() {
        APolDescriptor apol = new APolDescriptor();
        double value = ((DoubleResult)apol.calculate(this.molecule).getValue()).doubleValue();
        return value;
    }

    @Override
    public double getFragmentComplexityDescriptor() {
        FragmentComplexityDescriptor fcd = new FragmentComplexityDescriptor();
        double value = ((DoubleResult)fcd.calculate(this.molecule).getValue()).doubleValue();
        return value;
    }

    @Override
    public double getPetitjeanNumberDescriptor() {
        PetitjeanNumberDescriptor pnd = new PetitjeanNumberDescriptor();
        double value = ((DoubleResult)pnd.calculate(this.molecule).getValue()).doubleValue();
        return value;
    }

    @Override
    public double getVAdjMaDescriptor() {
        VAdjMaDescriptor vmd = new VAdjMaDescriptor();
        double value = ((DoubleResult)vmd.calculate(this.molecule).getValue()).doubleValue();
        return value;
    }

    @Override
    public double getMolecularWeight() {
        WeightDescriptor mw = new WeightDescriptor();
        Object[] mwparams = new Object[]{"*"};
        try {
            mw.setParameters(mwparams);
        }
        catch (CDKException ex) {
            LOGGER.error(Level.SEVERE, null, ex);
        }
        double value = ((DoubleResult)mw.calculate(this.molecule).getValue()).doubleValue();
        return value;
    }

    @Override
    public int getRotatableBondsCountDescriptor(boolean includeTerminals, boolean excludeAmides) {
        RotatableBondsCountDescriptor rbcd = new RotatableBondsCountDescriptor();
        Object[] params = new Object[]{includeTerminals, excludeAmides};
        int value = -1;
        try {
            rbcd.setParameters(params);
            value = ((IntegerResult)rbcd.calculate(this.molecule).getValue()).intValue();
        }
        catch (CDKException ex) {
            LOGGER.error(Level.SEVERE, null, ex);
        }
        return value;
    }

    @Override
    public int getLargestPiSystemDescriptor(boolean checkAromaticity) {
        LargestPiSystemDescriptor lps = new LargestPiSystemDescriptor();
        Object[] mwparams = new Object[]{checkAromaticity};
        try {
            lps.setParameters(mwparams);
        }
        catch (CDKException ex) {
            LOGGER.error(Level.SEVERE, null, ex);
        }
        int value = ((IntegerResult)lps.calculate(this.molecule).getValue()).intValue();
        return value;
    }

    @Override
    public int getEccentricConnectivityIndexDescriptor() {
        EccentricConnectivityIndexDescriptor eci = new EccentricConnectivityIndexDescriptor();
        int value = ((IntegerResult)eci.calculate(this.molecule).getValue()).intValue();
        return value;
    }

    @Override
    public double getTotalCharge() {
        double count = ExtAtomContainerManipulator.getTotalCharge(this.molecule);
        return count;
    }

    @Override
    public int getHeavyAtomCount() {
        int count = AtomContainerManipulator.getHeavyAtoms(this.molecule).size();
        return count;
    }

    @Override
    public int getCovalentCount() {
        int count = AtomContainerManipulator.getBondArray(this.molecule).length;
        return count;
    }
}

