/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.tools.descriptors;

import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import uk.ac.ebi.reactionblast.tools.descriptors.CDKMolecularDescriptor;

public class LipinskiRuleOfFiveDescriptor {
    private static double xlogPvalueLipinski = 5.0;
    private static int acceptorsLipinski = 10;
    private static int donorsLipinski = 5;
    private static double mwvalueLipinski = 500.0;
    private static double rotatablebondsLipinski = 10.0;
    private static final ILoggingTool LOGGER = LoggingToolFactory.createLoggingTool(LipinskiRuleOfFiveDescriptor.class);
    private double xlogPvalue = -1.0;
    private int acceptors = -1;
    private int donors = -1;
    private double mwvalue = -1.0;
    private double rotatablebonds = -1.0;

    public void resetRuleOfFiveDescriptor(double xlogPvalue, int acceptors, int donors, double mwvalue, double rotatablebonds) {
        xlogPvalueLipinski = xlogPvalue;
        acceptorsLipinski = acceptors;
        donorsLipinski = donors;
        mwvalueLipinski = mwvalue;
        rotatablebondsLipinski = rotatablebonds;
    }

    public int calculate(IAtomContainer molecule) throws Exception {
        int lipinskifailures = 0;
        CDKMolecularDescriptor cmd = new CDKMolecularDescriptor(molecule);
        this.xlogPvalue = cmd.getXlogP(true);
        this.acceptors = cmd.getHBondAcceptors(true);
        this.donors = cmd.getHBondDoners(true);
        this.mwvalue = cmd.getMolecularWeight();
        this.rotatablebonds = cmd.getRotatableBondsCountDescriptor(true, false);
        if (this.xlogPvalue > xlogPvalueLipinski) {
            ++lipinskifailures;
        }
        if (this.acceptors > acceptorsLipinski) {
            ++lipinskifailures;
        }
        if (this.donors > donorsLipinski) {
            ++lipinskifailures;
        }
        if (this.mwvalue > mwvalueLipinski) {
            ++lipinskifailures;
        }
        if (this.rotatablebonds > rotatablebondsLipinski) {
            ++lipinskifailures;
        }
        return lipinskifailures;
    }

    public int calculate(double xlogPvalue, int acceptors, int donors, double mwvalue, double rotatablebonds) {
        int lipinskifailures = 0;
        if (xlogPvalue > xlogPvalueLipinski) {
            ++lipinskifailures;
        }
        if (acceptors > acceptorsLipinski) {
            ++lipinskifailures;
        }
        if (donors > donorsLipinski) {
            ++lipinskifailures;
        }
        if (mwvalue > mwvalueLipinski) {
            ++lipinskifailures;
        }
        if (rotatablebonds > rotatablebondsLipinski) {
            ++lipinskifailures;
        }
        return lipinskifailures;
    }
}

