/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.tools.inchi;

import java.util.List;
import net.sf.jniinchi.INCHI_OPTION;
import net.sf.jniinchi.INCHI_RET;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.inchi.InChIGenerator;
import org.openscience.cdk.inchi.InChIGeneratorFactory;
import org.openscience.cdk.inchi.InChIToStructure;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public class CDKInChI {
    private static final ILoggingTool LOGGER = LoggingToolFactory.createLoggingTool(CDKInChI.class);
    public static final String R_Group_replacement_String = "At";
    public static final String[] METALS = new String[]{"At", "Th", "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", "No", "Lr"};
    private InChIGenerator _genInchi = null;
    private final InChIToStructure _intostruct = null;
    private final InChIGeneratorFactory factory = InChIGeneratorFactory.getInstance();
    protected IAtomContainer molecule = null;

    private synchronized IAtomContainer convertRGroupsToMetals(IAtomContainer mol) {
        try {
            IAtomContainer convertedMol = mol.clone();
            for (IAtom atom : convertedMol.atoms()) {
                if (!this.isR(atom)) continue;
                atom.setSymbol(R_Group_replacement_String);
            }
            return convertedMol;
        }
        catch (CloneNotSupportedException c) {
            return mol;
        }
    }

    private synchronized boolean isR(IAtom atom) {
        String symbol = atom.getSymbol();
        return symbol.charAt(0) == 'R' && !symbol.equals("Re") && !symbol.equals("Rh") && !symbol.equals("Rn") && !symbol.equals("Ru");
    }

    public synchronized String getInChI(IAtomContainer mol) throws CDKException {
        String inchi = "";
        try {
            this._genInchi = this.factory.getInChIGenerator(this.convertRGroupsToMetals(mol), "");
            this.inchi();
            inchi = this._genInchi.getInchi();
        }
        catch (CDKException e) {
            LOGGER.debug("Error in generating InChI code " + e);
        }
        return inchi;
    }

    public synchronized String getInChI(IAtomContainer mol, String options) throws CDKException {
        String inchi = "";
        try {
            this._genInchi = this.factory.getInChIGenerator(this.convertRGroupsToMetals(mol), options);
            this.inchi();
            inchi = this._genInchi.getInchi();
        }
        catch (CDKException e) {
            LOGGER.debug("Error in generating InChI code " + e);
        }
        return inchi;
    }

    public synchronized String getInChI(IAtomContainer mol, List<INCHI_OPTION> options) throws CDKException {
        String inchi = "";
        try {
            this._genInchi = this.factory.getInChIGenerator(this.convertRGroupsToMetals(mol), options);
            this.inchi();
            inchi = this._genInchi.getInchi();
        }
        catch (CDKException e) {
            LOGGER.debug("Error in generating InChI code " + e);
        }
        return inchi;
    }

    private synchronized void structure() throws CDKException {
        INCHI_RET ret = this._intostruct.getReturnStatus();
        if (ret == INCHI_RET.WARNING) {
            LOGGER.debug("InChI warning: " + this._intostruct.getMessage());
        } else if (ret != INCHI_RET.OKAY) {
            throw new CDKException("Structure generation failed failed: " + ret.toString() + " [" + this._intostruct.getMessage() + "]");
        }
    }

    private synchronized void inchi() throws CDKException {
        INCHI_RET ret = this._genInchi.getReturnStatus();
        if (ret != INCHI_RET.WARNING && ret != INCHI_RET.OKAY) {
            throw new CDKException("InChI failed: " + ret.toString() + " [" + this._genInchi.getMessage() + "]");
        }
    }

    public synchronized String getAuxinfo() {
        return this._genInchi.getAuxInfo();
    }
}

