/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.tools.labelling;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.signature.MoleculeSignature;
import signature.AbstractVertexSignature;
import uk.ac.ebi.reactionblast.tools.labelling.AtomContainerAtomPermutor;
import uk.ac.ebi.reactionblast.tools.labelling.ICanonicalMoleculeLabeller;

public class RBlastMoleculeLabeller
implements ICanonicalMoleculeLabeller {
    @Override
    public IAtomContainer getCanonicalMolecule(IAtomContainer container) {
        return AtomContainerAtomPermutor.permute(this.getCanonicalPermutation(container), container);
    }

    @Override
    public int[] getCanonicalPermutation(IAtomContainer container) {
        int atomCount = container.getAtomCount();
        MoleculeSignature moleculeSignature = new MoleculeSignature(container);
        String canonicalSignatureString = null;
        AbstractVertexSignature canonicalSignature = null;
        HashMap<String, SortableOrbit> orbitMap = new HashMap<String, SortableOrbit>();
        for (int atomIndex = 0; atomIndex < atomCount; ++atomIndex) {
            AbstractVertexSignature signatureForI = moleculeSignature.signatureForVertex(atomIndex);
            String signatureStringForVertexI = signatureForI.toCanonicalString();
            if (canonicalSignatureString == null || canonicalSignatureString.compareTo(signatureStringForVertexI) < 0) {
                canonicalSignatureString = signatureStringForVertexI;
                canonicalSignature = signatureForI;
            }
            if (orbitMap.containsKey(signatureStringForVertexI)) {
                ((SortableOrbit)orbitMap.get((Object)signatureStringForVertexI)).members.add(atomIndex);
                continue;
            }
            String elementSymbol = container.getAtom(atomIndex).getSymbol();
            SortableOrbit orbit2 = new SortableOrbit(elementSymbol, signatureStringForVertexI);
            orbit2.members.add(atomIndex);
            orbitMap.put(signatureStringForVertexI, orbit2);
        }
        int[] canonicalLabels = canonicalSignature == null ? new int[]{} : canonicalSignature.getCanonicalLabelling(atomCount);
        ArrayList orbits = new ArrayList();
        orbitMap.values().stream().map(orbit -> {
            orbit.sortMembers(canonicalLabels);
            return orbit;
        }).forEach(orbit -> orbits.add(orbit));
        Collections.sort(orbits);
        int[] permutation = new int[atomCount];
        int newIndex = 0;
        for (SortableOrbit orbit3 : orbits) {
            for (int index : orbit3.members) {
                permutation[index] = newIndex++;
            }
        }
        return permutation;
    }

    private class SortableOrbit
    implements Comparable<SortableOrbit> {
        public String elementLabel;
        public String signatureLabel;
        public List<Integer> members;

        SortableOrbit(String elementLabel, String label) {
            this.signatureLabel = label;
            this.elementLabel = elementLabel;
            this.members = new ArrayList<Integer>();
        }

        public void sortMembers(int[] canonicalLabels) {
            Collections.sort(this.members, new OrbitLabelComparator(canonicalLabels));
        }

        @Override
        public int compareTo(SortableOrbit other) {
            int elementCompare = this.elementLabel.compareTo(other.elementLabel);
            if (elementCompare != 0) {
                return elementCompare;
            }
            return -this.signatureLabel.compareTo(other.signatureLabel);
        }
    }

    private class OrbitLabelComparator
    implements Comparator<Integer> {
        public int[] canonicalLabels;

        OrbitLabelComparator(int[] canonicalLabels) {
            this.canonicalLabels = canonicalLabels;
        }

        @Override
        public int compare(Integer label0, Integer label1) {
            if (this.canonicalLabels[label0] < this.canonicalLabels[label1]) {
                return -1;
            }
            if (this.canonicalLabels[label0] > this.canonicalLabels[label1]) {
                return 1;
            }
            return 0;
        }
    }
}

