/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.tools.labelling;

import java.util.Arrays;
import java.util.logging.Level;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.smiles.SmilesGenerator;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;
import uk.ac.ebi.reactionblast.tools.labelling.ICanonicalMoleculeLabeller;

public class SmilesMoleculeLabeller
implements ICanonicalMoleculeLabeller {
    private static final ILoggingTool LOGGER = LoggingToolFactory.createLoggingTool(SmilesMoleculeLabeller.class);

    @Override
    public IAtomContainer getCanonicalMolecule(IAtomContainer container) {
        try {
            IAtomContainer clone = container.clone();
            for (IAtom a : container.atoms()) {
                if (a.getID() == null) continue;
                int index = container.indexOf(a);
                clone.getAtom(index).setID(a.getID());
            }
            if (container.getID() != null) {
                clone.setID(container.getID());
            }
            int[] canonicalPermutation = this.getCanonicalPermutation(clone);
            this.getCanonicalPermutation(clone, canonicalPermutation);
            return clone;
        }
        catch (CloneNotSupportedException ex) {
            LOGGER.error(Level.SEVERE, null, ex);
            return null;
        }
    }

    @Override
    public int[] getCanonicalPermutation(IAtomContainer container) {
        int[] p = new int[container.getAtomCount()];
        try {
            SmilesGenerator.unique().create(container, p);
        }
        catch (CDKException ex) {
            LOGGER.error(Level.SEVERE, null, ex);
        }
        return p;
    }

    public void getCanonicalPermutation(IAtomContainer atomContainer, int[] p) {
        int n = atomContainer.getAtomCount();
        IAtom[] permutedAtoms = new IAtom[n];
        for (int i = 0; i < n; ++i) {
            IAtom atom;
            permutedAtoms[p[i]] = atom = atomContainer.getAtom(i);
            atom.setProperty("label", p[i]);
        }
        atomContainer.setAtoms(permutedAtoms);
        IBond[] bonds = AtomContainerManipulator.getBondArray(atomContainer);
        Arrays.sort(bonds, (o1, o2) -> {
            int u = (Integer)o1.getAtom(0).getProperty("label");
            int v = (Integer)o1.getAtom(1).getProperty("label");
            int x = (Integer)o2.getAtom(0).getProperty("label");
            int y = (Integer)o2.getAtom(1).getProperty("label");
            int min1 = Math.min(u, v);
            int min2 = Math.min(x, y);
            int max1 = Math.max(u, v);
            int max2 = Math.max(x, y);
            int minCmp = Integer.compare(min1, min2);
            if (minCmp != 0) {
                return minCmp;
            }
            int maxCmp = Integer.compare(max1, max2);
            if (maxCmp != 0) {
                return maxCmp;
            }
            LOGGER.debug("pokemon!");
            throw new InternalError();
        });
        atomContainer.setBonds(bonds);
    }
}

