/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.tools.matrix;

import java.io.Serializable;
import uk.ac.ebi.reactionblast.tools.EBIMatrix;

public class LUDecomposition
implements Serializable {
    private static final long serialVersionUID = 19978681017L;
    private final double[][] LU;
    private final int m;
    private final int n;
    private int pivsign;
    private final int[] piv;

    public LUDecomposition(EBIMatrix A) {
        this.LU = A.getArrayCopy();
        this.m = A.getRowDimension();
        this.n = A.getColumnDimension();
        this.piv = new int[this.m];
        for (int i = 0; i < this.m; ++i) {
            this.piv[i] = i;
        }
        this.pivsign = 1;
        double[] LUcolj = new double[this.m];
        for (int j = 0; j < this.n; ++j) {
            int i;
            int i2;
            for (i2 = 0; i2 < this.m; ++i2) {
                LUcolj[i2] = this.LU[i2][j];
            }
            i2 = 0;
            while (i2 < this.m) {
                double[] LUrowi = this.LU[i2];
                int kmax = Math.min(i2, j);
                double s = 0.0;
                for (int k = 0; k < kmax; ++k) {
                    s += LUrowi[k] * LUcolj[k];
                }
                int n = i2++;
                double d = LUcolj[n] - s;
                LUcolj[n] = d;
                LUrowi[j] = d;
            }
            int p = j;
            for (i = j + 1; i < this.m; ++i) {
                if (!(Math.abs(LUcolj[i]) > Math.abs(LUcolj[p]))) continue;
                p = i;
            }
            if (p != j) {
                int k;
                for (k = 0; k < this.n; ++k) {
                    double t = this.LU[p][k];
                    this.LU[p][k] = this.LU[j][k];
                    this.LU[j][k] = t;
                }
                k = this.piv[p];
                this.piv[p] = this.piv[j];
                this.piv[j] = k;
                this.pivsign = -this.pivsign;
            }
            if (!(j < this.m & this.LU[j][j] != 0.0)) continue;
            for (i = j + 1; i < this.m; ++i) {
                double[] dArray = this.LU[i];
                int n = j;
                dArray[n] = dArray[n] / this.LU[j][j];
            }
        }
    }

    public boolean isNonsingular() {
        for (int j = 0; j < this.n; ++j) {
            if (this.LU[j][j] != 0.0) continue;
            return false;
        }
        return true;
    }

    public EBIMatrix getL() {
        EBIMatrix X = new EBIMatrix(this.m, this.n);
        double[][] L = X.getArray();
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                L[i][j] = i > j ? this.LU[i][j] : (i == j ? 1.0 : 0.0);
            }
        }
        return X;
    }

    public EBIMatrix getU() {
        EBIMatrix X = new EBIMatrix(this.n, this.n);
        double[][] U = X.getArray();
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.n; ++j) {
                U[i][j] = i <= j ? this.LU[i][j] : 0.0;
            }
        }
        return X;
    }

    public int[] getPivot() {
        int[] p = new int[this.m];
        System.arraycopy(this.piv, 0, p, 0, this.m);
        return p;
    }

    public double[] getDoublePivot() {
        double[] vals = new double[this.m];
        for (int i = 0; i < this.m; ++i) {
            vals[i] = this.piv[i];
        }
        return vals;
    }

    public double det() {
        if (this.m != this.n) {
            throw new IllegalArgumentException("Matrix must be square.");
        }
        double d = this.pivsign;
        for (int j = 0; j < this.n; ++j) {
            d *= this.LU[j][j];
        }
        return d;
    }

    public EBIMatrix solve(EBIMatrix B) {
        int j;
        int i;
        int k;
        if (B.getRowDimension() != this.m) {
            throw new IllegalArgumentException("Matrix row dimensions must agree.");
        }
        if (!this.isNonsingular()) {
            throw new RuntimeException("Matrix is singular.");
        }
        int nx = B.getColumnDimension();
        EBIMatrix Xmat = B.getMatrix(this.piv, 0, nx - 1);
        double[][] X = Xmat.getArray();
        for (k = 0; k < this.n; ++k) {
            for (i = k + 1; i < this.n; ++i) {
                for (j = 0; j < nx; ++j) {
                    double[] dArray = X[i];
                    int n = j;
                    dArray[n] = dArray[n] - X[k][j] * this.LU[i][k];
                }
            }
        }
        for (k = this.n - 1; k >= 0; --k) {
            int j2 = 0;
            while (j2 < nx) {
                double[] dArray = X[k];
                int n = j2++;
                dArray[n] = dArray[n] / this.LU[k][k];
            }
            for (i = 0; i < k; ++i) {
                for (j = 0; j < nx; ++j) {
                    double[] dArray = X[i];
                    int n = j;
                    dArray[n] = dArray[n] - X[k][j] * this.LU[i][k];
                }
            }
        }
        return Xmat;
    }
}

