/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.tools.rxnfile;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.logging.Level;
import org.openscience.cdk.AtomContainer;
import org.openscience.cdk.ChemModel;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.geometry.GeometryUtil;
import org.openscience.cdk.graph.ConnectivityChecker;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.io.IChemObjectReader;
import org.openscience.cdk.io.MDLV3000Reader;
import org.openscience.cdk.layout.StructureDiagramGenerator;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.MoleculeSetManipulator;
import org.openscience.smsd.tools.ExtAtomContainerManipulator;
import uk.ac.ebi.reactionblast.tools.rxnfile.MDLV2000Reader;

public class MDLFileReader {
    private static IAtomContainer molecule = null;
    private static final ILoggingTool LOGGER = LoggingToolFactory.createLoggingTool(MDLFileReader.class);

    public MDLFileReader(InputStream inputStream, IChemObjectReader.Mode mode) throws IOException {
        block22: {
            try (MDLV2000Reader reader2 = new MDLV2000Reader(inputStream, mode);){
                molecule = reader2.read(new AtomContainer());
                reader2.close();
            }
            catch (CDKException e) {
                String string = e.toString();
                if (string.contains("This file must be read with the MDLV3000Reader.")) {
                    try (MDLV3000Reader reader22 = new MDLV3000Reader(inputStream, mode);){
                        molecule = reader22.read(new AtomContainer());
                        reader22.close();
                    }
                    catch (CDKException ex) {
                        LOGGER.error(Level.SEVERE, null, ex);
                    }
                }
                if (!string.contains("This file must be read with the MDLReader.")) break block22;
                try (MDLV2000Reader reader23 = new MDLV2000Reader(inputStream, mode);){
                    molecule = reader23.read(new AtomContainer());
                    reader23.close();
                }
                catch (CDKException ex) {
                    LOGGER.error(Level.SEVERE, null, ex);
                }
            }
        }
    }

    public MDLFileReader(InputStream inputStream) throws IOException, CDKException {
        this(inputStream, IChemObjectReader.Mode.RELAXED);
    }

    public MDLFileReader(Reader reader) throws IOException, CDKException {
        this(reader, IChemObjectReader.Mode.RELAXED);
    }

    public MDLFileReader(Reader reader, IChemObjectReader.Mode mode) throws IOException {
        block22: {
            try (MDLV2000Reader reader2 = new MDLV2000Reader(reader, mode);){
                molecule = reader2.read(new AtomContainer());
                reader2.close();
            }
            catch (CDKException e) {
                String string = e.toString();
                if (string.contains("This file must be read with the MDLV3000Reader.")) {
                    try (MDLV3000Reader reader22 = new MDLV3000Reader(reader, mode);){
                        try {
                            molecule = reader22.read(new AtomContainer());
                            reader22.close();
                        }
                        catch (CDKException ex) {
                            LOGGER.error(Level.SEVERE, null, ex);
                        }
                    }
                }
                if (!string.contains("This file must be read with the MDLReader.")) break block22;
                try (MDLV2000Reader reader23 = new MDLV2000Reader(reader, mode);){
                    molecule = reader23.read(new AtomContainer());
                    reader23.close();
                }
                catch (CDKException ex) {
                    LOGGER.error(Level.SEVERE, null, ex);
                }
            }
        }
    }

    public IAtomContainer getAtomContainer() {
        return molecule;
    }

    public IAtomContainer getMoleculeWithLayoutCheck() {
        if (!GeometryUtil.has2DCoordinates(molecule)) {
            try {
                StructureDiagramGenerator sdg = new StructureDiagramGenerator(new AtomContainer(molecule));
                sdg.generateCoordinates();
                molecule = sdg.getMolecule();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return molecule;
    }

    public IChemModel getChemModelWithMoleculeWithLayoutCheck() {
        ChemModel chemModel = new ChemModel();
        chemModel.setMoleculeSet(ConnectivityChecker.partitionIntoMolecules(molecule));
        for (IAtomContainer ac : MoleculeSetManipulator.getAllAtomContainers(chemModel.getMoleculeSet())) {
            if (GeometryUtil.has2DCoordinates(ac)) continue;
            try {
                IAtomContainer mol = ac.getBuilder().newInstance(IAtomContainer.class, ac);
                ExtAtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(mol);
                StructureDiagramGenerator sdg = new StructureDiagramGenerator(new AtomContainer(mol));
                sdg.generateCoordinates();
                ac = sdg.getMolecule();
            }
            catch (IllegalArgumentException | CDKException e) {
                e.printStackTrace();
            }
        }
        return chemModel;
    }
}

