/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.tools.rxnfile;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.NumberFormat;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IMapping;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.interfaces.IReactionSet;
import org.openscience.cdk.io.DefaultChemObjectWriter;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.formats.MDLFormat;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import uk.ac.ebi.reactionblast.tools.rxnfile.MDLV2000Writer;

public class MDLV2000RXNWriter
extends DefaultChemObjectWriter {
    private static ILoggingTool LOGGER = LoggingToolFactory.createLoggingTool(MDLV2000RXNWriter.class);
    private BufferedWriter writer;
    private int reactionNumber;
    public Map rdFields = null;

    public MDLV2000RXNWriter(Writer out) {
        try {
            this.writer = out instanceof BufferedWriter ? (BufferedWriter)out : new BufferedWriter(out);
        }
        catch (Exception ex) {
            LOGGER.error(ex);
        }
        this.reactionNumber = 1;
    }

    public MDLV2000RXNWriter(OutputStream output) {
        this(new OutputStreamWriter(output));
    }

    public MDLV2000RXNWriter() {
        this(new StringWriter());
    }

    @Override
    public IResourceFormat getFormat() {
        return MDLFormat.getInstance();
    }

    @Override
    public void setWriter(Writer out) throws CDKException {
        this.writer = out instanceof BufferedWriter ? (BufferedWriter)out : new BufferedWriter(out);
    }

    @Override
    public void setWriter(OutputStream output) throws CDKException {
        this.setWriter(new OutputStreamWriter(output));
    }

    public void setRdFields(Map map) {
        this.rdFields = map;
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    public boolean accepts(Class classObject) {
        Class<?>[] interfaces;
        for (Class<?> intf : interfaces = classObject.getInterfaces()) {
            if (IReaction.class.equals(intf)) {
                return true;
            }
            if (!IReactionSet.class.equals(intf)) continue;
            return true;
        }
        Class superClass = classObject.getSuperclass();
        if (superClass != null) {
            return this.accepts(superClass);
        }
        return false;
    }

    @Override
    public void write(IChemObject object) throws CDKException {
        if (object instanceof IReactionSet) {
            this.writeReactionSet((IReactionSet)object);
        } else if (object instanceof IReaction) {
            this.writeReaction((IReaction)object);
        } else {
            throw new CDKException("Only supported is writing ReactionSet, Reaction objects.");
        }
    }

    private void writeReactionSet(IReactionSet reactions) throws CDKException {
        Iterator<IReaction> it = reactions.reactions().iterator();
        while (it.hasNext()) {
            this.writeReaction(it.next());
        }
    }

    /*
     * WARNING - void declaration
     */
    private void writeReaction(IReaction reaction) throws CDKException {
        int reactantCount = 0;
        for (IAtomContainer iAtomContainer : reaction.getReactants().atomContainers()) {
            reactantCount += reaction.getReactantCoefficient(iAtomContainer).intValue();
        }
        int productCount = 0;
        for (IAtomContainer p : reaction.getProducts().atomContainers()) {
            productCount += reaction.getProductCoefficient(p).intValue();
        }
        if (reactantCount <= 0 || productCount <= 0) {
            throw new CDKException("Either no reactants or no products present.");
        }
        try {
            void var4_16;
            void var4_14;
            void var4_11;
            void var4_9;
            if (this.reactionNumber == 2) {
                this.writer.write("$$$$");
                this.writer.newLine();
            }
            this.writer.write("$RXN");
            this.writer.newLine();
            String string = (String)reaction.getProperty("cdk:Title");
            if (string == null) {
                String rid = reaction.getID() == null ? "" : reaction.getID();
                String string2 = "  EC-BLAST     " + rid;
            }
            if (var4_9.length() > 80) {
                String string3 = var4_9.substring(0, 80);
            }
            this.writer.newLine();
            this.writer.write((String)var4_11);
            this.writer.newLine();
            String string4 = (String)reaction.getProperty("cdk:Remark");
            if (string4 == null) {
                String string5 = "";
            }
            if (var4_14.length() > 80) {
                String string6 = var4_14.substring(0, 80);
            }
            this.writer.write((String)var4_16);
            this.writer.newLine();
            String string9 = "";
            string9 = string9 + this.formatMDLInt(reactantCount, 3);
            string9 = string9 + this.formatMDLInt(productCount, 3);
            this.writer.write(string9);
            this.writer.newLine();
            int i = 0;
            for (IMapping mapping : reaction.mappings()) {
                Iterator<IChemObject> it = mapping.relatedChemObjects().iterator();
                if (it.next().getProperty("cdk:AtomAtomMapping") != null) continue;
                it.next().setProperty("cdk:AtomAtomMapping", i + 1);
                it.next().setProperty("cdk:AtomAtomMapping", i + 1);
                ++i;
            }
            this.writeMoleculeSet(reaction.getReactants());
            this.writeMoleculeSet(reaction.getProducts());
            if (this.rdFields != null) {
                Set set = this.rdFields.keySet();
                for (Object element : set) {
                    this.writer.write("> <" + element + ">");
                    this.writer.newLine();
                    this.writer.write(this.rdFields.get(element).toString());
                    this.writer.newLine();
                    this.writer.newLine();
                }
            }
            if (this.reactionNumber != 1) {
                this.writer.write("$$$$");
                this.writer.newLine();
            }
            ++this.reactionNumber;
        }
        catch (IOException iOException) {
            LOGGER.error(iOException.getMessage());
            LOGGER.debug(iOException);
            throw new CDKException("Exception while writing MDL file: " + iOException.getMessage(), iOException);
        }
    }

    private void writeMoleculeSet(IAtomContainerSet som) throws IOException, CDKException {
        for (int i = 0; i < som.getAtomContainerCount(); ++i) {
            IAtomContainer mol = som.getAtomContainer(i);
            int j = 0;
            while ((double)j < som.getMultiplier(i)) {
                StringWriter sw = new StringWriter();
                this.writer.write("$MOL");
                this.writer.newLine();
                MDLV2000Writer mdlwriter = null;
                try {
                    mdlwriter = new MDLV2000Writer(sw);
                }
                catch (Exception ex) {
                    LOGGER.error(ex.getMessage());
                    LOGGER.debug(ex);
                    throw new CDKException("Exception while creating MDLWriter: " + ex.getMessage(), ex);
                }
                mdlwriter.write(mol);
                this.writer.write(sw.toString());
                ++j;
            }
        }
    }

    private String formatMDLInt(int i, int l) {
        String s = "";
        Object fs = "";
        NumberFormat nf = NumberFormat.getNumberInstance(Locale.ENGLISH);
        nf.setParseIntegerOnly(true);
        nf.setMinimumIntegerDigits(1);
        nf.setMaximumIntegerDigits(l);
        nf.setGroupingUsed(false);
        s = nf.format(i);
        l -= s.length();
        for (int f = 0; f < l; ++f) {
            fs = (String)fs + " ";
        }
        fs = (String)fs + s;
        return fs;
    }
}

