/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.tools.rxnfile;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.graph.ConnectivityChecker;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.io.IChemObjectReader;
import org.openscience.cdk.silent.SilentChemObjectBuilder;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import uk.ac.ebi.reactionblast.tools.EBIMolSplitter;
import uk.ac.ebi.reactionblast.tools.rxnfile.MDLRXNV2000Reader;

public class RXNFileImporter {
    public static final String RXN = "$RXN";
    private static final ILoggingTool LOGGER = LoggingToolFactory.createLoggingTool(RXNFileImporter.class);
    private IReaction reaction;
    protected IAtomContainer atomContainer;
    int nProducts;
    int nReactants;

    public void readFile(String File2) throws IOException {
        try {
            BufferedInputStream RXNFile = new BufferedInputStream(new FileInputStream(File2));
            this.reaction = SilentChemObjectBuilder.getInstance().newInstance(IReaction.class, new Object[0]);
            try (MDLRXNV2000Reader reader = new MDLRXNV2000Reader(RXNFile, IChemObjectReader.Mode.STRICT);){
                this.reaction = reader.read(this.reaction);
            }
        }
        catch (CDKException cdkerr) {
            System.out.println("Error: only RXN V2000 file format is supported by this Software");
            LOGGER.debug("Error: " + cdkerr);
        }
        catch (FileNotFoundException e) {
            LOGGER.debug("Error: RXN File not found" + e);
        }
    }

    public IAtomContainerSet getReactants() {
        return this.getMolecules(this.reaction.getReactants());
    }

    public IAtomContainerSet getProducts() {
        return this.getMolecules(this.reaction.getProducts());
    }

    public IReaction getReaction() {
        return this.reaction;
    }

    private IAtomContainerSet getMolecules(IAtomContainerSet BigMol) {
        IAtomContainerSet SplitMoleculeList = SilentChemObjectBuilder.getInstance().newInstance(IAtomContainerSet.class, new Object[0]);
        for (int j = 0; j < BigMol.getAtomContainerCount(); ++j) {
            IAtomContainer molecules = BigMol.getAtomContainer(j);
            if (!ConnectivityChecker.isConnected(molecules)) {
                IAtomContainerSet splitMol = EBIMolSplitter.splitMolecules(molecules);
                for (int i = 0; i < splitMol.getAtomContainerCount(); ++i) {
                    IAtomContainer mol = splitMol.getAtomContainer(i);
                    SplitMoleculeList.addAtomContainer(mol);
                }
                continue;
            }
            SplitMoleculeList.addAtomContainer(molecules);
        }
        return SplitMoleculeList;
    }

    private void printAtoms(IAtomContainer mol) {
        System.out.print("Atom: ");
        for (IAtom a : mol.atoms()) {
            System.out.print(a.getSymbol());
        }
        System.out.println();
        System.out.println();
    }

    private void printRadicalAtoms(IAtomContainer mol) {
        System.out.print("Atom: ");
        Integer a = 0;
        while (a < mol.getSingleElectronCount()) {
            System.out.print(mol.getSingleElectron(a).getAtom().getSymbol());
            System.out.print(mol.getSingleElectron(a).getElectronCount());
            Integer n = a;
            a = a + 1;
        }
        System.out.println();
        System.out.println();
    }
}

