"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AccountPrivilege = exports.AccountPrivilegeProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const polardb_generated_1 = require("./polardb.generated");
Object.defineProperty(exports, "AccountPrivilegeProperty", { enumerable: true, get: function () { return polardb_generated_1.RosAccountPrivilege; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::POLARDB::AccountPrivilege`, which is used to grant access permissions on one or more databases in a specified ApsaraDB for POLARDB cluster to a standard account.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosAccountPrivilege`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-polardb-accountprivilege
 */
class AccountPrivilege extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosAccountPrivilege = new polardb_generated_1.RosAccountPrivilege(this, id, {
            accountPrivilege: props.accountPrivilege,
            dbClusterId: props.dbClusterId,
            dbName: props.dbName,
            accountName: props.accountName,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosAccountPrivilege;
    }
}
exports.AccountPrivilege = AccountPrivilege;
//# sourceMappingURL=data:application/json;base64,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