"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DBNodeClasses = exports.DBNodeClassesProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const polardb_generated_1 = require("./polardb.generated");
Object.defineProperty(exports, "DBNodeClassesProperty", { enumerable: true, get: function () { return polardb_generated_1.RosDBNodeClasses; } });
/**
 * This class encapsulates and extends the ROS resource type `DATASOURCE::POLARDB::DBNodeClasses`, which is used to query available PolarDB cluster resources.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosDBNodeClasses`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/datasource-polardb-dbnodeclasses
 */
class DBNodeClasses extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosDBNodeClasses = new polardb_generated_1.RosDBNodeClasses(this, id, {
            dbVersion: props.dbVersion,
            zoneId: props.zoneId,
            dbType: props.dbType,
            payType: props.payType === undefined || props.payType === null ? 'Postpaid' : props.payType,
            dbNodeClass: props.dbNodeClass,
            refreshOptions: props.refreshOptions === undefined || props.refreshOptions === null ? 'Never' : props.refreshOptions,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosDBNodeClasses;
        this.attrDbNodeClassIds = rosDBNodeClasses.attrDbNodeClassIds;
        this.attrDbNodeClasses = rosDBNodeClasses.attrDbNodeClasses;
    }
}
exports.DBNodeClasses = DBNodeClasses;
//# sourceMappingURL=data:application/json;base64,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