"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GlobalDatabaseNetwork = exports.GlobalDatabaseNetworkProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const polardb_generated_1 = require("./polardb.generated");
Object.defineProperty(exports, "GlobalDatabaseNetworkProperty", { enumerable: true, get: function () { return polardb_generated_1.RosGlobalDatabaseNetwork; } });
/**
 * This class encapsulates and extends the ROS resource type `DATASOURCE::POLARDB::GlobalDatabaseNetwork`, which is used to query the details of a Global Database Network (GDN) within the current Alibaba Cloud account.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosGlobalDatabaseNetwork`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/datasource-polardb-globaldatabasenetwork
 */
class GlobalDatabaseNetwork extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosGlobalDatabaseNetwork = new polardb_generated_1.RosGlobalDatabaseNetwork(this, id, {
            gdnId: props.gdnId,
            refreshOptions: props.refreshOptions === undefined || props.refreshOptions === null ? 'Never' : props.refreshOptions,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosGlobalDatabaseNetwork;
        this.attrConnections = rosGlobalDatabaseNetwork.attrConnections;
        this.attrCreateTime = rosGlobalDatabaseNetwork.attrCreateTime;
        this.attrDbClusters = rosGlobalDatabaseNetwork.attrDbClusters;
        this.attrDbType = rosGlobalDatabaseNetwork.attrDbType;
        this.attrDbVersion = rosGlobalDatabaseNetwork.attrDbVersion;
        this.attrGdnDescription = rosGlobalDatabaseNetwork.attrGdnDescription;
        this.attrGdnId = rosGlobalDatabaseNetwork.attrGdnId;
    }
}
exports.GlobalDatabaseNetwork = GlobalDatabaseNetwork;
//# sourceMappingURL=data:application/json;base64,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