"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DBCluster = exports.DBClusterProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const polardb_generated_1 = require("./polardb.generated");
Object.defineProperty(exports, "DBClusterProperty", { enumerable: true, get: function () { return polardb_generated_1.RosDBCluster; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::POLARDB::DBCluster`, which is used to create a PolarDB cluster.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosDBCluster`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-polardb-dbcluster
 */
class DBCluster extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosDBCluster = new polardb_generated_1.RosDBCluster(this, id, {
            defaultTimeZone: props.defaultTimeZone,
            gdnId: props.gdnId,
            resourceGroupId: props.resourceGroupId,
            storagePayType: props.storagePayType,
            backupRetentionPolicyOnClusterDeletion: props.backupRetentionPolicyOnClusterDeletion,
            looseXEngine: props.looseXEngine,
            dbType: props.dbType,
            storageAutoScale: props.storageAutoScale,
            proxyClass: props.proxyClass,
            dbVersion: props.dbVersion,
            dbMinorVersion: props.dbMinorVersion,
            dbClusterParameters: props.dbClusterParameters,
            tags: props.tags,
            tdeStatus: props.tdeStatus,
            storageType: props.storageType,
            architecture: props.architecture,
            vSwitchId: props.vSwitchId,
            renewalStatus: props.renewalStatus === undefined || props.renewalStatus === null ? 'Normal' : props.renewalStatus,
            dbClusterDescription: props.dbClusterDescription,
            period: props.period,
            payType: props.payType,
            deletionProtection: props.deletionProtection,
            provisionedIops: props.provisionedIops,
            securityGroupIds: props.securityGroupIds,
            allowShutDown: props.allowShutDown,
            loosePolarLogBin: props.loosePolarLogBin,
            vpcId: props.vpcId,
            proxyType: props.proxyType,
            dbNodeNum: props.dbNodeNum,
            periodUnit: props.periodUnit,
            storageUpperBound: props.storageUpperBound,
            cloneDataPoint: props.cloneDataPoint === undefined || props.cloneDataPoint === null ? 'LATEST' : props.cloneDataPoint,
            hotStandbyCluster: props.hotStandbyCluster,
            sourceResourceId: props.sourceResourceId,
            scaleRoNumMin: props.scaleRoNumMin,
            clusterNetworkType: props.clusterNetworkType === undefined || props.clusterNetworkType === null ? 'VPC' : props.clusterNetworkType,
            securityIpList: props.securityIpList,
            maintainTime: props.maintainTime,
            standbyAz: props.standbyAz,
            lowerCaseTableNames: props.lowerCaseTableNames,
            autoRenewPeriod: props.autoRenewPeriod === undefined || props.autoRenewPeriod === null ? 1 : props.autoRenewPeriod,
            zoneId: props.zoneId,
            coldStorageOption: props.coldStorageOption,
            scaleRoNumMax: props.scaleRoNumMax,
            looseXEngineUseMemoryPct: props.looseXEngineUseMemoryPct,
            scaleMax: props.scaleMax,
            creationCategory: props.creationCategory,
            strictConsistency: props.strictConsistency,
            dbNodeClass: props.dbNodeClass,
            creationOption: props.creationOption === undefined || props.creationOption === null ? 'Normal' : props.creationOption,
            parameterGroupId: props.parameterGroupId,
            storageSpace: props.storageSpace,
            serverlessType: props.serverlessType,
            restartMasterNode: props.restartMasterNode,
            scaleMin: props.scaleMin,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosDBCluster;
        this.attrClusterConnectionString = rosDBCluster.attrClusterConnectionString;
        this.attrClusterEndpointId = rosDBCluster.attrClusterEndpointId;
        this.attrColdStorageInstanceId = rosDBCluster.attrColdStorageInstanceId;
        this.attrCustomConnectionStrings = rosDBCluster.attrCustomConnectionStrings;
        this.attrCustomEndpointIds = rosDBCluster.attrCustomEndpointIds;
        this.attrDbClusterDescription = rosDBCluster.attrDbClusterDescription;
        this.attrDbClusterId = rosDBCluster.attrDbClusterId;
        this.attrDbNodeIds = rosDBCluster.attrDbNodeIds;
        this.attrOrderId = rosDBCluster.attrOrderId;
        this.attrPrimaryConnectionString = rosDBCluster.attrPrimaryConnectionString;
        this.attrPrimaryConnectionStrings = rosDBCluster.attrPrimaryConnectionStrings;
        this.attrPrimaryEndpointId = rosDBCluster.attrPrimaryEndpointId;
        this.attrPrimaryEndpointIds = rosDBCluster.attrPrimaryEndpointIds;
    }
}
exports.DBCluster = DBCluster;
//# sourceMappingURL=data:application/json;base64,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