"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DBClusterAccessWhiteList = exports.DBClusterAccessWhiteListProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const polardb_generated_1 = require("./polardb.generated");
Object.defineProperty(exports, "DBClusterAccessWhiteListProperty", { enumerable: true, get: function () { return polardb_generated_1.RosDBClusterAccessWhiteList; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::POLARDB::DBClusterAccessWhiteList`, which is used to modify the list of IP addresses that are allowed to access an ApsaraDB for POLARDB cluster.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosDBClusterAccessWhiteList`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-polardb-dbclusteraccesswhitelist
 */
class DBClusterAccessWhiteList extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosDBClusterAccessWhiteList = new polardb_generated_1.RosDBClusterAccessWhiteList(this, id, {
            securityIps: props.securityIps,
            dbClusterIpArrayName: props.dbClusterIpArrayName,
            dbClusterId: props.dbClusterId,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosDBClusterAccessWhiteList;
        this.attrDbClusterId = rosDBClusterAccessWhiteList.attrDbClusterId;
    }
}
exports.DBClusterAccessWhiteList = DBClusterAccessWhiteList;
//# sourceMappingURL=data:application/json;base64,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