"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DBClusterEndpoint = exports.DBClusterEndpointProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const polardb_generated_1 = require("./polardb.generated");
Object.defineProperty(exports, "DBClusterEndpointProperty", { enumerable: true, get: function () { return polardb_generated_1.RosDBClusterEndpoint; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::POLARDB::DBClusterEndpoint`, which is used to create a custom endpoint for a PolarDB cluster.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosDBClusterEndpoint`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-polardb-dbclusterendpoint
 */
class DBClusterEndpoint extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosDBClusterEndpoint = new polardb_generated_1.RosDBClusterEndpoint(this, id, {
            autoAddNewNodes: props.autoAddNewNodes === undefined || props.autoAddNewNodes === null ? 'Disable' : props.autoAddNewNodes,
            dbClusterId: props.dbClusterId,
            endpointType: props.endpointType === undefined || props.endpointType === null ? 'Custom' : props.endpointType,
            readWriteMode: props.readWriteMode === undefined || props.readWriteMode === null ? 'ReadOnly' : props.readWriteMode,
            nodes: props.nodes,
            endpointConfig: props.endpointConfig,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosDBClusterEndpoint;
        this.attrAddresses = rosDBClusterEndpoint.attrAddresses;
        this.attrConnectionString = rosDBClusterEndpoint.attrConnectionString;
        this.attrDbEndpointId = rosDBClusterEndpoint.attrDbEndpointId;
    }
}
exports.DBClusterEndpoint = DBClusterEndpoint;
//# sourceMappingURL=data:application/json;base64,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