"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DBNodes = exports.DBNodesProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const polardb_generated_1 = require("./polardb.generated");
Object.defineProperty(exports, "DBNodesProperty", { enumerable: true, get: function () { return polardb_generated_1.RosDBNodes; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::POLARDB::DBNodes`, which is used to add nodes to a PolarDB cluster.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosDBNodes`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-polardb-dbnodes
 */
class DBNodes extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosDBNodes = new polardb_generated_1.RosDBNodes(this, id, {
            resourceGroupId: props.resourceGroupId,
            amount: props.amount,
            dbClusterId: props.dbClusterId,
            plannedStartTime: props.plannedStartTime,
            endpointBindList: props.endpointBindList,
            imciSwitch: props.imciSwitch,
            dbNodeType: props.dbNodeType,
            plannedEndTime: props.plannedEndTime,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosDBNodes;
        this.attrDbNodeIds = rosDBNodes.attrDbNodeIds;
        this.attrOrderIds = rosDBNodes.attrOrderIds;
    }
}
exports.DBNodes = DBNodes;
//# sourceMappingURL=data:application/json;base64,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