# coding=utf-8
from __future__ import absolute_import, print_function

import collections
import functools
import time


def merge(*dicts):
    def _merge(result, item):
        result.update(item)
        return result

    return functools.reduce(_merge, dicts, {})


def count(iterable):
    if hasattr(iterable, "__len__"):
        return len(iterable)

    d = collections.deque(enumerate(iterable, 1), maxlen=1)
    return d[0][0] if d else 0


def shorten(value, maxlen=80):
    string = str(value)
    return string[: maxlen - 3] + "..." if len(string) > maxlen else string


class FrequenceTimeLimiter(object):
    def __init__(self, seconds):
        self.frequence = seconds
        self.time = time.time()

    def ifEnable(self):
        newTime = time.time()
        enable = self.frequence < newTime - self.time
        self.time = newTime if enable else self.time
        return enable


def encode(data):
    if isinstance(data, str):
        data = data.encode()
    return data


def decode(data):
    if isinstance(data, bytes):
        data = data.decode()
    return data


def lazyproperty(func):
    attrname = "_lazy_" + func.__name__

    @property
    def _lazyproperty(self):
        if not hasattr(self, attrname):
            setattr(self, attrname, func(self))
        return getattr(self, attrname)

    return _lazyproperty
