# https://github.com/Klipper3d/klipper/blob/master/klippy/stepper.py
from typing import Literal, Protocol

from mcu import MCU, MCU_endstop

type _Pos = list[float]

class MCU_stepper:
    def get_mcu(self) -> MCU: ...
    def get_name(self, short: bool = False) -> str: ...
    def get_commanded_position(self) -> _Pos: ...
    def is_active_axis(self, axis: Literal["x", "y", "z", "e"]) -> bool: ...
    def get_mcu_position(self) -> int: ...
    def mcu_to_commanded_position(self, mcu_pos: int) -> float: ...
    def get_past_mcu_position(self, print_time: float) -> int: ...

class GenericPrinterRail(Protocol):
    def get_steppers(self) -> list[MCU_stepper]: ...
    def get_endstops(self) -> list[tuple[MCU_endstop, str]]: ...
